/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.PropertyResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DlgView
extends JDialog
implements ActionListener {
    private JBeam controller;
    private JTextField baseSize;
    private JTextField displacementScale;
    private JTextField momentScale;
    private JTextField normalForceScale;
    private JTextField shearForceScale;

    public DlgView(Frame parent, JBeam controller) {
        super(parent, "Results", true);
        this.controller = controller;
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            Container dlg = this.getContentPane();
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            dlg.setLayout(gb);
            this.baseSize = new JTextField(String.valueOf(controller.view.getBaseSize()));
            JLabel l = new JLabel(locale.getString("DlgViewBaseSize"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.baseSize, c);
            dlg.add(this.baseSize);
            this.displacementScale = new JTextField(String.valueOf(controller.view.getDisplacementScale()));
            l = new JLabel(locale.getString("DlgViewDisplacementScale"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.displacementScale, c);
            dlg.add(this.displacementScale);
            this.momentScale = new JTextField(String.valueOf(controller.view.getMomentScale()));
            l = new JLabel(locale.getString("DlgViewMomentScale"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.momentScale, c);
            dlg.add(this.momentScale);
            this.normalForceScale = new JTextField(String.valueOf(controller.view.getNormalForceScale()));
            l = new JLabel(locale.getString("DlgViewNormalForceScale"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.normalForceScale, c);
            dlg.add(this.normalForceScale);
            this.shearForceScale = new JTextField(String.valueOf(controller.view.getShearForceScale()));
            l = new JLabel(locale.getString("DlgViewShearForceScale"));
            c.weightx = 0.2;
            c.gridwidth = -1;
            gb.setConstraints(l, c);
            dlg.add(l);
            c.weightx = 1.0;
            c.gridwidth = 0;
            gb.setConstraints(this.shearForceScale, c);
            dlg.add(this.shearForceScale);
            JPanel bbar = new JPanel();
            JButton button = new JButton(locale.getString("DlgOK"));
            button.addActionListener(this);
            bbar.add(button);
            button = new JButton(locale.getString("DlgCancel"));
            button.addActionListener(this);
            bbar.add(button);
            gb.setConstraints(bbar, c);
            dlg.add(bbar);
            if (parent != null) {
                this.setLocation(parent.getLocation().x + 100, parent.getLocation().y + 100);
            } else {
                this.setLocation(300, 200);
            }
            this.setResizable(false);
            this.pack();
            this.setSize(350, this.getSize().height);
            this.setVisible(true);
        }
        catch (Exception e) {
            System.out.println("DlgEBBeam build error: " + e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        boolean canClose = true;
        if (event.getActionCommand().equals("OK")) {
            try {
                this.controller.view.setBaseSize(new Double(this.baseSize.getText()));
                this.controller.view.setDisplacementScale(new Double(this.displacementScale.getText()));
                this.controller.view.setMomentScale(new Double(this.momentScale.getText()));
                this.controller.view.setNormalForceScale(new Double(this.normalForceScale.getText()));
                this.controller.view.setShearForceScale(new Double(this.shearForceScale.getText()));
            }
            catch (NumberFormatException e) {
                canClose = false;
                JOptionPane.showMessageDialog(null, "Please enter a valid number", "Number Format Error", 0);
            }
        }
        if (canClose) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

