/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.CatchingEventQueue;
import com.schwebke.jbeam.DlgEBBeam;
import com.schwebke.jbeam.DlgEBSBeam;
import com.schwebke.jbeam.DlgGrid;
import com.schwebke.jbeam.DlgInfo;
import com.schwebke.jbeam.DlgNode;
import com.schwebke.jbeam.DlgSectionalVals;
import com.schwebke.jbeam.DlgTruss;
import com.schwebke.jbeam.DlgView;
import com.schwebke.jbeam.Launcher;
import com.schwebke.jbeam.MainButtonBar;
import com.schwebke.jbeam.MainMenuBar;
import com.schwebke.jbeam.applet.JBeamApplet;
import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.EBSBeam;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.model.SelectableModel;
import com.schwebke.jbeam.model.Truss;
import com.schwebke.jbeam.plugin.IHost;
import com.schwebke.jbeam.plugin.IModel;
import com.schwebke.jbeam.tool.ExampleFileFilter;
import com.schwebke.jbeam.view.HtmlView;
import com.schwebke.jbeam.view.TextView;
import com.schwebke.jbeam.view.View;
import com.schwebke.math.Round;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class JBeam
implements IHost {
    View view;
    SelectableModel model;
    NumberFormat numberFormat;
    private JFrame mainFrame;
    private MainMenuBar menuBar;
    private MainButtonBar buttonBar;
    private Launcher launcher;
    private JLabel status;
    private JLabel mode;
    private JLabel posX;
    private JLabel posY;
    private String addElementType;
    public static final String version = "4.0.0";
    public static final String verdate = "2012-01-01";
    File fileChooseDir;
    double grid;
    int checkR;
    double EA;
    double EI;
    double GAs;
    double m;
    private boolean lock;

    public JBeam(Launcher launcher) {
        System.out.println("JBeam 4.0.0 / 2012-01-01");
        CatchingEventQueue.installErrorDialogueHandler();
        this.fileChooseDir = new File(System.getProperty("user.dir"));
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMinimumFractionDigits(3);
        this.numberFormat.setMaximumFractionDigits(3);
        this.addElementType = null;
        this.lock = false;
        this.launcher = launcher;
        this.mainFrame = new JFrame("JBeam");
        Image icon = this.mainFrame.getToolkit().getImage("resourcen/icon.gif");
        this.mainFrame.setIconImage(icon);
        this.mainFrame.setLocation(200, 100);
        this.model = new SelectableModel();
        this.mainFrame.setDefaultCloseOperation(0);
        this.mainFrame.addWindowListener(new JBeamWindowListener());
        this.menuBar = new MainMenuBar(new JBeamActionListener());
        this.mainFrame.setJMenuBar(this.menuBar);
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.view = new View(this.model, this);
        this.view.addMouseListener(new JBeamViewMouseListener());
        this.view.addMouseMotionListener(new JBeamViewMouseMotionListener());
        this.view.addMouseWheelListener(new JBeamViewMouseWheelListener());
        this.view.setPreferredSize(new Dimension(600, 400));
        JPanel sbar = new JPanel(new FlowLayout(0));
        this.status = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        sbar.add(this.status);
        this.posX = new JLabel("XXXXXXXXXX");
        this.posY = new JLabel("XXXXXXXXXX");
        sbar.add(this.posX);
        sbar.add(this.posY);
        this.mode = new JLabel("XXXXXXXXXXXXXXXXXXXX");
        sbar.add(this.mode);
        this.buttonBar = new MainButtonBar(new JBeamActionListener());
        this.initApp();
        this.mainFrame.getContentPane().add("South", sbar);
        this.mainFrame.getContentPane().add("Center", this.view);
        this.mainFrame.getContentPane().add("North", this.buttonBar);
        this.mainFrame.pack();
        this.mainFrame.setVisible(true);
        this.status.setPreferredSize(this.status.getSize());
        this.mode.setPreferredSize(this.mode.getSize());
        this.posX.setPreferredSize(this.posX.getSize());
        this.posY.setPreferredSize(this.posY.getSize());
        this.status.setText("ready");
        this.mode.setText("select");
        this.posX.setText("X: -");
        this.posY.setText("Z: -");
    }

    public JBeam(JBeamApplet jbApplet) {
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMinimumFractionDigits(3);
        this.numberFormat.setMaximumFractionDigits(3);
        this.addElementType = null;
        this.lock = false;
        this.launcher = null;
        this.mainFrame = null;
        this.model = new SelectableModel();
        this.menuBar = new MainMenuBar(new JBeamActionListener());
        jbApplet.setJMenuBar(this.menuBar);
        jbApplet.getContentPane().setLayout(new BorderLayout());
        this.view = new View(this.model, this);
        this.view.addMouseListener(new JBeamViewMouseListener());
        this.view.addMouseMotionListener(new JBeamViewMouseMotionListener());
        this.view.addMouseWheelListener(new JBeamViewMouseWheelListener());
        JPanel sbar = new JPanel(new FlowLayout(0));
        this.status = new JLabel();
        sbar.add(this.status);
        this.posX = new JLabel();
        this.posY = new JLabel();
        sbar.add(this.posX);
        sbar.add(this.posY);
        this.mode = new JLabel();
        sbar.add(this.mode);
        this.buttonBar = new MainButtonBar(new JBeamActionListener());
        this.initApp();
        jbApplet.getContentPane().add("South", sbar);
        jbApplet.getContentPane().add("Center", this.view);
        jbApplet.getContentPane().add("North", this.buttonBar);
        this.status.setText("ready");
        this.mode.setText("select");
        this.posX.setText("X: -");
        this.posY.setText("Z: -");
    }

    private void initApp() {
        this.grid = 1.0;
        this.checkR = 5;
        this.EA = 100000.0;
        this.EI = 10000.0;
        this.GAs = 1.0E15;
        this.m = 1.0;
        this.menuBar.initMenuBar();
        this.buttonBar.initButtonBar();
    }

    private void updateCursorShape() {
        String modeText = this.mode.getText();
        if (modeText.equals("info")) {
            this.view.setCursor(Cursor.getPredefinedCursor(12));
        } else if (modeText.startsWith("add") || modeText.startsWith("element")) {
            this.view.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.view.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void resetApp() {
        this.model.clearModel();
        this.initApp();
        this.view.reset();
        this.view.repaint();
    }

    private void exitApp() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        System.out.println("JBeam shutdown");
        this.launcher.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockUI() {
        JBeam jBeam = this;
        synchronized (jBeam) {
            if (!this.lock) {
                this.status.setText("locked");
                this.lock = true;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockUI() {
        JBeam jBeam = this;
        synchronized (jBeam) {
            this.status.setText("ready");
            this.lock = false;
            this.view.repaint();
        }
    }

    public double snap(double v) {
        if (this.grid > 1.0E-10) {
            return (double)Math.round(v / this.grid) * this.grid;
        }
        return v;
    }

    boolean isFree(double x, double z) {
        int n = this.model.addSelection(x, z, this.view.worldScale(this.checkR), this.view);
        this.model.clearSelection();
        return n <= 0;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public String format(double value) {
        int digits = 4 - (int)Math.ceil(Math.log(Math.max(Math.abs(value), 1.0E-8)) / Math.log(10.0));
        return this.format(value, digits);
    }

    public String format(double value, int digits) {
        int currentDigitsMax = this.numberFormat.getMaximumFractionDigits();
        int currentDigitsMin = this.numberFormat.getMinimumFractionDigits();
        if (digits > 0) {
            this.numberFormat.setMaximumFractionDigits(digits);
            this.numberFormat.setMinimumFractionDigits(digits);
        } else {
            this.numberFormat.setMaximumFractionDigits(0);
            this.numberFormat.setMinimumFractionDigits(0);
        }
        String vStr = this.numberFormat.format(Round.digits(value, digits));
        this.numberFormat.setMaximumFractionDigits(currentDigitsMax);
        this.numberFormat.setMinimumFractionDigits(currentDigitsMin);
        return vStr;
    }

    @Override
    public IModel getModel() {
        return this.model;
    }

    @Override
    public void modelHasChanged() {
        this.view.repaint();
    }

    @Override
    public double getDefEI() {
        return this.EI;
    }

    public double getDefGAs() {
        return this.GAs;
    }

    @Override
    public double getDefEA() {
        return this.EA;
    }

    public double getDefM() {
        return this.m;
    }

    public static InputStream getResourceAsStream(String resourceName) {
        try {
            FileInputStream resourceStream = new FileInputStream("resourcen/" + resourceName);
            return resourceStream;
        }
        catch (FileNotFoundException fe) {
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try {
            URL url = new URL(JBeamApplet.baseUrl + "resourcen/" + resourceName);
            return url.openStream();
        }
        catch (MalformedURLException me) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new Error("JBeam::getResourceAsStream(" + resourceName + "): cannot access");
    }

    class JBeamViewMouseWheelListener
    implements MouseWheelListener {
        private static final double mouseZoomFactor = 1.1;
        private static final double mouseZoomFactorI = 0.9090909090909091;

        JBeamViewMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int r;
            for (r = e.getWheelRotation(); r > 0; --r) {
                JBeam.this.view.zoom(1.1);
            }
            while (r < 0) {
                JBeam.this.view.zoom(0.9090909090909091);
                ++r;
            }
            JBeam.this.view.repaint();
        }
    }

    class JBeamViewMouseMotionListener
    extends MouseMotionAdapter {
        private boolean dragging;
        private int dragX;
        private int dragY;

        JBeamViewMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            this.dragging = false;
            if (JBeam.this.lock) {
                return;
            }
            double x = JBeam.this.view.worldX(event.getX());
            double z = JBeam.this.view.worldZ(event.getY());
            JBeam.this.posX.setText("X: " + JBeam.this.numberFormat.format(JBeam.this.snap(x)));
            JBeam.this.posY.setText("Z: " + JBeam.this.numberFormat.format(JBeam.this.snap(z)));
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            if (this.dragging) {
                int dX = x - this.dragX;
                int dY = y - this.dragY;
                if ((event.getModifiersEx() & 0x1800) != 0) {
                    JBeam.this.view.pan(dX, dY);
                    JBeam.this.view.repaint();
                }
            }
            this.dragging = true;
            this.dragX = x;
            this.dragY = y;
        }
    }

    class JBeamViewMouseListener
    extends MouseAdapter {
        JBeamViewMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            double z;
            double x;
            if (JBeam.this.lock) {
                return;
            }
            if ((event.getModifiers() & 0x10) != 0 && !JBeam.this.posX.getText().equals("X: -")) {
                int n;
                x = JBeam.this.snap(JBeam.this.view.worldX(event.getX()));
                z = JBeam.this.snap(JBeam.this.view.worldZ(event.getY()));
                if (JBeam.this.mode.getText().equals("add free node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add r constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, false, false, true));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add rx constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, true, false, true));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add rz constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, false, true, true));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add rxz constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, true, true, true));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add x constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, true, false, false));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add z constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, false, true, false));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("add xz constrained node")) {
                    if (JBeam.this.isFree(x, z)) {
                        JBeam.this.model.addNode(new Node(x, z, true, true, false));
                        JBeam.this.view.repaint();
                        JBeam.this.status.setText("OK");
                    } else {
                        JBeam.this.status.setText("Error: location already occupied");
                    }
                }
                if (JBeam.this.mode.getText().equals("select")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    n = JBeam.this.model.addSelection(x, z, JBeam.this.view.worldScale(JBeam.this.checkR), JBeam.this.view);
                    JBeam.this.status.setText("Selection: " + n + " added");
                    if (n != 0) {
                        JBeam.this.view.repaint();
                    }
                }
                if (JBeam.this.mode.getText().equals("info")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.model.clearSelection();
                    n = JBeam.this.model.addSelection(x, z, JBeam.this.view.worldScale(JBeam.this.checkR), JBeam.this.view);
                    if (n == 0) {
                        JBeam.this.status.setText("Info: nothing found");
                    } else if (n > 1) {
                        JBeam.this.status.setText("Info: more than one object found");
                    } else {
                        Object obj = JBeam.this.model.getSelectionIterator().iterator().next();
                        DlgInfo dlgInfo = new DlgInfo(JBeam.this, JBeam.this.mainFrame, JBeam.this.model, obj);
                    }
                    JBeam.this.model.clearSelection();
                }
                if (JBeam.this.mode.getText().equals("select window: second point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.model.addSelectionWindow(x, z);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("select");
                }
                if (JBeam.this.mode.getText().equals("select window: first point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.model.setRef(x, z, false, true);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("select window: second point");
                }
                if (JBeam.this.mode.getText().equals("move: second point")) {
                    n = JBeam.this.model.move(x, z);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("select");
                    JBeam.this.status.setText("Move: " + n + " Elements found");
                }
                if (JBeam.this.mode.getText().equals("move: first point")) {
                    JBeam.this.model.setRef(x, z, true, false);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("move: second point");
                }
                if (JBeam.this.mode.getText().equals("pan: second point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.view.pan(x - JBeam.this.model.getRefX(), z - JBeam.this.model.getRefZ());
                    JBeam.this.model.noRef();
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("select");
                }
                if (JBeam.this.mode.getText().equals("pan: first point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.model.setRef(x, z, false, false);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("pan: second point");
                }
                if (JBeam.this.mode.getText().equals("zoom window: second point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.view.zoomWindow(x, z, JBeam.this.model.getRefX(), JBeam.this.model.getRefZ());
                    JBeam.this.model.noRef();
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("select");
                }
                if (JBeam.this.mode.getText().equals("zoom window: first point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    z = JBeam.this.view.worldZ(event.getY());
                    JBeam.this.model.setRef(x, z, false, true);
                    JBeam.this.view.repaint();
                    JBeam.this.mode.setText("zoom window: second point");
                }
                if (JBeam.this.mode.getText().equals("element: second point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    if (JBeam.this.model.selectNode(x, z = JBeam.this.view.worldZ(event.getY()), 1, JBeam.this.view.worldScale(JBeam.this.checkR))) {
                        Node n2;
                        Node n1 = JBeam.this.model.getNode(0);
                        if (n1 != (n2 = JBeam.this.model.getNode(1))) {
                            JBeam.this.mode.setText("element: first point");
                            JBeam.this.status.setText("OK");
                            Beam beam = null;
                            if (JBeam.this.addElementType.equals("truss")) {
                                beam = new Truss(n1, n2, JBeam.this.EA, JBeam.this.m);
                            }
                            if (JBeam.this.addElementType.equals("EB beam")) {
                                beam = new EBBeam(n1, n2, JBeam.this.EI, JBeam.this.EA, JBeam.this.m);
                            }
                            if (JBeam.this.addElementType.equals("EBS beam")) {
                                beam = new EBSBeam(n1, n2, JBeam.this.EI, JBeam.this.EA, JBeam.this.GAs, JBeam.this.m);
                            }
                            if (beam != null) {
                                JBeam.this.model.addBeam(beam);
                            }
                        } else {
                            JBeam.this.mode.setText("element: first point");
                            JBeam.this.status.setText("Error: Node 1 and 2 are equal");
                        }
                    } else {
                        JBeam.this.status.setText("Error: No Node found");
                    }
                    JBeam.this.view.repaint();
                } else if (JBeam.this.mode.getText().equals("element: first point")) {
                    x = JBeam.this.view.worldX(event.getX());
                    if (JBeam.this.model.selectNode(x, z = JBeam.this.view.worldZ(event.getY()), 0, JBeam.this.view.worldScale(JBeam.this.checkR))) {
                        JBeam.this.mode.setText("element: second point");
                        JBeam.this.status.setText("Node selected");
                    } else {
                        JBeam.this.status.setText("Error: No Node found");
                    }
                    JBeam.this.view.repaint();
                }
            }
            if ((event.getModifiers() & (8 | 4)) != 0) {
                x = JBeam.this.view.worldX(event.getX());
                z = JBeam.this.view.worldZ(event.getY());
                JBeam.this.model.clearSelection();
                JBeam.this.model.noRef();
                JBeam.this.mode.setText("select");
                JBeam.this.updateCursorShape();
                int n = JBeam.this.model.addSelection(x, z, JBeam.this.view.worldScale(JBeam.this.checkR), JBeam.this.view);
                JBeam.this.status.setText("Selection: " + n + " added");
                if (n == 1) {
                    Object element = JBeam.this.model.getSelectedObject();
                    if (element instanceof Node) {
                        DlgNode dlgnode = new DlgNode((Frame)JBeam.this.mainFrame, (Node)element);
                    }
                    if (element instanceof Truss) {
                        DlgTruss dlgtruss = new DlgTruss((Frame)JBeam.this.mainFrame, (Truss)element);
                    }
                    if (element instanceof EBBeam && !(element instanceof EBSBeam)) {
                        DlgEBBeam dlgebbeam = new DlgEBBeam((Frame)JBeam.this.mainFrame, (EBBeam)element);
                    }
                    if (element instanceof EBSBeam) {
                        DlgEBSBeam dlgebsbeam = new DlgEBSBeam((Frame)JBeam.this.mainFrame, (EBSBeam)element);
                    }
                }
                JBeam.this.view.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent event) {
            JBeam.this.posX.setText("X: -");
            JBeam.this.posY.setText("Z: -");
        }
    }

    class JBeamActionListener
    implements ActionListener {
        Timer timer = new Timer(50, this);
        boolean frozen;
        double time;
        double timeStep;
        double baseScale;

        JBeamActionListener() {
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
            this.time = 0.0;
            this.timeStep = 0.15707963267948966;
            this.frozen = true;
        }

        protected void stopAnimation() {
            if (!this.frozen) {
                this.frozen = true;
                ((JBeam)JBeam.this).menuBar.animateMode.setSelected(false);
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
                JBeam.this.view.setDisplacementScale(this.baseScale);
                JBeam.this.view.repaint();
            }
        }

        protected void startAnimation() {
            if (this.frozen) {
                this.frozen = false;
                this.baseScale = JBeam.this.view.getDisplacementScale();
                ((JBeam)JBeam.this).menuBar.animateMode.setSelected(true);
                if (!this.timer.isRunning()) {
                    this.timer.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            String cmd;
            if (JBeam.this.lock) {
                return;
            }
            if (event.getSource() == this.timer) {
                if (!JBeam.this.model.getValidCalculation()) {
                    this.stopAnimation();
                    return;
                }
                this.time += this.timeStep;
                if (this.time >= Math.PI * 2) {
                    this.time -= Math.PI * 2;
                }
                JBeam.this.view.setDisplacementScale(this.baseScale * Math.sin(this.time));
                JBeam.this.view.repaint();
            }
            if ((cmd = event.getActionCommand()) != null) {
                Closeable ostream;
                JDialog dlg;
                JBeam.this.status.setText("ready");
                if (cmd.equals("new")) {
                    this.stopAnimation();
                    JBeam.this.resetApp();
                }
                if (cmd.equals("exit")) {
                    this.stopAnimation();
                    JBeam.this.exitApp();
                }
                if (cmd.equals("select window")) {
                    JBeam.this.mode.setText("select window: first point");
                }
                if (cmd.equals("zoom in")) {
                    JBeam.this.view.zoom(1.3333333333333333);
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("zoom out")) {
                    JBeam.this.view.zoom(0.75);
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("pan")) {
                    JBeam.this.mode.setText("pan: first point");
                }
                if (cmd.equals("zoom window")) {
                    JBeam.this.mode.setText("zoom window: first point");
                }
                if (cmd.equals("show all")) {
                    JBeam.this.view.showAll();
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("sectional vals")) {
                    dlg = new DlgSectionalVals((Frame)JBeam.this.mainFrame, JBeam.this);
                }
                if (cmd.equals("snap and grid")) {
                    dlg = new DlgGrid((Frame)JBeam.this.mainFrame, JBeam.this);
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("view")) {
                    this.stopAnimation();
                    dlg = new DlgView((Frame)JBeam.this.mainFrame, JBeam.this);
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("free node")) {
                    JBeam.this.mode.setText("add free node");
                }
                if (cmd.equals("r constrained node")) {
                    JBeam.this.mode.setText("add r constrained node");
                }
                if (cmd.equals("rx constrained node")) {
                    JBeam.this.mode.setText("add rx constrained node");
                }
                if (cmd.equals("rz constrained node")) {
                    JBeam.this.mode.setText("add rz constrained node");
                }
                if (cmd.equals("rxz constrained node")) {
                    JBeam.this.mode.setText("add rxz constrained node");
                }
                if (cmd.equals("x constrained node")) {
                    JBeam.this.mode.setText("add x constrained node");
                }
                if (cmd.equals("z constrained node")) {
                    JBeam.this.mode.setText("add z constrained node");
                }
                if (cmd.equals("xz constrained node")) {
                    JBeam.this.mode.setText("add xz constrained node");
                }
                if (cmd.equals("select")) {
                    JBeam.this.mode.setText("select");
                    JBeam.this.model.noRef();
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("info")) {
                    JBeam.this.mode.setText("info");
                    JBeam.this.model.noRef();
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("properties")) {
                    Truss refTruss = null;
                    EBBeam refEBBeam = null;
                    EBBeam refEBSBeam = null;
                    Node refNode = null;
                    boolean changeTruss = true;
                    boolean changeEBBeam = true;
                    boolean changeEBSBeam = true;
                    boolean changeNode = true;
                    while (JBeam.this.model.hasSelectedObjects()) {
                        Object element = JBeam.this.model.getSelectedObject();
                        if (element instanceof Node && changeNode) {
                            if (refNode == null) {
                                DlgNode dlgnode = new DlgNode((Frame)JBeam.this.mainFrame, (Node)element);
                                if (!dlgnode.getOK()) {
                                    changeNode = false;
                                }
                                refNode = (Node)element;
                            } else {
                                Node node = (Node)element;
                                node.setCX(refNode.getCX());
                                node.setCZ(refNode.getCZ());
                                node.setCR(refNode.getCR());
                                node.setFx(refNode.getFx());
                                node.setFz(refNode.getFz());
                                node.setM(refNode.getM());
                            }
                        }
                        if (element instanceof Truss && changeTruss) {
                            if (refTruss == null) {
                                DlgTruss dlgtruss = new DlgTruss((Frame)JBeam.this.mainFrame, (Truss)element);
                                if (!dlgtruss.getOK()) {
                                    changeTruss = false;
                                }
                                refTruss = (Truss)element;
                            } else {
                                Truss truss = (Truss)element;
                                truss.setEA(refTruss.getEA());
                                truss.setM(refTruss.getM());
                            }
                        }
                        if (element instanceof EBBeam && !(element instanceof EBSBeam) && changeEBBeam) {
                            if (refEBBeam == null) {
                                DlgEBBeam dlgebbeam = new DlgEBBeam((Frame)JBeam.this.mainFrame, (EBBeam)element);
                                if (!dlgebbeam.getOK()) {
                                    changeEBBeam = false;
                                }
                                refEBBeam = (EBBeam)element;
                            } else {
                                EBBeam ebbeam = (EBBeam)element;
                                ebbeam.setEA(refEBBeam.getEA());
                                ebbeam.setEI(refEBBeam.getEI());
                                ebbeam.setM(refEBBeam.getM());
                                ebbeam.setVi(refEBBeam.getVi());
                                ebbeam.setVk(refEBBeam.getVk());
                                ebbeam.setNi(refEBBeam.getNi());
                                ebbeam.setNk(refEBBeam.getNk());
                            }
                        }
                        if (!(element instanceof EBSBeam) || !changeEBSBeam) continue;
                        if (refEBSBeam == null) {
                            DlgEBSBeam dlgebsbeam = new DlgEBSBeam((Frame)JBeam.this.mainFrame, (EBSBeam)element);
                            if (!dlgebsbeam.getOK()) {
                                changeEBSBeam = false;
                            }
                            refEBSBeam = (EBSBeam)element;
                            continue;
                        }
                        EBSBeam ebsbeam = (EBSBeam)element;
                        ebsbeam.setEA(refEBSBeam.getEA());
                        ebsbeam.setEI(refEBSBeam.getEI());
                        ebsbeam.setM(refEBSBeam.getM());
                        ebsbeam.setGAs(((EBSBeam)refEBSBeam).getGAs());
                        ebsbeam.setVi(refEBSBeam.getVi());
                        ebsbeam.setVk(refEBSBeam.getVk());
                        ebsbeam.setNi(refEBSBeam.getNi());
                        ebsbeam.setNk(refEBSBeam.getNk());
                    }
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("delete")) {
                    int n = JBeam.this.model.delete();
                    JBeam.this.status.setText("Delete: " + n + " elements found");
                    if (n > 0) {
                        JBeam.this.view.repaint();
                    }
                }
                if (cmd.equals("move")) {
                    JBeam.this.mode.setText("move: first point");
                }
                if (cmd.equals("truss") || cmd.equals("EB beam") || cmd.equals("EBS beam")) {
                    JBeam.this.mode.setText("element: first point");
                    JBeam.this.addElementType = cmd;
                }
                if (cmd.equals("save")) {
                    JFileChooser chooser = new JFileChooser();
                    if (JBeam.this.fileChooseDir != null) {
                        chooser.setCurrentDirectory(JBeam.this.fileChooseDir);
                    }
                    ExampleFileFilter jbmFilter = new ExampleFileFilter("jbm", "JBeam Data Files");
                    chooser.setFileFilter(jbmFilter);
                    chooser.setDialogType(1);
                    chooser.setFileSelectionMode(0);
                    int ret = chooser.showDialog(JBeam.this.mainFrame, null);
                    if (ret == 0) {
                        JBeam.this.status.setText("writing...");
                        ostream = null;
                        try {
                            ostream = new FileOutputStream(chooser.getSelectedFile().getAbsolutePath());
                            ObjectOutputStream p = new ObjectOutputStream((OutputStream)ostream);
                            p.writeObject(JBeam.this.model);
                            JBeam.this.status.setText("write OK");
                            JBeam.this.fileChooseDir = chooser.getCurrentDirectory();
                        }
                        catch (IOException e) {
                            JBeam.this.status.setText("write error: " + e.getMessage());
                            JOptionPane.showMessageDialog(null, "File write error!\nCheck the filename and permissions.", "Write Error", 0);
                        }
                        finally {
                            try {
                                if (ostream != null) {
                                    ((FileOutputStream)ostream).close();
                                }
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (cmd.equals("open")) {
                    JFileChooser chooser = new JFileChooser();
                    if (JBeam.this.fileChooseDir != null) {
                        chooser.setCurrentDirectory(JBeam.this.fileChooseDir);
                    }
                    chooser.setFileFilter(new ExampleFileFilter("jbm", "JBeam Data Files"));
                    chooser.setDialogType(0);
                    chooser.setFileSelectionMode(0);
                    int ret = chooser.showDialog(JBeam.this.mainFrame, null);
                    if (ret == 0) {
                        JBeam.this.status.setText("reading...");
                        FileInputStream istream = null;
                        try {
                            istream = new FileInputStream(chooser.getSelectedFile().getAbsolutePath());
                            ObjectInputStream p = new ObjectInputStream(istream);
                            JBeam.this.model = (SelectableModel)p.readObject();
                            JBeam.this.view.reset();
                            JBeam.this.view.setModel(JBeam.this.model);
                            JBeam.this.initApp();
                            JBeam.this.status.setText("read OK");
                            JBeam.this.fileChooseDir = chooser.getCurrentDirectory();
                        }
                        catch (Exception e) {
                            JBeam.this.status.setText("read error: " + e.getMessage());
                            JOptionPane.showMessageDialog(null, "File read error!\nCheck if the file is present and readable.", "Read Error", 0);
                        }
                        finally {
                            try {
                                if (istream != null) {
                                    istream.close();
                                }
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (cmd.equals("calculate")) {
                    JBeam.this.status.setText("calculating...");
                    try {
                        JBeam.this.model.calculate();
                    }
                    catch (RuntimeException e) {
                        JOptionPane.showMessageDialog(null, "Runtime Exception:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    catch (Error e) {
                        JOptionPane.showMessageDialog(null, "Error:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    JBeam.this.status.setText("calculation complete");
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("calculate modal")) {
                    JBeam.this.status.setText("calculating modal...");
                    try {
                        JBeam.this.model.calculateModal();
                    }
                    catch (RuntimeException e) {
                        JOptionPane.showMessageDialog(null, "Runtime Exception:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Exception:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    catch (Error e) {
                        JOptionPane.showMessageDialog(null, "Error:\n" + e.getMessage(), "Calculation Error", 0);
                    }
                    JBeam.this.status.setText("Mode = " + JBeam.this.model.getMode() + ", f = " + JBeam.this.model.getFreq());
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("show next mode")) {
                    JBeam.this.model.nextMode();
                    JBeam.this.status.setText("Mode = " + JBeam.this.model.getMode() + ", f = " + JBeam.this.model.getFreq());
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("show prev mode")) {
                    JBeam.this.model.prevMode();
                    JBeam.this.status.setText("Mode = " + JBeam.this.model.getMode() + ", f = " + JBeam.this.model.getFreq());
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("animate mode")) {
                    if (((AbstractButton)event.getSource()).isSelected()) {
                        this.startAnimation();
                        JBeam.this.status.setText("Animation: Mode = " + JBeam.this.model.getMode());
                        JBeam.this.view.repaint();
                    } else {
                        this.stopAnimation();
                        JBeam.this.view.setDisplacementScale(this.baseScale);
                        JBeam.this.view.repaint();
                    }
                }
                if (cmd.equals("show displacement")) {
                    if (((AbstractButton)event.getSource()).isSelected()) {
                        JBeam.this.view.setShowDisplacement(true);
                    } else {
                        JBeam.this.view.setShowDisplacement(false);
                    }
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("show moment")) {
                    if (((AbstractButton)event.getSource()).isSelected()) {
                        JBeam.this.view.setShowMoment(true);
                    } else {
                        JBeam.this.view.setShowMoment(false);
                    }
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("show normal force")) {
                    if (((AbstractButton)event.getSource()).isSelected()) {
                        JBeam.this.view.setShowNormalForce(true);
                    } else {
                        JBeam.this.view.setShowNormalForce(false);
                    }
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("show shear force")) {
                    if (((AbstractButton)event.getSource()).isSelected()) {
                        JBeam.this.view.setShowShearForce(true);
                    } else {
                        JBeam.this.view.setShowShearForce(false);
                    }
                    JBeam.this.view.repaint();
                }
                if (cmd.equals("write result")) {
                    JFileChooser chooser = new JFileChooser();
                    if (JBeam.this.fileChooseDir != null) {
                        chooser.setCurrentDirectory(JBeam.this.fileChooseDir);
                    }
                    ExampleFileFilter jbmFilter = new ExampleFileFilter("txt", "ASCII text file");
                    chooser.setFileFilter(jbmFilter);
                    chooser.setDialogType(1);
                    chooser.setFileSelectionMode(0);
                    int ret = chooser.showDialog(JBeam.this.mainFrame, null);
                    if (ret == 0) {
                        JBeam.this.status.setText("writing...");
                        ostream = null;
                        try {
                            ostream = new FileWriter(chooser.getSelectedFile().getAbsolutePath());
                            PrintWriter p = new PrintWriter((Writer)ostream);
                            TextView textView = new TextView(JBeam.this.model, JBeam.this);
                            textView.write(p);
                            JBeam.this.status.setText("write OK");
                            p.close();
                            JBeam.this.fileChooseDir = chooser.getCurrentDirectory();
                        }
                        catch (IOException e) {
                            JBeam.this.status.setText("write error: " + e.getMessage());
                            JOptionPane.showMessageDialog(null, "File write error!\nCheck the filename and permissions.", "Write Error", 0);
                        }
                        finally {
                            try {
                                if (ostream != null) {
                                    ((OutputStreamWriter)ostream).close();
                                }
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (cmd.equals("write result html")) {
                    JFileChooser chooser = new JFileChooser();
                    if (JBeam.this.fileChooseDir != null) {
                        chooser.setCurrentDirectory(JBeam.this.fileChooseDir);
                    }
                    ExampleFileFilter jbmFilter = new ExampleFileFilter("html", "HTML document");
                    chooser.setFileFilter(jbmFilter);
                    chooser.setDialogType(1);
                    chooser.setFileSelectionMode(0);
                    int ret = chooser.showDialog(JBeam.this.mainFrame, null);
                    if (ret == 0) {
                        JBeam.this.status.setText("writing...");
                        ostream = null;
                        try {
                            File outFile = chooser.getSelectedFile().getAbsoluteFile();
                            ostream = new FileWriter(outFile);
                            PrintWriter p = new PrintWriter((Writer)ostream);
                            HtmlView textView = new HtmlView(JBeam.this.model, JBeam.this);
                            textView.write(p);
                            JBeam.this.status.setText("write OK");
                            p.close();
                            JBeam.this.fileChooseDir = chooser.getCurrentDirectory();
                            try {
                                Desktop.getDesktop().browse(outFile.toURI());
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        catch (IOException e) {
                            JBeam.this.status.setText("write error: " + e.getMessage());
                            JOptionPane.showMessageDialog(null, "File write error!\nCheck the filename and permissions.", "Write Error", 0);
                        }
                        finally {
                            try {
                                if (ostream != null) {
                                    ((OutputStreamWriter)ostream).close();
                                }
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                if (cmd.equals("about")) {
                    JOptionPane.showMessageDialog(null, "JBeam 4.0.0\n2012-01-01\nby Schwebke Software Development\n\nThis is copyrighted software -\n  see 'COPYING' for details.", "about JBeam", 1);
                }
                JBeam.this.updateCursorShape();
            }
        }
    }

    class JBeamWindowListener
    extends WindowAdapter {
        JBeamWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            if (!JBeam.this.lock) {
                JBeam.this.exitApp();
            }
        }
    }
}

