/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.applet.JBeamApplet;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

class MainButtonBar
extends JToolBar {
    ActionListener listener;

    public MainButtonBar(ActionListener listener) {
        this.listener = listener;
        try {
            PropertyResourceBundle locale = new PropertyResourceBundle(JBeam.getResourceAsStream("locale.txt"));
            this.addButton("New.gif", locale.getString("ButtonNew"), "new");
            this.addButton("Open.gif", locale.getString("ButtonOpen"), "open");
            this.addButton("Save.gif", locale.getString("ButtonSave"), "save");
            this.addSeparator();
            this.addButton("Select.gif", locale.getString("ButtonSelect"), "select");
            this.addButton("SelectWindow.gif", locale.getString("ButtonSelectWindow"), "select window");
            this.addButton("Properties.gif", locale.getString("ButtonProperties"), "properties");
            this.addButton("Move.gif", locale.getString("ButtonMove"), "move");
            this.addButton("Delete.gif", locale.getString("ButtonDelete"), "delete");
            this.addSeparator();
            this.addButton("Info.gif", locale.getString("ButtonInfo"), "info");
            this.addSeparator();
            this.addButton("ZoomIn.gif", locale.getString("ButtonZoomIn"), "zoom in");
            this.addButton("ZoomOut.gif", locale.getString("ButtonZoomOut"), "zoom out");
            this.addButton("Pan.gif", locale.getString("ButtonPan"), "pan");
            this.addButton("ZoomWindow.gif", locale.getString("ButtonZoomWindow"), "zoom window");
            this.addButton("ShowAll.gif", locale.getString("ButtonShowAll"), "show all");
            this.addSeparator();
            this.addButton("FreeNode.gif", locale.getString("ButtonFNode"), "free node");
            this.addButton("RNode.gif", locale.getString("ButtonRNode"), "r constrained node");
            this.addSeparator();
            this.addButton("Truss.gif", locale.getString("ButtonTruss"), "truss");
            this.addButton("EBBeam.gif", locale.getString("ButtonEBBeam"), "EB beam");
            this.addButton("EBSBeam.gif", locale.getString("ButtonEBSBeam"), "EBS beam");
        }
        catch (Exception e) {
            System.out.println("ButtonBar build error: " + e.getMessage());
        }
    }

    void initButtonBar() {
    }

    void addButton(String iconName, String command) {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon("resourcen/" + iconName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (icon == null) {
                icon = new ImageIcon(new URL(JBeamApplet.baseUrl + "resourcen/" + iconName));
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        JButton button = new JButton(icon);
        button.setToolTipText(command);
        button.setActionCommand(command);
        button.addActionListener(this.listener);
        this.add(button);
    }

    void addButton(String iconName, String tooltip, String command) {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon("resourcen/" + iconName);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (icon == null) {
                icon = new ImageIcon(new URL(JBeamApplet.baseUrl + "resourcen/" + iconName));
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        JButton button = new JButton(icon);
        button.setToolTipText(tooltip);
        button.setActionCommand(command);
        button.addActionListener(this.listener);
        this.add(button);
    }
}

