/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam;

import com.schwebke.jbeam.applet.JBeamApplet;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.net.URL;
import java.util.PropertyResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class MainMenuBar
extends JMenuBar {
    ActionListener listener;
    JCheckBoxMenuItem showDisplacement;
    JCheckBoxMenuItem showMoment;
    JCheckBoxMenuItem showNormalForce;
    JCheckBoxMenuItem showShearForce;
    JCheckBoxMenuItem animateMode;

    public MainMenuBar(ActionListener listener) {
        try {
            FileInputStream localeRes = null;
            PropertyResourceBundle locale = null;
            try {
                localeRes = new FileInputStream("resourcen/locale.txt");
                locale = new PropertyResourceBundle(localeRes);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (locale == null) {
                URL url = new URL(JBeamApplet.baseUrl + "resourcen/locale.txt");
                locale = new PropertyResourceBundle(url.openStream());
            }
            this.listener = listener;
            JMenu m = new JMenu(locale.getString("MenuFile"));
            this.addMenuItem(m, locale.getString("MItemNew"), "new");
            this.addMenuItem(m, locale.getString("MItemOpen"), "open");
            this.addMenuItem(m, locale.getString("MItemSave"), "save");
            m.addSeparator();
            this.addMenuItem(m, locale.getString("MItemExit"), "exit");
            this.add(m);
            m = new JMenu(locale.getString("MenuEdit"));
            this.addMenuItem(m, locale.getString("MItemSelect"), "select");
            this.addMenuItem(m, locale.getString("MItemInfo"), "info");
            this.addMenuItem(m, locale.getString("MItemSelectWindow"), "select window");
            this.addMenuItem(m, locale.getString("MItemProperties"), "properties");
            this.addMenuItem(m, locale.getString("MItemMove"), "move");
            this.addMenuItem(m, locale.getString("MItemDelete"), "delete");
            this.add(m);
            m = new JMenu(locale.getString("MenuPreferences"));
            this.addMenuItem(m, locale.getString("MItemSecVals"), "sectional vals");
            this.addMenuItem(m, locale.getString("MItemSnapGrid"), "snap and grid");
            this.addMenuItem(m, locale.getString("MItemView"), "view");
            m.addSeparator();
            this.addMenuItem(m, locale.getString("MItemZoomIn"), "zoom in");
            this.addMenuItem(m, locale.getString("MItemZoomOut"), "zoom out");
            this.addMenuItem(m, locale.getString("MItemPan"), "pan");
            this.addMenuItem(m, locale.getString("MItemZoomWindow"), "zoom window");
            this.addMenuItem(m, locale.getString("MItemShowAll"), "show all");
            this.add(m);
            m = new JMenu(locale.getString("MenuNode"));
            this.addMenuItem(m, locale.getString("MItemNodeF"), "free node");
            this.addMenuItem(m, locale.getString("MItemNodeX"), "x constrained node");
            this.addMenuItem(m, locale.getString("MItemNodeZ"), "z constrained node");
            this.addMenuItem(m, locale.getString("MItemNodeXZ"), "xz constrained node");
            m.addSeparator();
            this.addMenuItem(m, locale.getString("MItemNodeR"), "r constrained node");
            this.addMenuItem(m, locale.getString("MItemNodeRX"), "rx constrained node");
            this.addMenuItem(m, locale.getString("MItemNodeRZ"), "rz constrained node");
            this.addMenuItem(m, locale.getString("MItemNodeRXZ"), "rxz constrained node");
            this.add(m);
            m = new JMenu(locale.getString("MenuElement"));
            this.addMenuItem(m, locale.getString("MItemTruss"), "truss");
            this.addMenuItem(m, locale.getString("MItemEBBeam"), "EB beam");
            this.addMenuItem(m, locale.getString("MItemEBSBeam"), "EBS beam");
            this.add(m);
            m = new JMenu(locale.getString("MenuResults"));
            this.addMenuItem(m, locale.getString("MItemCalculate"), "calculate");
            this.addMenuItem(m, locale.getString("MItemCalculateModal"), "calculate modal");
            m.addSeparator();
            this.showDisplacement = new JCheckBoxMenuItem(locale.getString("MItemShowDis"));
            this.addCheckBoxMenuItem(m, "show displacement", this.showDisplacement);
            this.showMoment = new JCheckBoxMenuItem(locale.getString("MItemShowM"));
            this.addCheckBoxMenuItem(m, "show moment", this.showMoment);
            this.showNormalForce = new JCheckBoxMenuItem(locale.getString("MItemShowN"));
            this.addCheckBoxMenuItem(m, "show normal force", this.showNormalForce);
            this.showShearForce = new JCheckBoxMenuItem(locale.getString("MItemShowV"));
            this.addCheckBoxMenuItem(m, "show shear force", this.showShearForce);
            m.addSeparator();
            this.addMenuItem(m, locale.getString("MItemNextMode"), "show next mode");
            this.addMenuItem(m, locale.getString("MItemPrevMode"), "show prev mode");
            this.animateMode = new JCheckBoxMenuItem(locale.getString("MItemAnimateMode"));
            this.addCheckBoxMenuItem(m, "animate mode", this.animateMode);
            m.addSeparator();
            this.addMenuItem(m, locale.getString("MItemWriteASC"), "write result");
            this.addMenuItem(m, locale.getString("MItemWriteHTML"), "write result html");
            this.add(m);
            m = new JMenu("?");
            this.addMenuItem(m, locale.getString("MItemAbout"), "about");
            this.add(m);
        }
        catch (Exception e) {
            System.out.println("Menu build error: " + e.getMessage());
        }
    }

    void initMenuBar() {
        this.showDisplacement.setSelected(false);
        this.showMoment.setSelected(false);
    }

    private void addMenuItem(JMenu menu, String name) {
        JMenuItem i = new JMenuItem(name);
        i.setActionCommand(name);
        i.addActionListener(this.listener);
        menu.add(i);
    }

    private void addMenuItem(JMenu menu, String name, String cmd) {
        JMenuItem i = new JMenuItem(name);
        i.setActionCommand(cmd);
        i.addActionListener(this.listener);
        menu.add(i);
    }

    private void addCheckBoxMenuItem(JMenu menu, String cmd, JCheckBoxMenuItem i) {
        i.setActionCommand(cmd);
        i.addActionListener(this.listener);
        menu.add(i);
    }
}

