/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.math;

import com.schwebke.jbeam.math.Distance;
import com.schwebke.math.MVector;

public class Line
implements Distance {
    MVector a;
    MVector b;

    public Line(MVector p1, MVector p2) {
        this.a = p1;
        this.b = MVector.sub(p2, p1);
    }

    public Line(double p1x, double p1z, double p2x, double p2z) {
        this.a = new MVector(p1x, 0.0, p1z);
        this.b = new MVector(p2x - p1x, 0.0, p2z - p1z);
    }

    @Override
    public double getDistance(double x, double z) {
        MVector c = new MVector(x - this.a.x, 0.0, z - this.a.z);
        MVector p = new MVector(x, 0.0, z);
        double t = MVector.dot(MVector.sub(p, this.a), this.b) / MVector.dot(this.b, this.b);
        if (t < 0.0) {
            return MVector.abs(MVector.sub(this.a, p));
        }
        if (t > 1.0) {
            return MVector.abs(MVector.sub(MVector.add(this.a, this.b), p));
        }
        return MVector.abs(MVector.cross(this.b, c)) / MVector.abs(this.b);
    }
}

