/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.math.Distance;
import com.schwebke.jbeam.model.Node;
import com.schwebke.math.MVector;
import com.schwebke.math.Matrix;
import java.io.Serializable;

public abstract class Beam
implements Distance,
Serializable {
    protected Node n1;
    protected Node n2;
    protected String label;
    protected double[][] Sl;
    protected double[][] Sg;
    protected double[][] a;
    protected double[] Lg;
    protected double[][] Ml;
    protected double[][] Mg;
    protected double m;
    protected double Ni;
    protected double Nk;
    protected double Vi;
    protected double Vk;
    protected double Mi;
    protected double Mk;
    protected MVector n;
    protected MVector r;
    protected double l;

    public Beam(Node n1, Node n2, double m) {
        this.n1 = n1;
        this.n2 = n2;
        this.m = m;
        this.label = new String("");
        this.Nk = 0.0;
        this.Ni = 0.0;
        this.Vk = 0.0;
        this.Vi = 0.0;
        this.Mk = 0.0;
        this.Mi = 0.0;
        this.a = null;
        this.Sg = this.a;
        this.Sl = this.a;
        this.r = null;
        this.n = null;
        this.l = 0.0;
        this.calculateVector();
        this.Lg = new double[6];
        for (int n = 0; n < 6; ++n) {
            this.Lg[n] = 0.0;
        }
    }

    public void calculateVector() {
        this.r = new MVector(this.n2.getX() - this.n1.getX(), 0.0, this.n2.getZ() - this.n1.getZ());
        this.l = MVector.abs(this.r);
        this.n = MVector.multiply(MVector.cross(this.r, new MVector(0.0, 1.0, 0.0)), 1.0 / this.l);
    }

    public MVector getN() {
        return this.n;
    }

    public MVector getR() {
        return this.r;
    }

    public double getL() {
        return this.l;
    }

    public double[][] getSg() {
        return this.Sg;
    }

    public double[][] getMg() {
        return this.Mg;
    }

    public Node getN1() {
        return this.n1;
    }

    public void setN1(Node n1) {
        this.n1 = n1;
    }

    public Node getN2() {
        return this.n2;
    }

    public void setN2(Node n2) {
        this.n2 = n2;
    }

    public void setM(double m) {
        this.m = m;
    }

    public double getM() {
        return this.m;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract void calSg();

    protected void calMl() {
        this.Ml = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.Ml[i][j] = 0.0;
            }
        }
        this.Ml[0][0] = 0.5 * this.m * this.l;
        this.Ml[1][1] = 0.5 * this.m * this.l;
        this.Ml[3][3] = 0.5 * this.m * this.l;
        this.Ml[4][4] = 0.5 * this.m * this.l;
    }

    public abstract void postCalculate();

    public abstract double w(double var1);

    @Override
    public double getDistance(double x, double z) {
        MVector a = new MVector(this.n1.x, 0.0, this.n1.z);
        MVector b = new MVector(this.n2.x - this.n1.x, 0.0, this.n2.z - this.n1.z);
        MVector c = new MVector(x - this.n1.x, 0.0, z - this.n1.z);
        MVector p = new MVector(x, 0.0, z);
        double t = MVector.dot(MVector.sub(p, a), b) / MVector.dot(b, b);
        if (t < 0.0) {
            return MVector.abs(MVector.sub(a, p));
        }
        if (t > 1.0) {
            return MVector.abs(MVector.sub(new MVector(this.n2.x, 0.0, this.n2.z), p));
        }
        return MVector.abs(MVector.cross(b, c)) / MVector.abs(b);
    }

    protected final void transform() {
        this.a = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.a[i][j] = 0.0;
            }
        }
        double alpha = Math.atan2(this.n2.z - this.n1.z, this.n2.x - this.n1.x);
        double d = Math.cos(alpha);
        this.a[4][4] = d;
        this.a[3][3] = d;
        this.a[1][1] = d;
        this.a[0][0] = d;
        double d2 = Math.sin(alpha);
        this.a[3][4] = d2;
        this.a[0][1] = d2;
        double d3 = -Math.sin(alpha);
        this.a[4][3] = d3;
        this.a[1][0] = d3;
        this.a[5][5] = 1.0;
        this.a[2][2] = 1.0;
        this.Sg = Matrix.multiply(Matrix.multiply(Matrix.transpose(this.a), this.Sl), this.a);
        this.Mg = Matrix.multiply(Matrix.multiply(Matrix.transpose(this.a), this.Ml), this.a);
    }
}

