/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.Node;
import com.schwebke.math.Matrix;
import java.util.Enumeration;
import java.util.Vector;

public class EBBeam
extends Beam {
    static final long serialVersionUID = -1393044615864267287L;
    protected double EI;
    protected double EA;
    protected double vi;
    protected double vk;
    protected double ni;
    protected double nk;
    protected boolean[] hinged;
    public static final int hNi = 0;
    public static final int hVi = 1;
    public static final int hMi = 2;
    public static final int hNk = 3;
    public static final int hVk = 4;
    public static final int hMk = 5;
    protected double[][] invKaa;
    protected double[][] Kab;
    protected double[][] Kba;
    protected double[][] Pa;
    protected double[][] Ll;
    protected double[] v;
    protected double[] vl;
    protected double[] vkl;

    public EBBeam(Node n1, Node n2, double EI, double EA, double m) {
        super(n1, n2, m);
        this.EI = EI;
        this.EA = EA;
        this.vk = 0.0;
        this.vi = 0.0;
        this.nk = 0.0;
        this.ni = 0.0;
        this.hinged = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            this.hinged[i] = false;
        }
        this.invKaa = null;
        this.Pa = null;
        this.Kba = this.Pa;
        this.Kab = this.Pa;
        this.v = null;
        this.Ll = null;
    }

    @Override
    public double w(double f) {
        double w1 = this.vkl[1];
        double w2 = this.vkl[4];
        double wsk = w1 + f * (w2 - w1);
        return this.displace(f) - wsk;
    }

    public double displace(double f) {
        double w0 = this.vl[1];
        double x = f * this.l;
        double b0 = this.vl[2];
        double Q0 = this.Vi;
        double M0 = this.Mi;
        return ((((((this.vk - this.vi) * x + 5.0 * this.vi * this.l) * x + -20.0 * Q0 * this.l) * x + -60.0 * M0 * this.l) * x + -120.0 * b0 * this.l * this.EI) * x + 120.0 * w0 * this.EI * this.l) / (120.0 * this.l * this.EI);
    }

    public double M(double f) {
        double x = f * this.l;
        return this.Mi + this.Vi * x - this.vi * x * x * 0.5 - (this.vk - this.vi) / this.l * (x * x * x / 6.0);
    }

    public double fMaxM() {
        return this.fExtrM(true);
    }

    public double fMinM() {
        return this.fExtrM(false);
    }

    protected double fExtrM(boolean maximum) {
        double f1;
        Vector<Double> f = new Vector<Double>();
        f.addElement(new Double(0.0));
        f.addElement(new Double(1.0));
        if (Math.abs(this.vi - this.vk) > 1.0E-10) {
            double f12;
            double D = this.vi * this.vi * this.l * this.l + 2.0 * this.Vi * this.l * this.vk - 2.0 * this.Vi * this.l * this.vi;
            if (D > 1.0E-10) {
                f12 = (this.vi * this.l + Math.sqrt(D)) / (this.vi - this.vk) / this.l;
                double f2 = (this.vi * this.l - Math.sqrt(D)) / (this.vi - this.vk) / this.l;
                if (f12 > 0.0 && f12 < 1.0) {
                    f.addElement(new Double(f12));
                }
                if (f2 > 0.0 && f2 < 1.0) {
                    f.addElement(new Double(f2));
                }
            } else if (Math.abs(D) <= 1.0E-10 && (f12 = this.vi / (this.vi - this.vk)) > 0.0 && f12 < 1.0) {
                f.addElement(new Double(f12));
            }
        } else if (Math.abs(this.vi) > 1.0E-10 && (f1 = this.Vi / this.vi / this.l) > 0.0 && f1 < 1.0) {
            f.addElement(new Double(f1));
        }
        Enumeration ef = f.elements();
        double fMax = (Double)ef.nextElement();
        while (ef.hasMoreElements()) {
            double fn = (Double)ef.nextElement();
            if (maximum) {
                if (!(this.M(fn) > this.M(fMax))) continue;
                fMax = fn;
                continue;
            }
            if (!(this.M(fn) < this.M(fMax))) continue;
            fMax = fn;
        }
        return fMax;
    }

    public double V(double f) {
        double x = f * this.l;
        return this.Vi - this.vi * x - (this.vk - this.vi) / this.l * (x * x / 2.0);
    }

    public double fMaxV() {
        return this.fExtrV(true);
    }

    public double fMinV() {
        return this.fExtrV(false);
    }

    protected double fExtrV(boolean maximum) {
        double x;
        Vector<Double> f = new Vector<Double>();
        f.addElement(new Double(0.0));
        f.addElement(new Double(1.0));
        if (Math.abs(this.vi - this.vk) > 1.0E-10 && (x = this.vi * this.l / (this.vi - this.vk)) > 0.0 && x < this.l) {
            f.addElement(new Double(x / this.l));
        }
        Enumeration ef = f.elements();
        double fMax = (Double)ef.nextElement();
        while (ef.hasMoreElements()) {
            double fn = (Double)ef.nextElement();
            if (maximum) {
                if (!(this.V(fn) > this.V(fMax))) continue;
                fMax = fn;
                continue;
            }
            if (!(this.V(fn) < this.V(fMax))) continue;
            fMax = fn;
        }
        return fMax;
    }

    public double N(double f) {
        return f * this.Nk + (1.0 - f) * this.Ni;
    }

    public double getV(int n) {
        return this.v[n];
    }

    public double getEI() {
        return this.EI;
    }

    public void setEI(double EI) {
        this.EI = EI;
    }

    public double getEA() {
        return this.EA;
    }

    public void setEA(double EA) {
        this.EA = EA;
    }

    public double getVi() {
        return this.vi;
    }

    public void setVi(double vi) {
        this.vi = vi;
    }

    public double getVk() {
        return this.vk;
    }

    public void setVk(double vk) {
        this.vk = vk;
    }

    public double getNi() {
        return this.ni;
    }

    public void setNi(double ni) {
        this.ni = ni;
    }

    public double getNk() {
        return this.nk;
    }

    public void setNk(double nk) {
        this.nk = nk;
    }

    public boolean getHinge(int dof) {
        return this.hinged[dof];
    }

    public void setHinge(int dof, boolean isHinge) {
        this.hinged[dof] = isHinge;
    }

    @Override
    public void calSg() {
        this.Sl = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.Sl[i][j] = 0.0;
            }
        }
        this.Sl[0][0] = this.EA / this.l;
        double d = -this.EA / this.l;
        this.Sl[3][0] = d;
        this.Sl[0][3] = d;
        this.Sl[1][1] = 12.0 * this.EI / (this.l * this.l * this.l);
        double d2 = -6.0 * this.EI / (this.l * this.l);
        this.Sl[2][1] = d2;
        this.Sl[1][2] = d2;
        double d3 = -12.0 * this.EI / (this.l * this.l * this.l);
        this.Sl[4][1] = d3;
        this.Sl[1][4] = d3;
        double d4 = -6.0 * this.EI / (this.l * this.l);
        this.Sl[5][1] = d4;
        this.Sl[1][5] = d4;
        this.Sl[2][2] = 4.0 * this.EI / this.l;
        double d5 = 6.0 * this.EI / (this.l * this.l);
        this.Sl[4][2] = d5;
        this.Sl[2][4] = d5;
        double d6 = 2.0 * this.EI / this.l;
        this.Sl[5][2] = d6;
        this.Sl[2][5] = d6;
        this.Sl[3][3] = this.EA / this.l;
        this.Sl[4][4] = 12.0 * this.EI / (this.l * this.l * this.l);
        double d7 = 6.0 * this.EI / (this.l * this.l);
        this.Sl[5][4] = d7;
        this.Sl[4][5] = d7;
        this.Sl[5][5] = 4.0 * this.EI / this.l;
        int hN = 0;
        for (int n = 0; n < 6; ++n) {
            if (!this.hinged[n]) continue;
            ++hN;
        }
        if (hN > 0) {
            double[][] Kaa = new double[hN][hN];
            this.Kab = new double[hN][6 - hN];
            this.Kba = new double[6 - hN][hN];
            double[][] Kbb = new double[6 - hN][6 - hN];
            int aai = 0;
            int aaj = 0;
            int bbi = 0;
            int bbj = 0;
            int abi = 0;
            int abj = 0;
            int bai = 0;
            int baj = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.hinged[i]) {
                        if (this.hinged[j]) {
                            Kaa[aai][aaj++] = this.Sl[i][j];
                            continue;
                        }
                        this.Kab[abi][abj++] = this.Sl[i][j];
                        continue;
                    }
                    if (this.hinged[j]) {
                        this.Kba[bai][baj++] = this.Sl[i][j];
                        continue;
                    }
                    Kbb[bbi][bbj++] = this.Sl[i][j];
                }
                aaj = 0;
                bbj = 0;
                baj = 0;
                abj = 0;
                if (this.hinged[i]) {
                    ++aai;
                    ++abi;
                    continue;
                }
                ++bbi;
                ++bai;
            }
            this.invKaa = Matrix.invert(Kaa);
            double[][] Kred = Matrix.sub(Kbb, Matrix.multiply(this.Kba, Matrix.multiply(this.invKaa, this.Kab)));
            bbi = 0;
            bbj = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.Sl[i][j] = this.hinged[i] ? 0.0 : (this.hinged[j] ? 0.0 : Kred[bbi][bbj++]);
                }
                bbj = 0;
                if (this.hinged[i]) continue;
                ++bbi;
            }
        }
        this.calMl();
        this.transform();
        this.Ll = new double[6][1];
        this.Ll[0][0] = -(2.0 * this.ni + this.nk) * this.l / 6.0;
        this.Ll[3][0] = -(this.ni + 2.0 * this.nk) * this.l / 6.0;
        this.Ll[1][0] = -(this.l / 60.0) * (21.0 * this.vi + 9.0 * this.vk);
        this.Ll[4][0] = -(this.l / 60.0) * (9.0 * this.vi + 21.0 * this.vk);
        this.Ll[2][0] = this.l * this.l / 60.0 * (3.0 * this.vi + 2.0 * this.vk);
        this.Ll[5][0] = -(this.l * this.l / 60.0) * (2.0 * this.vi + 3.0 * this.vk);
        if (hN > 0) {
            this.Pa = new double[hN][1];
            double[][] Pb = new double[6 - hN][1];
            int a = 0;
            int b = 0;
            for (int n = 0; n < 6; ++n) {
                if (this.hinged[n]) {
                    this.Pa[a][0] = this.Ll[n][0];
                    ++a;
                    continue;
                }
                Pb[b][0] = this.Ll[n][0];
                ++b;
            }
            double[][] Pred = Matrix.sub(Pb, Matrix.multiply(Matrix.multiply(this.Kba, this.invKaa), this.Pa));
            b = 0;
            for (int n = 0; n < 6; ++n) {
                if (!this.hinged[n]) {
                    this.Ll[n][0] = Pred[b][0];
                    ++b;
                    continue;
                }
                this.Ll[n][0] = 0.0;
            }
        }
        double[][] L = Matrix.multiply(Matrix.transpose(this.a), this.Ll);
        for (int n = 0; n < 6; ++n) {
            this.Lg[n] = L[n][0];
        }
    }

    @Override
    public void postCalculate() {
        int hN = 0;
        for (int n = 0; n < 6; ++n) {
            if (!this.hinged[n]) continue;
            ++hN;
        }
        this.v = new double[6];
        this.vl = new double[6];
        this.vkl = new double[6];
        this.v[0] = this.n1.getDX();
        this.v[1] = this.n1.getDZ();
        this.v[2] = this.n1.getDR();
        this.v[3] = this.n2.getDX();
        this.v[4] = this.n2.getDZ();
        this.v[5] = this.n2.getDR();
        double[][] vg = new double[6][1];
        for (int n = 0; n < 6; ++n) {
            vg[n][0] = this.v[n];
        }
        double[][] vl = Matrix.multiply(this.a, vg);
        for (int n = 0; n < 6; ++n) {
            this.vl[n] = vl[n][0];
            this.vkl[n] = vl[n][0];
        }
        if (hN > 0) {
            int n;
            double[][] rb = new double[6 - hN][1];
            int b = 0;
            for (n = 0; n < 6; ++n) {
                if (this.hinged[n]) continue;
                rb[b][0] = vl[n][0];
                ++b;
            }
            double[][] ra = Matrix.multiply(this.invKaa, Matrix.sub(Matrix.neg(this.Pa), Matrix.multiply(this.Kab, rb)));
            b = 0;
            for (n = 0; n < 6; ++n) {
                if (!this.hinged[n]) continue;
                vl[n][0] = ra[b][0];
                ++b;
            }
            vg = Matrix.multiply(Matrix.transpose(this.a), vl);
            for (n = 0; n < 6; ++n) {
                this.v[n] = vg[n][0];
                this.vl[n] = vl[n][0];
            }
        }
        double[][] V = new double[6][1];
        for (int n = 0; n < 6; ++n) {
            V[n][0] = this.v[n];
        }
        double[][] Rl = Matrix.multiply(this.Sl, vl);
        for (int n = 0; n < 6; ++n) {
            double[] dArray = Rl[n];
            dArray[0] = dArray[0] + this.Ll[n][0];
        }
        this.Ni = -Rl[0][0];
        this.Vi = -Rl[1][0];
        this.Mi = -Rl[2][0];
        this.Nk = Rl[3][0];
        this.Vk = Rl[4][0];
        this.Mk = Rl[5][0];
    }
}

