/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.Node;
import com.schwebke.math.Matrix;
import java.util.Enumeration;
import java.util.Vector;

public class EBSBeam
extends EBBeam {
    static final long serialVersionUID = -6616605126487015726L;
    protected double GAs;
    protected double psi;

    public EBSBeam(Node n1, Node n2, double EI, double EA, double GAs, double m) {
        super(n1, n2, EI, EA, m);
        this.GAs = GAs;
        this.updatePsi();
    }

    @Override
    public double displace(double f) {
        double w0 = this.vl[1];
        double x = f * this.l;
        double b0 = this.vl[2];
        double Q0 = this.Vi;
        double M0 = this.Mi;
        return ((((((-this.GAs * this.vi + this.vk * this.GAs) * x + 5.0 * this.GAs * this.vi * this.l) * x + -20.0 * this.vk * this.EI + 20.0 * this.EI * this.vi - 20.0 * Q0 * this.GAs * this.l) * x + -60.0 * this.vi * this.l * this.EI - 60.0 * M0 * this.GAs * this.l) * x + -120.0 * b0 * this.GAs * this.l * this.EI + 120.0 * Q0 * this.l * this.EI) * x + 120.0 * this.GAs * w0 * this.EI * this.l) / (120.0 * this.GAs * this.l * this.EI);
    }

    protected double ddisplace(double f) {
        double x = f * this.l;
        double b0 = this.vl[2];
        return (((((-this.GAs * this.vi + this.vk * this.GAs) * x + 4.0 * this.vi * this.GAs * this.l) * x + -12.0 * this.Vi * this.GAs * this.l + 12.0 * this.EI * this.vi - 12.0 * this.vk * this.EI) * x + -24.0 * this.vi * this.l * this.EI - 24.0 * this.Mi * this.GAs * this.l) * x + -24.0 * b0 * this.GAs * this.l * this.EI + 24.0 * this.Vi * this.l * this.EI) / (24.0 * this.GAs * this.l * this.EI);
    }

    public double fDisplaceMax() {
        return this.fDisplaceExtr(true);
    }

    public double fDisplaceMin() {
        return this.fDisplaceExtr(false);
    }

    protected double fDisplaceExtr(boolean maximum) {
        Vector<Double> f = new Vector<Double>();
        f.addElement(new Double(0.0));
        f.addElement(new Double(1.0));
        int i = 10;
        for (int n = 0; n < i; ++n) {
            double db;
            double a = 1.0 / (double)i * (double)n;
            double b = a + 1.0 / (double)i;
            double da = this.ddisplace(a);
            if (!(da * (db = this.ddisplace(b)) <= 0.0)) continue;
            double x1 = a;
            double x2 = b;
            double y1 = da;
            double y2 = db;
            int step = 0;
            while (Math.abs(x1 - x2) > 1.0E-6) {
                double xn = x1 + y1 / ((y1 - y2) / (x2 - x1));
                if (xn < a || xn > b || ++step > 20) {
                    System.out.println("EBSBeam::fDisplaceMax(): Sekantenverfahren konvergiert nicht!");
                    break;
                }
                double yn = this.ddisplace(xn);
                x1 = x2;
                y1 = y2;
                x2 = xn;
                y2 = yn;
            }
            if (!(Math.abs(x1 - x2) <= 1.0E-6)) continue;
            f.addElement(new Double(x2));
        }
        f.addElement(new Double(0.5));
        Enumeration ef = f.elements();
        double fMax = (Double)ef.nextElement();
        while (ef.hasMoreElements()) {
            double fn = (Double)ef.nextElement();
            if (maximum) {
                if (!(this.displace(fn) > this.displace(fMax))) continue;
                fMax = fn;
                continue;
            }
            if (!(this.displace(fn) < this.displace(fMax))) continue;
            fMax = fn;
        }
        return fMax;
    }

    public double getGAs() {
        return this.GAs;
    }

    public void setGAs(double GAs) {
        this.GAs = GAs;
        this.updatePsi();
    }

    @Override
    public void setN1(Node n1) {
        super.setN1(n1);
        this.updatePsi();
    }

    @Override
    public void setN2(Node n2) {
        super.setN2(n2);
        this.updatePsi();
    }

    protected void updatePsi() {
        this.psi = 1.0 / (1.0 + 12.0 * (this.EI / (this.l * this.l * this.GAs)));
    }

    @Override
    public void calSg() {
        this.updatePsi();
        this.Sl = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.Sl[i][j] = 0.0;
            }
        }
        this.Sl[0][0] = this.EA / this.l;
        double d = -this.EA / this.l;
        this.Sl[3][0] = d;
        this.Sl[0][3] = d;
        this.Sl[1][1] = 12.0 * this.psi * this.EI / (this.l * this.l * this.l);
        double d2 = -6.0 * this.psi * this.EI / (this.l * this.l);
        this.Sl[2][1] = d2;
        this.Sl[1][2] = d2;
        double d3 = -12.0 * this.psi * this.EI / (this.l * this.l * this.l);
        this.Sl[4][1] = d3;
        this.Sl[1][4] = d3;
        double d4 = -6.0 * this.psi * this.EI / (this.l * this.l);
        this.Sl[5][1] = d4;
        this.Sl[1][5] = d4;
        this.Sl[2][2] = (1.0 + 3.0 * this.psi) * this.EI / this.l;
        double d5 = 6.0 * this.psi * this.EI / (this.l * this.l);
        this.Sl[4][2] = d5;
        this.Sl[2][4] = d5;
        double d6 = (-1.0 + 3.0 * this.psi) * this.EI / this.l;
        this.Sl[5][2] = d6;
        this.Sl[2][5] = d6;
        this.Sl[3][3] = this.EA / this.l;
        this.Sl[4][4] = 12.0 * this.psi * this.EI / (this.l * this.l * this.l);
        double d7 = 6.0 * this.psi * this.EI / (this.l * this.l);
        this.Sl[5][4] = d7;
        this.Sl[4][5] = d7;
        this.Sl[5][5] = (1.0 + 3.0 * this.psi) * this.EI / this.l;
        int hN = 0;
        for (int n = 0; n < 6; ++n) {
            if (!this.hinged[n]) continue;
            ++hN;
        }
        if (hN > 0) {
            double[][] Kaa = new double[hN][hN];
            this.Kab = new double[hN][6 - hN];
            this.Kba = new double[6 - hN][hN];
            double[][] Kbb = new double[6 - hN][6 - hN];
            int aai = 0;
            int aaj = 0;
            int bbi = 0;
            int bbj = 0;
            int abi = 0;
            int abj = 0;
            int bai = 0;
            int baj = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.hinged[i]) {
                        if (this.hinged[j]) {
                            Kaa[aai][aaj++] = this.Sl[i][j];
                            continue;
                        }
                        this.Kab[abi][abj++] = this.Sl[i][j];
                        continue;
                    }
                    if (this.hinged[j]) {
                        this.Kba[bai][baj++] = this.Sl[i][j];
                        continue;
                    }
                    Kbb[bbi][bbj++] = this.Sl[i][j];
                }
                aaj = 0;
                bbj = 0;
                baj = 0;
                abj = 0;
                if (this.hinged[i]) {
                    ++aai;
                    ++abi;
                    continue;
                }
                ++bbi;
                ++bai;
            }
            this.invKaa = Matrix.invert(Kaa);
            double[][] Kred = Matrix.sub(Kbb, Matrix.multiply(this.Kba, Matrix.multiply(this.invKaa, this.Kab)));
            bbi = 0;
            bbj = 0;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.Sl[i][j] = this.hinged[i] ? 0.0 : (this.hinged[j] ? 0.0 : Kred[bbi][bbj++]);
                }
                bbj = 0;
                if (this.hinged[i]) continue;
                ++bbi;
            }
        }
        this.calMl();
        this.transform();
        this.Ll = new double[6][1];
        this.Ll[0][0] = -(2.0 * this.ni + this.nk) * this.l / 6.0;
        this.Ll[3][0] = -(this.ni + 2.0 * this.nk) * this.l / 6.0;
        double[][] p2 = new double[2][1];
        p2[0][0] = (this.vi + this.vk) / 2.0;
        p2[1][0] = (this.vk - this.vi) / 2.0;
        double[][] p1 = new double[4][2];
        p1[0][0] = 30.0;
        p1[0][1] = -10.0 - 2.0 * this.psi;
        p1[1][0] = 30.0;
        p1[1][1] = 10.0 + 2.0 * this.psi;
        p1[2][0] = -5.0 * this.l;
        p1[2][1] = this.l * this.psi;
        p1[3][0] = 5.0 * this.l;
        p1[3][1] = this.l * this.psi;
        double[][] p = Matrix.multiply(-this.l / 60.0, Matrix.multiply(p1, p2));
        this.Ll[1][0] = p[0][0];
        this.Ll[4][0] = p[1][0];
        this.Ll[2][0] = p[2][0];
        this.Ll[5][0] = p[3][0];
        if (hN > 0) {
            this.Pa = new double[hN][1];
            double[][] Pb = new double[6 - hN][1];
            int a = 0;
            int b = 0;
            for (int n = 0; n < 6; ++n) {
                if (this.hinged[n]) {
                    this.Pa[a][0] = this.Ll[n][0];
                    ++a;
                    continue;
                }
                Pb[b][0] = this.Ll[n][0];
                ++b;
            }
            double[][] Pred = Matrix.sub(Pb, Matrix.multiply(Matrix.multiply(this.Kba, this.invKaa), this.Pa));
            b = 0;
            for (int n = 0; n < 6; ++n) {
                if (!this.hinged[n]) {
                    this.Ll[n][0] = Pred[b][0];
                    ++b;
                    continue;
                }
                this.Ll[n][0] = 0.0;
            }
        }
        double[][] L = Matrix.multiply(Matrix.transpose(this.a), this.Ll);
        for (int n = 0; n < 6; ++n) {
            this.Lg[n] = L[n][0];
        }
    }
}

