/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.ModelException;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.plugin.IModel;
import com.schwebke.math.Eigen;
import com.schwebke.math.Matrix;
import com.schwebke.math.Solver;
import java.io.Serializable;
import java.util.ArrayList;

public class Model
implements Serializable,
IModel {
    static final long serialVersionUID = -5300914168613980355L;
    protected ArrayList<Node> nodeList = new ArrayList();
    protected ArrayList<Beam> beamList = new ArrayList();
    protected boolean validCalculation = false;
    protected double[][] K = null;
    protected double[][] M = null;
    protected double[] p = null;
    protected double[][] EigenVec = null;
    protected double[] f;
    protected int mode = 0;
    protected int r = 0;

    protected void calculateBeamVectors() {
        for (Beam b : this.beamList) {
            b.calculateVector();
        }
    }

    @Override
    public Iterable<Node> getNodeIterator() {
        return this.nodeList;
    }

    @Override
    public Iterable<Beam> getBeamIterator() {
        return this.beamList;
    }

    public boolean getValidCalculation() {
        return this.validCalculation;
    }

    @Override
    public void addNode(Node node) {
        this.nodeList.add(node);
        this.validCalculation = false;
    }

    @Override
    public int getNodeIndex(Node node) {
        return this.nodeList.indexOf(node);
    }

    @Override
    public Node getIndexNode(int index) {
        return this.nodeList.get(index);
    }

    @Override
    public void addBeam(Beam beam) {
        this.beamList.add(beam);
        this.validCalculation = false;
    }

    @Override
    public int getBeamIndex(Beam beam) {
        return this.beamList.indexOf(beam);
    }

    @Override
    public Beam getIndexBeam(int index) {
        return this.beamList.get(index);
    }

    public void clearModel() {
        this.beamList.clear();
        this.nodeList.clear();
        this.validCalculation = false;
    }

    public void calculate() {
        this.calculateGlobalMatrices();
        Solver.cholesky(this.K, this.p);
        this.postCalculate(this.p);
        this.validCalculation = true;
    }

    public void calculateModal() {
        int i;
        int j;
        int i2;
        this.calculateGlobalMatrices();
        double[] tmp = new double[this.r];
        double[][] dK = Matrix.duplicate(this.K);
        for (int i3 = 0; i3 < this.r; ++i3) {
            tmp[i3] = 1.0;
        }
        Solver.cholesky(dK, tmp);
        double[][] LK = new double[this.r][this.r];
        for (i2 = 0; i2 < this.r - 1; ++i2) {
            for (j = i2 + 1; j < this.r; ++j) {
                LK[i2][j] = 0.0;
            }
        }
        for (i2 = 0; i2 < this.r; ++i2) {
            for (j = 0; j <= i2; ++j) {
                LK[i2][j] = dK[i2][j];
            }
        }
        double[][] LKT = Matrix.transpose(LK);
        double[][] invLKT = Matrix.invert(LKT);
        double[][] invLK = Matrix.transpose(invLKT);
        double[][] A = Matrix.multiply(invLK, Matrix.multiply(this.M, invLKT));
        double[][] V = Eigen.cyclJac(A);
        double[] eigenVal = new double[this.r];
        int[] eigenValIdx = new int[this.r];
        for (i = 0; i < this.r; ++i) {
            eigenValIdx[i] = i;
            eigenVal[i] = A[i][i];
        }
        for (i = 0; i < this.r - 1; ++i) {
            double max = eigenVal[i];
            int maxJ = i;
            for (int j2 = i + 1; j2 < this.r; ++j2) {
                if (!(eigenVal[j2] > max)) continue;
                max = eigenVal[j2];
                maxJ = j2;
            }
            int ti = eigenValIdx[i];
            double tv = eigenVal[i];
            eigenValIdx[i] = eigenValIdx[maxJ];
            eigenVal[i] = eigenVal[maxJ];
            eigenValIdx[maxJ] = ti;
            eigenVal[maxJ] = tv;
        }
        this.EigenVec = new double[this.r][this.r];
        this.f = new double[this.r];
        for (i = 0; i < this.r; ++i) {
            int j3;
            double omega = Math.sqrt(1.0 / eigenVal[i]);
            this.f[i] = omega / (Math.PI * 2);
            for (int j4 = 0; j4 < this.r; ++j4) {
                tmp[j4] = V[j4][eigenValIdx[i]];
            }
            tmp = Matrix.multiply(invLKT, tmp);
            double scale = 0.0;
            for (j3 = 0; j3 < this.r; ++j3) {
                if (!(Math.abs(tmp[j3]) > scale)) continue;
                scale = Math.abs(tmp[j3]);
            }
            for (j3 = 0; j3 < this.r; ++j3) {
                this.EigenVec[i][j3] = 0.01 * tmp[j3] / scale;
            }
        }
        this.validCalculation = true;
        this.setMode(0);
    }

    public void setMode(int i) {
        if (this.validCalculation) {
            this.mode = i;
            this.postCalculate(this.EigenVec[i]);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public double getFreq() {
        if (this.f != null) {
            return this.f[this.mode];
        }
        return 0.0;
    }

    public void nextMode() {
        if (this.validCalculation && this.EigenVec != null) {
            ++this.mode;
            if (this.mode >= this.r) {
                this.mode = 0;
            }
            this.postCalculate(this.EigenVec[this.mode]);
        }
    }

    public void prevMode() {
        if (this.validCalculation && this.EigenVec != null) {
            --this.mode;
            if (this.mode < 0) {
                this.mode = this.r - 1;
            }
            this.postCalculate(this.EigenVec[this.mode]);
        }
    }

    protected void calculateGlobalMatrices() {
        this.r = 0;
        for (Node node : this.nodeList) {
            node.nX = !node.cX ? ++this.r : 0;
            node.nZ = !node.cZ ? ++this.r : 0;
            if (!node.cR) {
                node.nR = ++this.r;
                continue;
            }
            node.nR = 0;
        }
        if (this.r == 0) {
            throw new ModelException("no global DOFs");
        }
        this.K = new double[this.r][this.r];
        this.M = new double[this.r][this.r];
        this.p = new double[this.r];
        for (int n = 0; n < this.r; ++n) {
            this.p[n] = 0.0;
        }
        for (Beam beam : this.beamList) {
            int[] locationVector = new int[]{beam.n1.nX, beam.n1.nZ, beam.n1.nR, beam.n2.nX, beam.n2.nZ, beam.n2.nR};
            beam.calSg();
            for (int i = 0; i < 6; ++i) {
                if (locationVector[i] != 0) {
                    double[] dArray = this.K[locationVector[i] - 1];
                    int n = locationVector[i] - 1;
                    dArray[n] = dArray[n] + beam.Sg[i][i];
                    double[] dArray2 = this.M[locationVector[i] - 1];
                    int n2 = locationVector[i] - 1;
                    dArray2[n2] = dArray2[n2] + beam.Mg[i][i];
                }
                for (int j = i + 1; j < 6; ++j) {
                    if (locationVector[i] == 0 || locationVector[j] == 0) continue;
                    double[] dArray = this.K[locationVector[i] - 1];
                    int n = locationVector[j] - 1;
                    dArray[n] = dArray[n] + beam.Sg[i][j];
                    double[] dArray3 = this.K[locationVector[j] - 1];
                    int n3 = locationVector[i] - 1;
                    dArray3[n3] = dArray3[n3] + beam.Sg[j][i];
                    double[] dArray4 = this.M[locationVector[i] - 1];
                    int n4 = locationVector[j] - 1;
                    dArray4[n4] = dArray4[n4] + beam.Mg[i][j];
                    double[] dArray5 = this.M[locationVector[j] - 1];
                    int n5 = locationVector[i] - 1;
                    dArray5[n5] = dArray5[n5] + beam.Mg[j][i];
                }
            }
            if (!beam.n1.cX) {
                int n = beam.n1.nX - 1;
                this.p[n] = this.p[n] - beam.Lg[0];
            }
            if (!beam.n1.cZ) {
                int n = beam.n1.nZ - 1;
                this.p[n] = this.p[n] - beam.Lg[1];
            }
            if (!beam.n1.cR) {
                int n = beam.n1.nR - 1;
                this.p[n] = this.p[n] - beam.Lg[2];
            }
            if (!beam.n2.cX) {
                int n = beam.n2.nX - 1;
                this.p[n] = this.p[n] - beam.Lg[3];
            }
            if (!beam.n2.cZ) {
                int n = beam.n2.nZ - 1;
                this.p[n] = this.p[n] - beam.Lg[4];
            }
            if (beam.n2.cR) continue;
            int n = beam.n2.nR - 1;
            this.p[n] = this.p[n] - beam.Lg[5];
        }
        for (Node node : this.nodeList) {
            if (!node.cX) {
                int n = node.nX - 1;
                this.p[n] = this.p[n] + node.Fx;
            }
            if (!node.cZ) {
                int n = node.nZ - 1;
                this.p[n] = this.p[n] + node.Fz;
            }
            if (node.cR) continue;
            int n = node.nR - 1;
            this.p[n] = this.p[n] + node.M;
        }
    }

    protected void postCalculate(double[] p) {
        for (Node node : this.nodeList) {
            node.dX = !node.cX ? p[node.nX - 1] : 0.0;
            node.dZ = !node.cZ ? p[node.nZ - 1] : 0.0;
            if (!node.cR) {
                node.dR = p[node.nR - 1];
                continue;
            }
            node.dR = 0.0;
        }
        for (Beam beam : this.beamList) {
            beam.postCalculate();
        }
        for (Node node : this.nodeList) {
            node.rFx = 0.0;
            node.rFz = 0.0;
            node.rM = 0.0;
        }
        for (Beam beam : this.beamList) {
            double[][] Sl = new double[6][1];
            Sl[0][0] = -beam.Ni;
            Sl[1][0] = -beam.Vi;
            Sl[2][0] = -beam.Mi;
            Sl[3][0] = beam.Nk;
            Sl[4][0] = beam.Vk;
            Sl[5][0] = beam.Mk;
            double[][] Sg = Matrix.multiply(Matrix.transpose(beam.a), Sl);
            if (beam.n1.cX) {
                beam.n1.rFx += Sg[0][0];
            }
            if (beam.n1.cZ) {
                beam.n1.rFz += Sg[1][0];
            }
            if (beam.n1.cR) {
                beam.n1.rM += Sg[2][0];
            }
            if (beam.n2.cX) {
                beam.n2.rFx += Sg[3][0];
            }
            if (beam.n2.cZ) {
                beam.n2.rFz += Sg[4][0];
            }
            if (!beam.n2.cR) continue;
            beam.n2.rM += Sg[5][0];
        }
    }
}

