/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.Model;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.view.BeamRenderer;
import com.schwebke.jbeam.view.NodeRenderer;
import com.schwebke.jbeam.view.View;
import java.util.ArrayList;
import java.util.LinkedList;

public class SelectableModel
extends Model {
    static final long serialVersionUID = 4833467666795694803L;
    LinkedList selectionList;
    double refX = 0.0;
    double refZ = 0.0;
    boolean ref = false;
    boolean refSnap = false;
    boolean refRect = false;
    Node[] node = new Node[2];

    public SelectableModel() {
        this.selectionList = new LinkedList();
    }

    public void clearSelection() {
        this.selectionList.clear();
    }

    @Override
    public void clearModel() {
        super.clearModel();
        this.selectionList.clear();
        this.refX = 0.0;
        this.refZ = 0.0;
        this.ref = false;
        this.node = new Node[2];
    }

    public Node getNode(int num) {
        Node n = this.node[num];
        this.node[num] = null;
        this.validCalculation = false;
        this.ref = false;
        return n;
    }

    public Iterable getSelectionIterator() {
        return this.selectionList;
    }

    public boolean hasSelectedObjects() {
        return !this.selectionList.isEmpty();
    }

    public Object getSelectedObject() {
        this.validCalculation = false;
        return this.selectionList.pop();
    }

    public int delete() {
        int delCount = 0;
        for (Object obj : this.selectionList) {
            Beam beam;
            if (obj instanceof Node) {
                LinkedList<Beam> deleteList = new LinkedList<Beam>();
                Node node = (Node)obj;
                for (Beam beam2 : this.beamList) {
                    if (beam2.n1 != node && beam2.n2 != node) continue;
                    deleteList.add(beam2);
                }
                for (Beam beam2 : deleteList) {
                    if (!this.beamList.remove(beam2)) continue;
                    ++delCount;
                }
                if (!this.nodeList.remove(node)) continue;
                ++delCount;
                continue;
            }
            if (!(obj instanceof Beam) || !this.beamList.remove(beam = (Beam)obj)) continue;
            ++delCount;
        }
        this.clearSelection();
        this.validCalculation = false;
        return delCount;
    }

    public void setRef(double x, double z, boolean snap, boolean rect) {
        this.refX = x;
        this.refZ = z;
        this.ref = true;
        this.refSnap = snap;
        this.refRect = rect;
    }

    public boolean getRef() {
        return this.ref;
    }

    public double getRefX() {
        return this.refX;
    }

    public double getRefZ() {
        return this.refZ;
    }

    public boolean getRefSnap() {
        return this.refSnap;
    }

    public boolean getRefRect() {
        return this.refRect;
    }

    public void noRef() {
        this.ref = false;
    }

    public int move(double x, double z) {
        this.ref = false;
        int moveCount = 0;
        ArrayList<Node> extendSelection = new ArrayList<Node>();
        for (Object obj : this.selectionList) {
            if (!(obj instanceof Beam)) continue;
            Node n1 = ((Beam)obj).n1;
            Node n2 = ((Beam)obj).n2;
            if (!this.selectionList.contains(n1) && !extendSelection.contains(n1)) {
                extendSelection.add(n1);
            }
            if (this.selectionList.contains(n2) || extendSelection.contains(n2)) continue;
            extendSelection.add(n2);
        }
        this.selectionList.addAll(extendSelection);
        for (Object obj : this.selectionList) {
            if (!(obj instanceof Node)) continue;
            ((Node)obj).x += x - this.refX;
            ((Node)obj).z += z - this.refZ;
            ++moveCount;
        }
        this.clearSelection();
        this.validCalculation = false;
        this.calculateBeamVectors();
        return moveCount;
    }

    public boolean selectNode(double x, double z, int num, double r) {
        for (Node node : this.nodeList) {
            if (!(node.getDistance(x, z) < r)) continue;
            this.node[num] = node;
            this.setRef(node.getX(), node.getZ(), false, false);
            return true;
        }
        return false;
    }

    public int addSelection(double x, double z, double r, View view) {
        int selCount = 0;
        for (Node node : this.nodeList) {
            if (!NodeRenderer.selected(x, z, r, node, view)) continue;
            if (!this.selectionList.remove(node)) {
                this.selectionList.add(node);
                ++selCount;
                continue;
            }
            --selCount;
        }
        if (selCount == 0) {
            for (Beam beam : this.beamList) {
                if (!BeamRenderer.selected(x, z, r, beam, view)) continue;
                if (!this.selectionList.remove(beam)) {
                    this.selectionList.add(beam);
                    ++selCount;
                    continue;
                }
                --selCount;
            }
        }
        return selCount;
    }

    public int addSelectionWindow(double x, double z) {
        int selCount = 0;
        double x1 = Math.min(x, this.refX);
        double x2 = Math.max(x, this.refX);
        double z1 = Math.min(z, this.refZ);
        double z2 = Math.max(z, this.refZ);
        for (Node node : this.nodeList) {
            if (!(node.getX() > x1) || !(node.getX() < x2) || !(node.getZ() > z1) || !(node.getZ() < z2)) continue;
            if (!this.selectionList.remove(node)) {
                this.selectionList.add(node);
                ++selCount;
                continue;
            }
            --selCount;
        }
        for (Beam beam : this.beamList) {
            if (!(beam.getN1().getX() > x1) || !(beam.getN1().getX() < x2) || !(beam.getN1().getZ() > z1) || !(beam.getN1().getZ() < z2) || !(beam.getN2().getX() > x1) || !(beam.getN2().getX() < x2) || !(beam.getN2().getZ() > z1) || !(beam.getN2().getZ() < z2)) continue;
            if (!this.selectionList.remove(beam)) {
                this.selectionList.add(beam);
                ++selCount;
                continue;
            }
            --selCount;
        }
        this.noRef();
        return selCount;
    }
}

