/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.model;

import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.Node;
import com.schwebke.math.Matrix;

public class Truss
extends Beam {
    static final long serialVersionUID = -356625506417692745L;
    protected double EA;

    public Truss(Node n1, Node n2, double EA, double m) {
        super(n1, n2, m);
        this.EA = EA;
    }

    public double getEA() {
        return this.EA;
    }

    public void setEA(double EA) {
        this.EA = EA;
    }

    @Override
    public void calSg() {
        double l = Math.sqrt((this.n1.x - this.n2.x) * (this.n1.x - this.n2.x) + (this.n1.z - this.n2.z) * (this.n1.z - this.n2.z));
        this.Sl = new double[6][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.Sl[i][j] = 0.0;
            }
        }
        double d = this.EA / l;
        this.Sl[3][3] = d;
        this.Sl[0][0] = d;
        double d2 = -this.EA / l;
        this.Sl[3][0] = d2;
        this.Sl[0][3] = d2;
        this.calMl();
        this.transform();
    }

    @Override
    public void postCalculate() {
        double[][] V = new double[6][1];
        V[0][0] = this.n1.getDX();
        V[1][0] = this.n1.getDZ();
        V[2][0] = this.n1.getDR();
        V[3][0] = this.n2.getDX();
        V[4][0] = this.n2.getDZ();
        V[5][0] = this.n2.getDR();
        double[][] Rl = Matrix.multiply(Matrix.multiply(this.Sl, this.a), V);
        this.Ni = -Rl[0][0];
        this.Vi = -Rl[1][0];
        this.Mi = Rl[2][0];
        this.Nk = Rl[3][0];
        this.Vk = Rl[4][0];
        this.Mk = Rl[5][0];
    }

    @Override
    public double w(double f) {
        return 0.0;
    }

    public double N(double f) {
        return f * this.Nk + (1.0 - f) * this.Ni;
    }
}

