/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.view;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.Model;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.model.Truss;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.PropertyResourceBundle;

public class HtmlView {
    Model model;
    JBeam controller;

    public HtmlView(Model model, JBeam controller) {
        this.model = model;
        this.controller = controller;
    }

    String format(double number) {
        return this.controller.getNumberFormat().format(number);
    }

    public void write(PrintWriter writer) {
        try {
            Truss truss;
            EBBeam beam;
            FileInputStream localeRes = new FileInputStream("resourcen/locale.txt");
            PropertyResourceBundle locale = new PropertyResourceBundle(localeRes);
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>");
            writer.println(locale.getString("ResTitle"));
            writer.println("</title>");
            writer.println("</head>");
            writer.println("<body>");
            writer.println("");
            writer.println("<h1>" + locale.getString("ResTitle") + "</h1>");
            if (!this.model.getValidCalculation()) {
                this.model.calculate();
                if (!this.model.getValidCalculation()) {
                    return;
                }
            }
            writer.println("<br><br><h2>" + locale.getString("ResSupportReactions") + "</h2>");
            writer.println("<table cellpadding=5>");
            writer.println("<tr><th bgcolor=#FFCCCC>" + locale.getString("ResNode") + "</th><th bgcolor=#CCCCFF>Fx</th><th bgcolor=#CCCCFF>Fz</th><th bgcolor=#CCCCFF>M</th></tr>");
            for (Node node : this.model.getNodeIterator()) {
                if (node.getLabel().equals("") || !node.getCX() && !node.getCZ() && !node.getCR()) continue;
                writer.println("<tr>");
                writer.println("<td bgcolor=#00FFFF>" + node.getLabel() + "</td>");
                if (node.getCX()) {
                    writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getRFx()) + "</td>");
                } else {
                    writer.println("<td bgcolor=#CCFFCC>-</td>");
                }
                if (node.getCZ()) {
                    writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getRFz()) + "</td>");
                } else {
                    writer.println("<td bgcolor=#CCFFCC>-</td>");
                }
                if (node.getCR()) {
                    writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getRM()) + "</td>");
                } else {
                    writer.println("<td bgcolor=#CCFFCC>-</td>");
                }
                writer.println("</tr>");
            }
            writer.println("</table>");
            Iterable<Node> nodeIterable = this.model.getNodeIterator();
            if (nodeIterable.iterator().hasNext()) {
                writer.println("<br><br><h2>" + locale.getString("ResNodalDisplacements") + "</h2>");
                writer.println("<table cellpadding=5>");
                writer.println("<tr><th bgcolor=#FFCCCC>" + locale.getString("ResNode") + "</th><th bgcolor=#CCCCFF>dx</th><th bgcolor=#CCCCFF>dz</th><th bgcolor=#CCCCFF>dr</th></tr>");
            }
            for (Node node : nodeIterable) {
                if (node.getLabel().equals("")) continue;
                writer.println("<tr>");
                writer.println("<td bgcolor=#00FFFF>" + node.getLabel() + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getDX()) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getDZ()) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(node.getDR()) + "</td>");
                writer.println("</tr>");
            }
            writer.println("</table>");
            for (Beam element : this.model.getBeamIterator()) {
                if (!(element instanceof EBBeam) || (beam = (EBBeam)element).getLabel().equals("")) continue;
                writer.println();
                writer.println("<br><br><h2>" + locale.getString("ResStressResultants") + "</h2>");
                writer.println("<table cellpadding=5>");
                writer.println("<tr><th bgcolor=#FFCCCC>EB-beam</th>");
                writer.println("<th bgcolor=#CCCCFF>Ni</th>");
                writer.println("<th bgcolor=#CCCCFF>Vi</th>");
                writer.println("<th bgcolor=#CCCCFF>Mi</th>");
                writer.println("<th bgcolor=#CCCCFF>Nk</th>");
                writer.println("<th bgcolor=#CCCCFF>Vk</th>");
                writer.println("<th bgcolor=#CCCCFF>Mk</th></tr>");
                break;
            }
            for (Beam element : this.model.getBeamIterator()) {
                if (!(element instanceof EBBeam) || (beam = (EBBeam)element).getLabel().equals("")) continue;
                writer.println("<tr><td bgcolor=#00FFFF>" + beam.getLabel() + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.N(0.0)) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.V(0.0)) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.M(0.0)) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.N(1.0)) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.V(1.0)) + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(beam.M(1.0)) + "</td></tr>");
            }
            writer.println("</table>");
            for (Beam element : this.model.getBeamIterator()) {
                if (!(element instanceof Truss) || (truss = (Truss)element).getLabel().equals("")) continue;
                writer.println("<table cellpadding=5>");
                writer.println("<tr><th bgcolor=#FFCCCC>Truss</th><th bgcolor=#CCCCFF>N</th></tr>");
                break;
            }
            for (Beam element : this.model.getBeamIterator()) {
                if (!(element instanceof Truss) || (truss = (Truss)element).getLabel().equals("")) continue;
                writer.println("<tr><td bgcolor=#00FFFF>" + truss.getLabel() + "</td>");
                writer.println("<td align=right bgcolor=#CCFFCC>" + this.format(truss.N(0.0)) + "</td></tr>");
            }
            writer.println("</table>");
            writer.println("</body>");
            writer.println("</html>");
        }
        catch (Exception e) {
            System.out.println("HtmlView error: " + e.getMessage());
        }
    }
}

