/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.view;

import com.schwebke.jbeam.math.Line;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.view.View;
import com.schwebke.math.MVector;
import java.awt.Color;

public class NodeRenderer {
    static void draw(View view, Node node) {
        NodeRenderer.drawElement(view, node);
    }

    static void drawElement(View view, Node node) {
        Color oldColor = view.getColor();
        double x = node.getX();
        double z = node.getZ();
        double Fz = node.getFz();
        double Fx = node.getFx();
        double M = node.getM();
        view.move(x, z);
        if (!node.getCR()) {
            view.drawBCircle(0.75);
        }
        if (node.getCX() && node.getCZ() && node.getCR()) {
            view.move(x, z);
            view.drawBLineRel(0.0, 3.0);
            view.moveBRel(-3.0, 0.0);
            view.drawBLineRel(6.0, 0.0);
            for (int n = 0; n < 6; ++n) {
                view.drawBLineRel(-1.0, 1.0);
                view.moveBRel(0.0, -1.0);
            }
        } else {
            view.move(x, z);
            if (node.getCR()) {
                view.moveBRel(-1.0, -1.0);
                view.drawBLineRel(2.0, 0.0);
                view.drawBLineRel(0.0, 2.0);
                view.drawBLineRel(-2.0, 0.0);
                view.drawBLineRel(0.0, -2.0);
            }
            view.move(x, z);
            if (node.getCX() && node.getCZ()) {
                double[] ax = new double[]{0.0, -2.8, 2.8, 0.0};
                double[] ay = new double[]{0.0, 4.0, 4.0, 0.0};
                view.drawBPolygonRel(ax, ay, ax.length);
                view.move(x, z);
                view.moveBRel(2.8, 4.0);
                for (int n = 0; n < 6; ++n) {
                    view.drawBLineRel(-1.0, 1.0);
                    view.moveBRel(0.0, -1.0);
                }
            } else if (node.getCX()) {
                double[] ax = new double[]{0.0, -4.0, -4.0, 0.0};
                double[] ay = new double[]{0.0, -2.8, 2.8, 0.0};
                view.drawBPolygonRel(ax, ay, ax.length);
                view.move(x, z);
                view.moveBRel(-4.5, -3.0);
                view.drawBLineRel(0.0, 6.0);
            } else if (node.getCZ()) {
                double[] ax = new double[]{0.0, -2.8, 2.8, 0.0};
                double[] ay = new double[]{0.0, 4.0, 4.0, 0.0};
                view.drawBPolygonRel(ax, ay, ax.length);
                view.move(x, z);
                view.moveBRel(-3.0, 4.5);
                view.drawBLineRel(6.0, 0.0);
            }
        }
        if (Math.abs(Fx) > 1.0E-10 || Math.abs(Fz) > 1.0E-10) {
            view.colorLoad();
            double len = Math.sqrt(Fx * Fx + Fz * Fz);
            view.move(x, z);
            view.moveBRel(Fx / len * -15.0, Fz / len * -15.0);
            view.drawBLineRel(Fx / len * 12.0, Fz / len * 12.0);
            MVector f = new MVector(Fx / len, 0.0, Fz / len);
            MVector n = MVector.cross(new MVector(0.0, 1.0, 0.0), f);
            view.drawBLineRel(-f.x * 4.0 + n.x * 2.0, -f.z * 4.0 + n.z * 2.0);
            view.drawBLineRel(-n.x * 4.0, -n.z * 4.0);
            view.drawBLineRel(f.x * 4.0 + n.x * 2.0, f.z * 4.0 + n.z * 2.0);
            view.move(x, z);
            view.moveBRel(Fx / len * -15.0, Fz / len * -15.0);
            view.drawString(view.controller.getNumberFormat().format(len));
        }
        if (Math.abs(M) > 1.0E-10) {
            view.colorLoad();
            view.move(x, z);
            view.drawBArc(7.0, 0, 180);
            if (M > 0.0) {
                view.moveBRel(-7.0, 0.0);
            } else {
                view.moveBRel(7.0, 0.0);
            }
            view.drawBLineRel(-2.0, -2.0);
            view.drawBLineRel(4.0, 0.0);
            view.drawBLineRel(-2.0, 2.0);
            view.move(x, z);
            view.moveBRel(0.0, -8.0);
            view.drawString(view.controller.getNumberFormat().format(M));
        }
        if (!node.getLabel().equals("")) {
            view.colorLabel();
            view.move(x, z);
            view.moveBRel(-2.0, 4.0);
            view.drawString(node.getLabel());
        }
        view.setColor(oldColor);
    }

    public static boolean selected(double x, double z, double r, Node node, View view) {
        double bscale = view.baseScale(1.0);
        double critR = 5.0 * bscale;
        if (x < node.getX() - critR || x > node.getX() + critR || z < node.getZ() - critR || z > node.getZ() + critR) {
            return false;
        }
        if (!node.getCX() && !node.getCZ()) {
            return Math.sqrt((x - node.getX()) * (x - node.getX()) + (z - node.getZ()) * (z - node.getZ())) <= r;
        }
        if (node.getCX() && node.getCZ() && node.getCR()) {
            Line l1 = new Line(node.getX(), node.getZ(), node.getX(), node.getZ() + 3.5 * bscale);
            Line l2 = new Line(node.getX() - 3.0 * bscale, node.getZ() + 3.5 * bscale, node.getX() + 3.0 * bscale, node.getZ() + 3.5 * bscale);
            return Math.min(l1.getDistance(x, z), l2.getDistance(x, z)) <= r;
        }
        if (node.getCZ()) {
            Line l1 = new Line(node.getX(), node.getZ(), node.getX() - 2.8 * bscale, node.getZ() + 4.5 * bscale);
            Line l2 = new Line(node.getX() - 2.8 * bscale, node.getZ() + 4.5 * bscale, node.getX() + 2.8 * bscale, node.getZ() + 4.5 * bscale);
            Line l3 = new Line(node.getX() + 2.8 * bscale, node.getZ() + 4.5 * bscale, node.getX(), node.getZ());
            return Math.min(l1.getDistance(x, z), Math.min(l2.getDistance(x, z), l3.getDistance(x, z))) <= r;
        }
        Line l1 = new Line(node.getX(), node.getZ(), node.getX() - 4.5 * bscale, node.getZ() - 2.8 * bscale);
        Line l2 = new Line(node.getX() - 4.5 * bscale, node.getZ() - 2.8 * bscale, node.getX() - 4.5 * bscale, node.getZ() + 2.8 * bscale);
        Line l3 = new Line(node.getX() - 4.5 * bscale, node.getZ() + 2.8 * bscale, node.getX(), node.getZ());
        return Math.min(l1.getDistance(x, z), Math.min(l2.getDistance(x, z), l3.getDistance(x, z))) <= r;
    }
}

