/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.view;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.Model;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.model.Truss;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.PropertyResourceBundle;

public class TextView {
    Model model;
    JBeam controller;

    public TextView(Model model, JBeam controller) {
        this.model = model;
        this.controller = controller;
    }

    String format(double number) {
        return this.controller.getNumberFormat().format(number);
    }

    public void write(PrintWriter writer) {
        try {
            FileInputStream localeRes = new FileInputStream("resourcen/locale.txt");
            PropertyResourceBundle locale = new PropertyResourceBundle(localeRes);
            writer.println(locale.getString("ResTitle"));
            writer.println();
            writer.println();
            if (!this.model.getValidCalculation()) {
                this.model.calculate();
                if (!this.model.getValidCalculation()) {
                    return;
                }
            }
            writer.println("   " + locale.getString("ResSupportReactions"));
            for (Node node : this.model.getNodeIterator()) {
                if (node.getLabel().equals("") || !node.getCX() && !node.getCZ() && !node.getCR()) continue;
                writer.println("      " + locale.getString("ResNode") + " '" + node.getLabel() + "'");
                if (node.getCX()) {
                    writer.println("         Fx = " + this.format(node.getRFx()));
                }
                if (node.getCZ()) {
                    writer.println("         Fz = " + this.format(node.getRFz()));
                }
                if (!node.getCR()) continue;
                writer.println("         M  = " + this.format(node.getRM()));
            }
            writer.println();
            writer.println("   " + locale.getString("ResNodalDisplacements"));
            for (Node node : this.model.getNodeIterator()) {
                if (node.getLabel().equals("")) continue;
                writer.println("      " + locale.getString("ResNode") + " '" + node.getLabel() + "'");
                writer.println("         dx = " + this.format(node.getDX()));
                writer.println("         dz = " + this.format(node.getDZ()));
                writer.println("         dr = " + this.format(node.getDR()));
            }
            writer.println();
            writer.println("   " + locale.getString("ResStressResultants"));
            for (Beam element : this.model.getBeamIterator()) {
                Truss truss;
                EBBeam beam;
                if (element instanceof EBBeam && !(beam = (EBBeam)element).getLabel().equals("")) {
                    writer.println("      EB-beam '" + beam.getLabel() + "'");
                    writer.println("         Ni = " + this.format(beam.N(0.0)));
                    writer.println("         Vi = " + this.format(beam.V(0.0)));
                    writer.println("         Mi = " + this.format(beam.M(0.0)));
                    writer.println("         Nk = " + this.format(beam.N(1.0)));
                    writer.println("         Vk = " + this.format(beam.V(1.0)));
                    writer.println("         Mk = " + this.format(beam.M(1.0)));
                }
                if (!(element instanceof Truss) || (truss = (Truss)element).getLabel().equals("")) continue;
                writer.println("      Truss '" + truss.getLabel() + "'");
                writer.println("         N  = " + this.format(truss.N(0.0)));
            }
        }
        catch (Exception e) {
            System.out.println("TextView error: " + e.getMessage());
        }
    }
}

