/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.jbeam.view;

import com.schwebke.jbeam.JBeam;
import com.schwebke.jbeam.math.Distance;
import com.schwebke.jbeam.model.Beam;
import com.schwebke.jbeam.model.EBBeam;
import com.schwebke.jbeam.model.EBSBeam;
import com.schwebke.jbeam.model.Node;
import com.schwebke.jbeam.model.SelectableModel;
import com.schwebke.jbeam.model.Truss;
import com.schwebke.jbeam.view.EBBeamRenderer;
import com.schwebke.jbeam.view.EBSBeamRenderer;
import com.schwebke.jbeam.view.NodeRenderer;
import com.schwebke.jbeam.view.TrussRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class View
extends JComponent {
    double baseSize;
    double sX;
    double sY;
    Color color;
    Graphics2D g;
    double fX;
    double fZ;
    double grid;
    int oX;
    int oY;
    boolean showDisplacement;
    double displacementScale;
    boolean showMoment;
    double momentScale;
    boolean showShearForce;
    double shearForceScale;
    boolean showNormalForce;
    double normalForceScale;
    SelectableModel model;
    JBeam controller;
    private static final Stroke normalLine = new BasicStroke(1.0f, 1, 1);
    private static final Stroke thickLine = new BasicStroke(3.0f, 1, 1);
    private static final Stroke dashedLine = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private static final RenderingHints rhStandard = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static final RenderingHints rhPure;
    RubberBand rubberBand;
    private static final Color fillColor;

    public View(SelectableModel model, JBeam controller) {
        this.model = model;
        this.controller = controller;
        this.reset();
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    public void reset() {
        this.sX = 0.0;
        this.sY = 0.0;
        this.fX = 20.0;
        this.fZ = 20.0;
        this.oX = 300;
        this.oY = 200;
        this.color = Color.black;
        this.grid = 2.0;
        this.baseSize = 4.0;
        this.showDisplacement = false;
        this.displacementScale = 100.0;
        this.showMoment = false;
        this.momentScale = 1.0;
        this.showShearForce = false;
        this.shearForceScale = 1.0;
        this.showNormalForce = false;
        this.normalForceScale = 1.0;
        this.rubberBand = null;
    }

    void addRubberBand(int baseX, int baseY, boolean snap, boolean rect) {
        if (this.rubberBand != null) {
            this.removeMouseMotionListener(this.rubberBand);
        }
        this.rubberBand = new RubberBand(baseX, baseY, this, snap, rect);
        this.addMouseMotionListener(this.rubberBand);
    }

    void removeRubberBand() {
        this.removeMouseMotionListener(this.rubberBand);
        this.rubberBand = null;
        this.repaint();
    }

    public void setModel(SelectableModel model) {
        this.model = model;
        this.repaint();
    }

    @Override
    public void paint(Graphics gAWT) {
        this.g = (Graphics2D)gAWT;
        this.g.setRenderingHints(rhStandard);
        this.g.setColor(this.getBackground());
        this.g.setStroke(normalLine);
        this.g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        double wxStart = this.snap(this.worldX(this.g.getClipBounds().x));
        double wzStart = this.snap(this.worldZ(this.g.getClipBounds().y));
        double wxStop = this.snap(this.worldX(this.g.getClipBounds().x + this.g.getClipBounds().width));
        double wzStop = this.snap(this.worldZ(this.g.getClipBounds().y + this.g.getClipBounds().height));
        this.g.setColor(Color.black);
        if (Math.min(this.grid * this.fX, this.grid * this.fZ) > 5.0) {
            for (double wX = wxStart; wX <= wxStop; wX += this.grid) {
                int x = this.screenX(wX);
                for (double wZ = wzStart; wZ <= wzStop; wZ += this.grid) {
                    int y = this.screenY(wZ);
                    this.g.drawLine(x, y, x, y);
                }
            }
        }
        this.colorStd();
        for (Beam beam : this.model.getBeamIterator()) {
            if (beam instanceof Truss) {
                TrussRenderer.draw(this, (Truss)beam);
            }
            if (beam instanceof EBBeam) {
                EBBeamRenderer.draw(this, (EBBeam)beam);
            }
            if (!(beam instanceof EBSBeam)) continue;
            EBSBeamRenderer.draw(this, (EBSBeam)beam);
        }
        for (Node node : this.model.getNodeIterator()) {
            NodeRenderer.draw(this, node);
        }
        this.colorSel();
        for (Distance obj : this.model.getSelectionIterator()) {
            if (obj instanceof Truss) {
                TrussRenderer.drawElement(this, (Truss)obj);
            }
            if (obj instanceof EBBeam) {
                EBBeamRenderer.drawElement(this, (EBBeam)obj);
            }
            if (obj instanceof EBSBeam) {
                EBSBeamRenderer.drawElement(this, (EBSBeam)obj);
            }
            if (!(obj instanceof Node)) continue;
            NodeRenderer.drawElement(this, (Node)obj);
        }
        if (this.model.getRef()) {
            if (this.rubberBand == null) {
                this.addRubberBand(this.screenX(this.model.getRefX()), this.screenY(this.model.getRefZ()), this.model.getRefSnap(), this.model.getRefRect());
            }
        } else if (this.rubberBand != null) {
            this.removeRubberBand();
        }
        super.paint(this.g);
    }

    public int screenX(double wX) {
        return (int)(wX * this.fX + (double)this.oX);
    }

    public int screenY(double wZ) {
        return (int)(wZ * this.fZ + (double)this.oY);
    }

    public double screenXd(double wX) {
        return wX * this.fX + (double)this.oX;
    }

    public double screenYd(double wZ) {
        return wZ * this.fZ + (double)this.oY;
    }

    public double worldX(double sX) {
        return (sX - (double)this.oX) / this.fX;
    }

    public double worldZ(double sY) {
        return (sY - (double)this.oY) / this.fZ;
    }

    public double worldScale(double s) {
        return s / ((this.fX + this.fZ) / 2.0);
    }

    double snap(double v) {
        return (double)Math.round(v / this.grid) * this.grid;
    }

    public double baseScale(double b) {
        return this.worldScale(b * this.baseSize);
    }

    public void setRHstandard() {
        this.g.setRenderingHints(rhStandard);
    }

    public void setRHpure() {
        this.g.setRenderingHints(rhPure);
    }

    public void move(double wX, double wZ) {
        this.sX = this.screenXd(wX);
        this.sY = this.screenYd(wZ);
    }

    public void drawLine(double wX, double wZ) {
        this.g.setColor(this.color);
        this.sX = this.screenXd(wX);
        this.sY = this.screenYd(wZ);
        Line2D.Double l = new Line2D.Double(this.sX, this.sY, this.sX, this.sY);
        this.g.draw(l);
    }

    public void drawThickLine(double wX, double wZ) {
        this.g.setColor(this.color);
        this.g.setStroke(thickLine);
        double sXnew = this.screenXd(wX);
        double sYnew = this.screenYd(wZ);
        Line2D.Double l = new Line2D.Double(this.sX, this.sY, sXnew, sYnew);
        this.g.draw(l);
        this.g.setStroke(normalLine);
        this.sX = sXnew;
        this.sY = sYnew;
    }

    public void drawDashedLineRel(double wX, double wZ) {
        this.g.setColor(this.color);
        this.g.setStroke(dashedLine);
        double sXnew = this.screenXd(this.worldX(this.sX) + wX);
        double sYnew = this.screenYd(this.worldZ(this.sY) + wZ);
        Line2D.Double l = new Line2D.Double(this.sX, this.sY, sXnew, sYnew);
        this.g.draw(l);
        this.g.setStroke(normalLine);
        this.sX = sXnew;
        this.sY = sYnew;
    }

    public void fillPolygon(double[] ax, double[] az, int l) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(this.screenXd(ax[0]), this.screenYd(az[0]));
        for (int n = 1; n < l; ++n) {
            p.lineTo(this.screenXd(ax[n]), this.screenYd(az[n]));
        }
        p.lineTo(this.screenXd(ax[0]), this.screenYd(az[0]));
        this.g.setColor(this.color);
        this.g.fill(p);
    }

    public void drawPolygon(double[] ax, double[] az, int l) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(this.screenXd(ax[0]), this.screenYd(az[0]));
        for (int n = 1; n < l; ++n) {
            p.lineTo(this.screenXd(ax[n]), this.screenYd(az[n]));
        }
        p.lineTo(this.screenXd(ax[0]), this.screenYd(az[0]));
        this.g.setColor(this.color);
        this.g.draw(p);
    }

    public void drawBLineRel(double dbX, double dbY) {
        this.g.setColor(this.color);
        Line2D.Double l = new Line2D.Double(this.sX, this.sY, this.sX += dbX * this.baseSize, this.sY += dbY * this.baseSize);
        this.g.draw(l);
    }

    public void moveBRel(double dbX, double dbY) {
        this.sX += dbX * this.baseSize;
        this.sY += dbY * this.baseSize;
    }

    public void drawBCircle(double bR) {
        this.g.setColor(this.color);
        int r = (int)(bR * this.baseSize);
        Ellipse2D.Double e = new Ellipse2D.Double(this.sX - (double)r, this.sY - (double)r, 2 * r, 2 * r);
        this.g.draw(e);
    }

    public void drawBArc(double bR, int startAngle, int arcAngle) {
        this.g.setColor(this.color);
        int r = (int)(bR * this.baseSize);
        Arc2D.Double a = new Arc2D.Double(this.sX - (double)r, this.sY - (double)r, 2 * r, 2 * r, startAngle, arcAngle, 0);
        this.g.draw(a);
    }

    public void fillBPolygonRel(double[] ax, double[] ay, int l) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(this.sX + ax[0] * this.baseSize, this.sY + ay[0] * this.baseSize);
        for (int n = 1; n < l; ++n) {
            p.lineTo(this.sX + ax[n] * this.baseSize, this.sY + ay[n] * this.baseSize);
        }
        p.lineTo(this.sX + ax[0] * this.baseSize, this.sY + ay[0] * this.baseSize);
        this.g.setColor(this.color);
        this.g.fill(p);
    }

    public void drawBPolygonRel(double[] ax, double[] ay, int l) {
        Path2D.Double p = new Path2D.Double();
        p.moveTo(this.sX + ax[0] * this.baseSize, this.sY + ay[0] * this.baseSize);
        for (int n = 1; n < l; ++n) {
            p.lineTo(this.sX + ax[n] * this.baseSize, this.sY + ay[n] * this.baseSize);
        }
        p.lineTo(this.sX + ax[0] * this.baseSize, this.sY + ay[0] * this.baseSize);
        this.g.setColor(this.color);
        this.g.draw(p);
    }

    public void colorStd() {
        this.color = Color.black;
    }

    public void colorSel() {
        this.color = Color.blue;
    }

    public void colorDis() {
        this.color = Color.blue;
    }

    public void colorRef() {
        this.color = Color.red;
    }

    public void colorSect() {
        this.color = Color.red;
    }

    public void colorSectFill() {
        this.color = fillColor;
    }

    public void colorLoad() {
        this.color = Color.red;
    }

    public void colorLoadN() {
        this.color = Color.green;
    }

    public void colorLabel() {
        this.color = Color.green.darker();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void drawString(String str) {
        this.g.setColor(this.color);
        this.g.drawString(str, (float)this.sX, (float)this.sY);
    }

    public void zoom(double f) {
        int mX = this.getSize().width / 2;
        int mY = this.getSize().height / 2;
        this.oX -= (int)((double)(mX - this.oX) * f + (double)this.oX - (double)mX);
        this.oY -= (int)((double)(mY - this.oY) * f + (double)this.oY - (double)mY);
        this.fX *= f;
        this.fZ *= f;
    }

    public void pan(double dwX, double dwZ) {
        this.oX = (int)((double)this.oX + dwX * this.fX);
        this.oY = (int)((double)this.oY + dwZ * this.fZ);
    }

    public void pan(int dX, int dY) {
        this.oX += dX;
        this.oY += dY;
    }

    public void showAll() {
        double z2;
        double x2;
        Iterator<Node> nodeIterator = this.model.getNodeIterator().iterator();
        if (!nodeIterator.hasNext()) {
            return;
        }
        Node node = nodeIterator.next();
        double x1 = x2 = node.getX();
        double z1 = z2 = node.getZ();
        while (nodeIterator.hasNext()) {
            node = nodeIterator.next();
            if (node.getX() < x1) {
                x1 = node.getX();
            }
            if (node.getX() > x2) {
                x2 = node.getX();
            }
            if (node.getZ() < z1) {
                z1 = node.getZ();
            }
            if (!(node.getZ() > z2)) continue;
            z2 = node.getZ();
        }
        x1 -= (x2 - x1) * 0.1;
        x2 += (x2 - x1) * 0.1;
        z1 -= (z2 - z1) * 0.1;
        z2 += (z2 - z1) * 0.1;
        this.zoomWindow(x1, z1, x2, z2);
    }

    public void zoomWindow(double x1, double z1, double x2, double z2) {
        int swX = this.getSize().width;
        int swY = this.getSize().height;
        this.fX = Math.abs((double)swX / (x2 - x1));
        this.fZ = Math.abs((double)swY / (z2 - z1));
        this.fZ = this.fX = Math.min(this.fX, this.fZ);
        this.oX = (int)((double)this.oX + ((double)(swX / 2) - ((x1 + x2) * 0.5 * this.fX + (double)this.oX)));
        this.oY = (int)((double)this.oY + ((double)(swY / 2) - ((z1 + z2) * 0.5 * this.fZ + (double)this.oY)));
    }

    public double getGrid() {
        return this.grid;
    }

    public void setGrid(double grid) {
        this.grid = grid;
    }

    public double getBaseSize() {
        return this.baseSize;
    }

    public void setBaseSize(double baseSize) {
        this.baseSize = baseSize;
    }

    public void setShowDisplacement(boolean showDisplacement) {
        this.showDisplacement = showDisplacement;
    }

    public double getDisplacementScale() {
        return this.displacementScale;
    }

    public void setDisplacementScale(double displacementScale) {
        this.displacementScale = displacementScale;
    }

    public void setShowShearForce(boolean showShearForce) {
        this.showShearForce = showShearForce;
    }

    public double getShearForceScale() {
        return this.shearForceScale;
    }

    public void setShearForceScale(double shearForceScale) {
        this.shearForceScale = shearForceScale;
    }

    public void setShowNormalForce(boolean showNormalForce) {
        this.showNormalForce = showNormalForce;
    }

    public double getNormalForceScale() {
        return this.normalForceScale;
    }

    public void setNormalForceScale(double normalForceScale) {
        this.normalForceScale = normalForceScale;
    }

    public void setShowMoment(boolean showMoment) {
        this.showMoment = showMoment;
    }

    public double getMomentScale() {
        return this.momentScale;
    }

    public void setMomentScale(double momentScale) {
        this.momentScale = momentScale;
    }

    static {
        rhStandard.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        rhPure = (RenderingHints)rhStandard.clone();
        rhPure.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        rhStandard.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE));
        fillColor = new Color(1.0f, 1.0f, 0.0f, 0.5f);
    }

    class RubberBand
    extends MouseMotionAdapter {
        int baseX;
        int baseY;
        int oldX;
        int oldY;
        JComponent component;
        boolean snap;
        boolean rect;

        RubberBand(int baseX, int baseY, JComponent component, boolean snap, boolean rect) {
            this.baseX = this.oldX = baseX;
            this.baseY = this.oldY = baseY;
            this.component = component;
            this.snap = snap;
            this.rect = rect;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Graphics2D g = (Graphics2D)this.component.getGraphics();
            g.setRenderingHints(rhStandard);
            g.setColor(Color.red);
            g.setXORMode(this.component.getBackground());
            if (!this.rect) {
                g.drawLine(this.baseX, this.baseY, this.oldX, this.oldY);
            } else {
                g.drawRect(Math.min(this.baseX, this.oldX), Math.min(this.baseY, this.oldY), Math.abs(this.oldX - this.baseX), Math.abs(this.oldY - this.baseY));
            }
            if (this.snap) {
                this.oldX = View.this.screenX(View.this.controller.snap(View.this.worldX(event.getX())));
                this.oldY = View.this.screenY(View.this.controller.snap(View.this.worldZ(event.getY())));
            } else {
                this.oldX = event.getX();
                this.oldY = event.getY();
            }
            if (!this.rect) {
                g.drawLine(this.baseX, this.baseY, this.oldX, this.oldY);
            } else {
                g.drawRect(Math.min(this.baseX, this.oldX), Math.min(this.baseY, this.oldY), Math.abs(this.oldX - this.baseX), Math.abs(this.oldY - this.baseY));
            }
        }
    }
}

