/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.math;

import com.schwebke.math.PMatrix;

public class Eigen {
    public static double delta = 2.220446049250313E-16;
    public static double eps = 1.0E-8;

    public static double[][] cyclJac(double[][] A) {
        int n = A.length;
        if (n != A[0].length) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        double[][] V = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V[i][j] = 0.0;
            }
            V[i][i] = 1.0;
        }
        double sum = 1.0;
        block2: while (true) {
            double prevSum = sum;
            sum = 0.0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j <= i - 1; ++j) {
                    sum += A[i][j] * A[i][j];
                }
            }
            if (2.0 * sum < eps * eps || Math.abs(prevSum - sum) < 0.1 * eps) {
                return V;
            }
            int p = 0;
            while (true) {
                if (p >= n - 1) continue block2;
                for (int q = p + 1; q < n; ++q) {
                    double h;
                    double g;
                    if (!(Math.abs(A[q][p]) >= eps)) continue;
                    double Theta = (A[q][q] - A[p][p]) / (2.0 * A[q][p]);
                    double t = 1.0;
                    if (Math.abs(Theta) > delta) {
                        t = 1.0 / (Theta + Math.signum(Theta) * Math.sqrt(Theta * Theta + 1.0));
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = c * t;
                    double r = s / (1.0 + c);
                    double tAqp = t * A[q][p];
                    double[] dArray = A[p];
                    int n2 = p;
                    dArray[n2] = dArray[n2] - tAqp;
                    double[] dArray2 = A[q];
                    int n3 = q;
                    dArray2[n3] = dArray2[n3] + tAqp;
                    A[q][p] = 0.0;
                    int j = 0;
                    while (j <= p - 1) {
                        g = A[q][j] + r * A[p][j];
                        h = A[p][j] - r * A[q][j];
                        double[] dArray3 = A[p];
                        int n4 = j;
                        dArray3[n4] = dArray3[n4] - s * g;
                        double[] dArray4 = A[q];
                        int n5 = j++;
                        dArray4[n5] = dArray4[n5] + s * h;
                    }
                    int i = p + 1;
                    while (i <= q - 1) {
                        g = A[q][i] + r * A[i][p];
                        h = A[i][p] - r * A[q][i];
                        double[] dArray5 = A[i];
                        int n6 = p;
                        dArray5[n6] = dArray5[n6] - s * g;
                        double[] dArray6 = A[q];
                        int n7 = i++;
                        dArray6[n7] = dArray6[n7] + s * h;
                    }
                    for (i = q + 1; i < n; ++i) {
                        g = A[i][q] + r * A[i][p];
                        h = A[i][p] - r * A[i][q];
                        double[] dArray7 = A[i];
                        int n8 = p;
                        dArray7[n8] = dArray7[n8] - s * g;
                        double[] dArray8 = A[i];
                        int n9 = q;
                        dArray8[n9] = dArray8[n9] + s * h;
                    }
                    for (i = 0; i < n; ++i) {
                        g = V[i][q] + r * V[i][p];
                        h = V[i][p] - r * V[i][q];
                        double[] dArray9 = V[i];
                        int n10 = p;
                        dArray9[n10] = dArray9[n10] - s * g;
                        double[] dArray10 = V[i];
                        int n11 = q;
                        dArray10[n11] = dArray10[n11] + s * h;
                    }
                }
                ++p;
            }
            break;
        }
    }

    public static double[][] cyclJac(PMatrix A) {
        int n = A.getRows();
        if (n != A.getCols()) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        double[][] V = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                V[i][j] = 0.0;
            }
            V[i][i] = 1.0;
        }
        double sum = 1.0;
        block2: while (true) {
            double prevSum = sum;
            sum = 0.0;
            for (int i = 0; i < n; ++i) {
                int endIndex = Math.min(i, A.getMaxCol(i));
                for (int j = A.getMinCol(i); j < endIndex; ++j) {
                    double Aij = A.get(i, j);
                    sum += Aij * Aij;
                }
            }
            if (2.0 * sum < eps * eps || Math.abs(prevSum - sum) < 0.1 * eps) {
                return V;
            }
            int p = 0;
            while (true) {
                if (p >= n - 1) continue block2;
                int startIndex = Math.max(p + 1, A.getMinCol(p));
                int endIndex = A.getMaxCol(p);
                for (int q = startIndex; q < endIndex; ++q) {
                    int i;
                    double h;
                    double g;
                    if (!(Math.abs(A.get(q, p)) >= eps)) continue;
                    double Theta = (A.get(q, q) - A.get(p, p)) / (2.0 * A.get(q, p));
                    double t = 1.0;
                    if (Math.abs(Theta) > delta) {
                        t = 1.0 / (Theta + Math.signum(Theta) * Math.sqrt(Theta * Theta + 1.0));
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = c * t;
                    double r = s / (1.0 + c);
                    double tAqp = t * A.get(q, p);
                    A.add(p, p, -tAqp);
                    A.add(q, q, tAqp);
                    A.set(q, p, 0.0);
                    for (int j = 0; j <= p - 1; ++j) {
                        g = A.get(q, j) + r * A.get(p, j);
                        h = A.get(p, j) - r * A.get(q, j);
                        A.add(p, j, -s * g);
                        A.add(q, j, s * h);
                    }
                    for (i = p + 1; i <= q - 1; ++i) {
                        g = A.get(q, i) + r * A.get(i, p);
                        h = A.get(i, p) - r * A.get(q, i);
                        A.add(i, p, -s * g);
                        A.add(q, i, s * h);
                    }
                    for (i = q + 1; i < n; ++i) {
                        g = A.get(i, q) + r * A.get(i, p);
                        h = A.get(i, p) - r * A.get(i, q);
                        A.add(i, p, -s * g);
                        A.add(i, q, s * h);
                    }
                    for (i = 0; i < n; ++i) {
                        g = V[i][q] + r * V[i][p];
                        h = V[i][p] - r * V[i][q];
                        double[] dArray = V[i];
                        int n2 = p;
                        dArray[n2] = dArray[n2] - s * g;
                        double[] dArray2 = V[i];
                        int n3 = q;
                        dArray2[n3] = dArray2[n3] + s * h;
                    }
                }
                ++p;
            }
            break;
        }
    }
}

