/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.math;

import java.io.Serializable;

public class MVector
implements Serializable {
    public double x;
    public double y;
    public double z;

    public MVector() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public MVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public static MVector add(MVector a, MVector b) {
        return new MVector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static MVector sub(MVector a, MVector b) {
        return new MVector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static MVector cross(MVector a, MVector b) {
        return new MVector(a.y * b.z - a.z * b.y, a.z * b.x - a.x * b.z, a.x * b.y - a.y * b.x);
    }

    public static MVector multiply(MVector a, double s) {
        return new MVector(a.x * s, a.y * s, a.z * s);
    }

    public static MVector multiply(double s, MVector a) {
        return new MVector(a.x * s, a.y * s, a.z * s);
    }

    public static double dot(MVector a, MVector b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static double abs(MVector a) {
        return Math.sqrt(a.x * a.x + a.y * a.y + a.z * a.z);
    }
}

