/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.math;

public class PMatrix {
    protected int rows;
    protected int cols;
    protected int[] minCol;
    protected int[] maxCol;
    protected int[] minRow;
    protected int[] maxRow;
    protected double[][] m;

    public PMatrix(int rows, int cols) {
        int i;
        this.rows = rows;
        this.cols = cols;
        this.minCol = new int[rows];
        this.maxCol = new int[rows];
        this.minRow = new int[cols];
        this.maxRow = new int[cols];
        this.m = new double[rows][];
        for (i = 0; i < rows; ++i) {
            this.m[i] = null;
            this.minCol[i] = 0;
            this.maxCol[i] = 0;
        }
        for (i = 0; i < cols; ++i) {
            this.minRow[i] = -1;
            this.maxRow[i] = -1;
        }
    }

    public static PMatrix duplicate(PMatrix A) {
        int i;
        PMatrix M = new PMatrix(A.rows, A.cols);
        for (i = 0; i < M.rows; ++i) {
            M.minCol[i] = A.minCol[i];
            M.maxCol[i] = A.maxCol[i];
            if (A.m[i] == null) continue;
            M.m[i] = new double[M.maxCol[i] - M.minCol[i]];
            for (int j = 0; j < M.m.length; ++j) {
                M.m[i][j] = A.m[i][j];
            }
        }
        for (i = 0; i < M.cols; ++i) {
            M.minRow[i] = A.minRow[i];
            M.minCol[i] = A.minCol[i];
        }
        return M;
    }

    public void set(int row, int col, double v) {
        int i;
        this.check(row, col);
        if (this.m[row] == null) {
            this.m[row] = new double[1];
            this.minCol[row] = col;
            this.maxCol[row] = col + 1;
            this.m[row][0] = v;
            return;
        }
        if (col >= this.minCol[row] && col < this.maxCol[row]) {
            this.m[row][col - this.minCol[row]] = v;
            return;
        }
        int minNew = Math.min(this.minCol[row], col);
        int maxNew = Math.max(this.maxCol[row], col + 1);
        double[] mNew = new double[maxNew - minNew];
        for (i = 0; i < maxNew - minNew; ++i) {
            mNew[i] = 0.0;
        }
        for (i = this.minCol[row] - minNew; i < this.maxCol[row] - minNew; ++i) {
            mNew[i] = this.m[row][i - this.minCol[row] + minNew];
        }
        this.m[row] = mNew;
        this.minCol[row] = minNew;
        this.maxCol[row] = maxNew;
        this.m[row][col - minNew] = v;
    }

    public double get(int row, int col) {
        this.check(row, col);
        if (this.m[row] == null) {
            return 0.0;
        }
        if (this.minCol[row] <= col && col < this.maxCol[row]) {
            return this.m[row][col - this.minCol[row]];
        }
        return 0.0;
    }

    public void add(int row, int col, double v) {
        this.set(row, col, this.get(row, col) + v);
    }

    public void setUnchecked(int row, int col, double v) {
        this.m[row][col - this.minCol[row]] = v;
    }

    public double getUnchecked(int row, int col) {
        return this.m[row][col - this.minCol[row]];
    }

    public boolean exist(int row, int col) {
        this.check(row, col);
        return this.m[row] != null && col >= this.minCol[row] && col < this.maxCol[row];
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public boolean existRow(int row) {
        return this.m[row] != null;
    }

    public int getMinCol(int row) {
        return this.minCol[row];
    }

    public int getMaxCol(int row) {
        return this.maxCol[row];
    }

    public int getMinRow(int col) {
        return this.minRow[col];
    }

    public int getMaxRow(int col) {
        return this.maxRow[col];
    }

    public void updateRowBounds() {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = this.minCol[row]; col < this.maxCol[row]; ++col) {
                if (this.getUnchecked(row, col) == 0.0) continue;
                this.minRow[col] = Math.min(this.minRow[col], row);
                this.maxRow[col] = Math.max(this.maxRow[col], row + 1);
            }
        }
    }

    public static double[] multiply(PMatrix A, double[] b) {
        int n = A.getCols();
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            double sum = 0.0;
            for (int j = A.getMinCol(i); j < A.getMaxCol(i); ++j) {
                sum += A.getUnchecked(i, j) * b[j];
            }
            r[i] = sum;
        }
        return r;
    }

    protected void check(int row, int col) {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("PMatrix: row index underflow");
        }
        if (row >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("PMatrix: row index overflow");
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("PMatrix: col index underflow");
        }
        if (col >= this.cols) {
            throw new ArrayIndexOutOfBoundsException("PMatrix: col index overflow");
        }
    }
}

