/*
 * Decompiled with CFR 0.152.
 */
package com.schwebke.math;

import com.schwebke.math.PMatrix;

public class Solver {
    public static double eps = 1.0E-10;
    public static int itmax = 500;

    public static void gauss(double[][] A, double[] b) {
        int n = A.length;
        if (n != A[0].length) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        int[] t = new int[n];
        for (int k = 0; k < n; ++k) {
            t[k] = k;
        }
        Solver.gaussDecomp(A, t);
        Solver.permuteGauss(b, t);
        Solver.gaussSubst(A, b, t);
    }

    public static void gaussDecomp(double[][] A, int[] t) {
        int n = A.length;
        if (n != A[0].length) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        for (int k = 0; k < n - 1; ++k) {
            int i;
            int pk = 0;
            double max = 0.0;
            for (i = k; i < n; ++i) {
                int ti = t[i];
                double s = 0.0;
                for (int j = k; j < n; ++j) {
                    s += Math.abs(A[ti][j]);
                }
                double q = Math.abs(A[ti][k]) / s;
                if (!(q > max)) continue;
                max = q;
                pk = i;
            }
            if (max < eps) {
                throw new IllegalArgumentException("singular matrix");
            }
            i = t[k];
            t[k] = t[pk];
            t[pk] = i;
            int tk = t[k];
            for (i = k + 1; i < n; ++i) {
                int ti = t[i];
                double[] dArray = A[ti];
                int n2 = k;
                dArray[n2] = dArray[n2] / A[tk][k];
                for (int j = k + 1; j < n; ++j) {
                    double[] dArray2 = A[ti];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] - A[ti][k] * A[tk][j];
                }
            }
        }
    }

    public static void permuteGauss(double[] b, int[] t) {
        int k;
        int n = b.length;
        double[] tmpB = new double[n];
        for (k = 0; k < n; ++k) {
            tmpB[k] = b[k];
        }
        for (k = 0; k < n; ++k) {
            b[k] = tmpB[t[k]];
        }
    }

    public static void gaussSubst(double[][] A, double[] b, int[] t) {
        int i;
        int tk;
        int k;
        int n = A.length;
        for (k = 1; k < n; ++k) {
            tk = t[k];
            for (i = 0; i <= k - 1; ++i) {
                int n2 = k;
                b[n2] = b[n2] - A[tk][i] * b[i];
            }
        }
        for (k = n - 1; k >= 0; --k) {
            tk = t[k];
            for (i = k + 1; i < n; ++i) {
                int n3 = k;
                b[n3] = b[n3] - A[tk][i] * b[i];
            }
            int n4 = k;
            b[n4] = b[n4] / A[tk][k];
        }
    }

    public static void cholesky(double[][] A, double[] b) {
        int i;
        int k;
        int n = A.length;
        if (n != A[0].length) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        for (k = 0; k < n; ++k) {
            int j;
            for (j = 0; j < k; ++j) {
                double[] dArray = A[k];
                int n2 = k;
                dArray[n2] = dArray[n2] - A[k][j] * A[k][j];
            }
            A[k][k] = Math.sqrt(A[k][k]);
            for (int i2 = k + 1; i2 < n; ++i2) {
                for (j = 0; j < k; ++j) {
                    double[] dArray = A[i2];
                    int n3 = k;
                    dArray[n3] = dArray[n3] - A[i2][j] * A[k][j];
                }
                double[] dArray = A[i2];
                int n4 = k;
                dArray[n4] = dArray[n4] / A[k][k];
            }
        }
        for (k = 0; k < n; ++k) {
            for (i = 0; i < k; ++i) {
                int n5 = k;
                b[n5] = b[n5] - b[i] * A[k][i];
            }
            int n6 = k;
            b[n6] = b[n6] / A[k][k];
        }
        for (k = n - 1; k >= 0; --k) {
            for (i = k + 1; i < n; ++i) {
                int n7 = k;
                b[n7] = b[n7] - A[i][k] * b[i];
            }
            int n8 = k;
            b[n8] = b[n8] / A[k][k];
        }
    }

    public static void gaussSeidel(double[][] A, double[] b, double[] x) {
        int n = A.length;
        if (n != A[0].length) {
            throw new IllegalArgumentException("cannot solve for non-square matrix");
        }
        for (int iteration = 1; iteration <= itmax; ++iteration) {
            double r = 0.0;
            for (int i = 0; i < n; ++i) {
                double sum = 0.0;
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    sum += A[i][j] * x[j];
                }
                double xn = -1.0 / A[i][i] * (sum -= b[i]);
                r += (x[i] - xn) * (x[i] - xn);
                x[i] = xn;
            }
            if (!(r < eps * eps)) continue;
            return;
        }
    }

    public static void factorizeCholesky(PMatrix A) {
        int n = A.getRows();
        if (A.getCols() != n) {
            throw new IllegalArgumentException("factorizeCholesky: attempt to decomp. non-square matrix");
        }
        for (int k = 0; k < n; ++k) {
            double Akk = A.getUnchecked(k, k);
            for (int j = A.getMinCol(k); j < k; ++j) {
                double Akj = A.getUnchecked(k, j);
                Akk -= Akj * Akj;
            }
            if (Akk < 1.0E-15) {
                System.out.println("warning: singular matrix");
            }
            Akk = Math.sqrt(Akk);
            A.setUnchecked(k, k, Akk);
            for (int i = k + 1; i < n; ++i) {
                int startIdx = Math.max(A.getMinCol(i), A.getMinCol(k));
                int endIdx = Math.min(Math.min(A.getMaxCol(i), A.getMaxCol(k)), k);
                for (int j = startIdx; j < endIdx; ++j) {
                    double Aik = A.getUnchecked(i, k);
                    A.setUnchecked(i, k, Aik -= A.getUnchecked(i, j) * A.getUnchecked(k, j));
                }
                if (!A.exist(i, k)) continue;
                double Aik = A.getUnchecked(i, k);
                A.setUnchecked(i, k, Aik /= Akk);
            }
        }
        A.updateRowBounds();
    }

    public static void substCholesky(PMatrix A, double[] b) {
        int i;
        int k;
        int n = A.getRows();
        for (k = 0; k < n; ++k) {
            for (i = A.getMinCol(k); i < k; ++i) {
                int n2 = k;
                b[n2] = b[n2] - b[i] * A.getUnchecked(k, i);
            }
            int n3 = k;
            b[n3] = b[n3] / A.getUnchecked(k, k);
        }
        for (k = n - 1; k >= 0; --k) {
            for (i = k + 1; i < A.getMaxRow(k); ++i) {
                int n4 = k;
                b[n4] = b[n4] - A.get(i, k) * b[i];
            }
            int n5 = k;
            b[n5] = b[n5] / A.getUnchecked(k, k);
        }
    }

    public static void linsolveCholesky(PMatrix A, double[] b) {
        Solver.factorizeCholesky(A);
        Solver.substCholesky(A, b);
    }
}

