/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.config.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.view.ConfigurationPanel;
import jgpstrackedit.international.International;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.util.MapExtractManager;

public class MapsPanel
extends JPanel
implements ConfigurationPanel {
    private JCheckBox chckbxShowMapOn;
    private JButton btnClearMemoryTile;
    private JTextField textFieldMaxTiles;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton rdbtnCountrySpecificMap;
    private JRadioButton rdbtnMapExtract;
    private JComboBox comboBoxMapExtract;
    private JRadioButton rdbtnLastMapExtract;

    public MapsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.chckbxShowMapOn = new JCheckBox(International.getText("dlgconfig.Show_map_on_startup"));
        this.chckbxShowMapOn.setBounds(7, 7, 255, 23);
        this.chckbxShowMapOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapsPanel.this.setDisplay(MapsPanel.this.chckbxShowMapOn.isSelected());
            }
        });
        this.setLayout(null);
        this.add(this.chckbxShowMapOn);
        this.btnClearMemoryTile = new JButton(International.getText("dlgconfig.Clear_memory_tile_cache"));
        this.btnClearMemoryTile.setBounds(7, 115, 210, 23);
        this.btnClearMemoryTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TileManager.getCurrentTileManager().initializeTileCacheStructure();
            }
        });
        this.add(this.btnClearMemoryTile);
        this.textFieldMaxTiles = new JTextField();
        this.textFieldMaxTiles.setBounds(289, 142, 86, 20);
        this.add(this.textFieldMaxTiles);
        this.textFieldMaxTiles.setColumns(10);
        JLabel lblMaxNumberOf = new JLabel(String.valueOf(International.getText("dlgconfig.Max_number_of_tiles_in_memory")) + ":");
        lblMaxNumberOf.setBounds(7, 145, 255, 14);
        this.add(lblMaxNumberOf);
        this.rdbtnCountrySpecificMap = new JRadioButton(International.getText("dlgconfig.Country_specific_map_extract"));
        this.rdbtnCountrySpecificMap.setBounds(33, 33, 398, 23);
        this.rdbtnCountrySpecificMap.setSelected(true);
        this.add(this.rdbtnCountrySpecificMap);
        this.rdbtnMapExtract = new JRadioButton(International.getText("dlgconfig.Map_extract"));
        this.rdbtnMapExtract.setBounds(33, 59, 184, 23);
        this.add(this.rdbtnMapExtract);
        this.rdbtnLastMapExtract = new JRadioButton(International.getText("dlgconfig.Last_map_extract"));
        this.rdbtnLastMapExtract.setBounds(33, 85, 210, 23);
        this.add(this.rdbtnLastMapExtract);
        this.comboBoxMapExtract = new JComboBox<String>(MapExtractManager.mapExtractNames());
        this.comboBoxMapExtract.setBounds(227, 63, 208, 20);
        this.add(this.comboBoxMapExtract);
        this.buttonGroup.add(this.rdbtnCountrySpecificMap);
        this.buttonGroup.add(this.rdbtnMapExtract);
        this.buttonGroup.add(this.rdbtnLastMapExtract);
    }

    protected void setDisplay(boolean selected) {
        this.rdbtnCountrySpecificMap.setEnabled(selected);
        this.rdbtnMapExtract.setEnabled(selected);
        this.rdbtnLastMapExtract.setEnabled(selected);
        this.comboBoxMapExtract.setEnabled(selected);
    }

    @Override
    public String getTabName() {
        return International.getText("dlgconfig.Maps");
    }

    @Override
    public void initialize() {
        this.chckbxShowMapOn.setSelected(Configuration.getBooleanProperty("SHOW_MAP_ON_STARTUP"));
        this.rdbtnCountrySpecificMap.setSelected(Configuration.getBooleanProperty("COUNTRY_SPECIFIC_MAP"));
        this.rdbtnLastMapExtract.setSelected(Configuration.getBooleanProperty("LAST_MAP_EXTRACT"));
        this.comboBoxMapExtract.setSelectedItem(Configuration.getProperty("MAPEXTRACT"));
        this.textFieldMaxTiles.setText("" + Configuration.getIntProperty("MAX_TILES_IN_MEMORY"));
        this.setDisplay(this.chckbxShowMapOn.isSelected());
    }

    @Override
    public void save() {
        Configuration.setProperty("SHOW_MAP_ON_STARTUP", this.chckbxShowMapOn.isSelected() ? "1" : "0");
        Configuration.setProperty("COUNTRY_SPECIFIC_MAP", this.rdbtnCountrySpecificMap.isSelected() ? "1" : "0");
        Configuration.setProperty("MAPEXTRACT", this.comboBoxMapExtract.getSelectedItem().toString());
        Configuration.setProperty("MAX_TILES_IN_MEMORY", this.textFieldMaxTiles.getText());
        Configuration.setProperty("LAST_MAP_EXTRACT", this.rdbtnLastMapExtract.isSelected() ? "1" : "0");
    }

    @Override
    public void cancel() {
    }
}

