/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data.util;

import jgpstrackedit.data.Point;

public class Geometry {
    private static final double EARTH_RADIUS_KM = 6372.795;

    public static double distanceLineToPoint(Point g1, Point g2, Point point) {
        double k = (g2.getLatitude() - g1.getLatitude()) / (g2.getLongitude() - g1.getLongitude());
        double d = g2.getLatitude() - k * g2.getLongitude();
        double kn = -1.0 / k;
        double dn = point.getLatitude() - kn * point.getLongitude();
        double sx = (dn - d) / (k - kn);
        double sy = k * sx + d;
        return Geometry.distance(new Point(sx, sy, point.getElevation()), point) * 1000.0;
    }

    public static double calculateRadiansBetween(Point inPoint1, Point inPoint2) {
        if (inPoint1 == null || inPoint2 == null) {
            return 0.0;
        }
        double TO_RADIANS = Math.PI / 180;
        double lat1 = inPoint1.getLatitude() * (Math.PI / 180);
        double lat2 = inPoint2.getLatitude() * (Math.PI / 180);
        double lon1 = inPoint1.getLongitude() * (Math.PI / 180);
        double lon2 = inPoint2.getLongitude() * (Math.PI / 180);
        double firstSine = Math.sin((lat2 - lat1) / 2.0);
        double secondSine = Math.sin((lon2 - lon1) / 2.0);
        double term2 = Math.cos(lat1) * Math.cos(lat2) * secondSine * secondSine;
        double answer = 2.0 * Math.asin(Math.sqrt(firstSine * firstSine + term2));
        return answer;
    }

    public static double distance(Point firstPoint, Point secondPoint) {
        double radDist = Geometry.calculateRadiansBetween(firstPoint, secondPoint);
        double dist = radDist * (6372.795 + (firstPoint.getElevation() + secondPoint.getElevation()) / 2000.0);
        return dist;
    }
}

