/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tiledownload;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jgpstrackedit.map.tiledownload.CopyErrorObserver;
import jgpstrackedit.map.tilehandler.AbstractDiskTileCommand;
import jgpstrackedit.map.util.TileNumber;

public class TileCopyCommand
extends AbstractDiskTileCommand {
    private String sourceFile;
    private String destinationFile;
    private TileNumber tileNumber;
    private CopyErrorObserver copyErrorObserver;

    @Override
    public void setTileNumber(TileNumber tileNumber) {
        this.tileNumber = tileNumber;
    }

    @Override
    public TileNumber getTileNumber() {
        return this.tileNumber;
    }

    public void setCopyErrorObserver(CopyErrorObserver copyErrorObserver) {
        this.copyErrorObserver = copyErrorObserver;
    }

    public TileCopyCommand(String sourceFile, String destinationFile, TileNumber tileNumber, CopyErrorObserver observer) {
        this.setSourceFile(sourceFile);
        this.setDestinationFile(destinationFile);
        this.setTileNumber(tileNumber);
        this.setCopyErrorObserver(observer);
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getDestinationFile() {
        return this.destinationFile;
    }

    public void setDestinationFile(String destinationFile) {
        this.destinationFile = destinationFile;
    }

    @Override
    public void doAction() {
        try {
            System.out.println("CopyCommand: " + this.getSourceFile() + " -> " + this.getDestinationFile());
            Thread.yield();
            TileCopyCommand.copy(this.getSourceFile(), this.getDestinationFile());
        }
        catch (FileNotFoundException e) {
            this.copyErrorObserver.errorOccured(this.getTileNumber());
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copy(String source, String dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        int b = in.read();
        while (b != -1) {
            out.write((byte)b);
            b = in.read();
        }
        in.close();
        out.close();
    }
}

