/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.tiledownload;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.map.tiledownload.TileCopyHandler;
import jgpstrackedit.map.tilehandler.QueueObserver;
import jgpstrackedit.map.util.TileBoundary;
import jgpstrackedit.map.util.TileNumber;

public class TileDownload {
    private TreeSet<TileNumber> downloadTiles = new TreeSet();
    private TreeSet<TileNumber> extensionDownloadTiles = new TreeSet();
    private int zoomLevel = 10;
    private TileCopyHandler tileCopyHandler = new TileCopyHandler();

    public TileDownload() {
        this.tileCopyHandler.start();
    }

    public void addCopyQueueObserver(QueueObserver observer) {
        this.tileCopyHandler.addQueueObserver(observer);
    }

    public void removeCopyQueueObserver(QueueObserver observer) {
        this.tileCopyHandler.removeQueueObserver(observer);
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    public TreeSet<TileNumber> getDownloadTiles() {
        return this.downloadTiles;
    }

    public TreeSet<TileNumber> getExtensionDownloadTiles() {
        return this.extensionDownloadTiles;
    }

    public TreeSet<TileNumber> getAllDownloadTiles() {
        TreeSet<TileNumber> all = new TreeSet<TileNumber>();
        all.addAll(this.downloadTiles);
        all.addAll(this.extensionDownloadTiles);
        return all;
    }

    public void addTile(TileNumber tileNumber) {
        this.downloadTiles.add(tileNumber);
    }

    public void addExtensionTile(int zoomLevel, double longitude, double latitude) {
        this.extensionDownloadTiles.add(TileNumber.getTileNumber(zoomLevel, longitude, latitude));
    }

    public void remove(TileNumber tileNumber) {
        this.downloadTiles.remove(tileNumber);
    }

    public void addTiles(int zoomlevel, Track track) {
        for (Point point : track.getPoints()) {
            this.downloadTiles.add(TileNumber.getTileNumber(zoomlevel, point.getLongitude(), point.getLatitude()));
        }
    }

    public void addTiles(Track track) {
        this.addTiles(this.getZoomLevel(), track);
    }

    public void addTiles(ArrayList<Track> tracks) {
        for (Track track : tracks) {
            this.addTiles(track);
        }
    }

    public void addTiles(Point upperLeftBoundary, Point lowerRightBoundary) {
        TileNumber upperLeftTile = TileNumber.getTileNumber(this.getZoomLevel(), upperLeftBoundary.getLongitude(), upperLeftBoundary.getLatitude());
        TileNumber lowerRightTile = TileNumber.getTileNumber(this.getZoomLevel(), lowerRightBoundary.getLongitude(), lowerRightBoundary.getLatitude());
        int x = upperLeftTile.getX();
        while (x <= lowerRightTile.getX()) {
            int y = upperLeftTile.getY();
            while (y <= lowerRightTile.getY()) {
                this.addTile(new TileNumber(this.getZoomLevel(), x, y));
                ++y;
            }
            ++x;
        }
    }

    public void addExtensionTiles(List list) {
        for (TileNumber tile : this.downloadTiles) {
            TileBoundary tb = TileBoundary.getTileBoundary(tile);
            for (Object o : list) {
                this.addExtensionTile((Integer)o, tb.getCenterLongitude(), tb.getCenterLatitude());
            }
        }
    }

    public void toggleTile(TileNumber tileNumber) {
        if (this.downloadTiles.contains(tileNumber)) {
            this.downloadTiles.remove(tileNumber);
        } else {
            this.addTile(tileNumber);
        }
    }

    public void appendBorderTiles() {
        TreeSet<TileNumber> borderTiles = new TreeSet<TileNumber>();
        for (TileNumber tile : this.downloadTiles) {
            int zoom = tile.getZoom();
            int x = tile.getX();
            int y = tile.getY();
            borderTiles.add(new TileNumber(zoom, x - 1, y - 1));
            borderTiles.add(new TileNumber(zoom, x, y - 1));
            borderTiles.add(new TileNumber(zoom, x + 1, y - 1));
            borderTiles.add(new TileNumber(zoom, x - 1, y));
            borderTiles.add(new TileNumber(zoom, x + 1, y));
            borderTiles.add(new TileNumber(zoom, x - 1, y + 1));
            borderTiles.add(new TileNumber(zoom, x, y + 1));
            borderTiles.add(new TileNumber(zoom, x + 1, y + 1));
        }
        this.downloadTiles.addAll(borderTiles);
    }

    public void saveToFile(String fileName) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))));
        out.println(this.getZoomLevel());
        for (TileNumber tile : this.downloadTiles) {
            out.println(tile.toString());
        }
        out.close();
    }

    public void loadFromFile(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        String zoomLevel = in.readLine();
        if (zoomLevel != null) {
            this.setZoomLevel(Integer.parseInt(zoomLevel));
        }
        String tileNumber = in.readLine();
        while (tileNumber != null) {
            String[] parts = tileNumber.split("/");
            this.downloadTiles.add(new TileNumber(Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), Integer.parseInt(parts[3])));
            tileNumber = in.readLine();
        }
        in.close();
    }
}

