/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.routing;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.util.TrackUtil;
import jgpstrackedit.routing.MapQuestRoutingHandlerImpl;
import jgpstrackedit.routing.MapQuestRoutingParser;
import org.xml.sax.SAXException;

public class MapQuestRouting {
    protected ArrayList<Point> loadRouteFromMapQuest(Point fromPoint, Point toPoint) {
        ArrayList<Point> points = null;
        MapQuestRoutingHandlerImpl handler = new MapQuestRoutingHandlerImpl();
        MapQuestRoutingParser parser = new MapQuestRoutingParser(handler, null);
        String urlString = "http://open.mapquestapi.com/directions/v0/route?outFormat=xml&routeType=" + Configuration.getProperty("ROUTINGTYPE") + "&timeType=1&enhancedNarrative=false&shapeFormat=raw&generalize=" + Configuration.getProperty("ROUTINGPOINTDISTANCE") + "&unit=k" + (Configuration.getBooleanProperty("ROUTINGAVOIDLIMITEDACCESS") ? "&avoids=Limited Access" : "") + (Configuration.getBooleanProperty("ROUTINGAVOIDTOLLROAD") ? "&avoids=Toll road" : "") + "&from=" + fromPoint.getLatitudeAsString() + "," + fromPoint.getLongitudeAsString() + "&to=" + toPoint.getLatitudeAsString() + "," + toPoint.getLongitudeAsString();
        System.out.println(urlString);
        try {
            URL url = new URL(urlString);
            parser.parse(url);
            points = handler.getPoints();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return points;
    }

    public ArrayList<Point> loadRoute(Point fromPoint, Point toPoint) {
        ArrayList<Point> points = this.loadRouteFromMapQuest(fromPoint, toPoint);
        if (points != null) {
            points.remove(0);
            TrackUtil.removeDoublePoints(points);
        }
        return points;
    }
}

