/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.util;

import java.util.Formatter;
import java.util.Locale;

public class Parser {
    public static int parseInt(String s) {
        if (s == null) {
            return 0;
        }
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s.trim());
    }

    public static double parseDouble(String s) {
        if (s == null) {
            return 0.0;
        }
        if (s.length() == 0) {
            return 0.0;
        }
        String sn = s.replace(',', '.');
        return Double.parseDouble(sn.trim());
    }

    public static double parseTime(String s) {
        if (s.length() == 0) {
            return 0.0;
        }
        String[] mttA = s.split(":");
        double time = Double.parseDouble(mttA[0].trim());
        if (mttA.length == 2) {
            time += Double.parseDouble(mttA[1].trim()) / 60.0;
        }
        if (mttA.length == 3) {
            time += Double.parseDouble(mttA[1].trim()) / 3600.0;
        }
        return time;
    }

    public static String formatTimeHHMM(double hoursDecimal) {
        int hour = (int)Math.floor(hoursDecimal);
        int min = (int)Math.floor((hoursDecimal - (double)hour) * 60.0);
        return hour + ":" + (min < 10 ? "0" : "") + min;
    }

    public static String trim_0(String s) {
        int dPoint = s.indexOf(46);
        if (s.length() - dPoint > 7) {
            s = s.substring(0, dPoint + 8);
        }
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String formatLongitude(double longitude) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%10.6f", longitude).toString().trim();
    }

    public static String formatLatitude(double latitude) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%9.6f", latitude).toString().trim();
    }

    public static String formatElevation(double elevation) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%9.5f", elevation).toString().trim();
    }

    public static String formatLength(double length) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%8.3f", length).toString().trim();
    }

    public static String formatAltProfile(double length) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%4.0f", length).toString().trim();
    }

    public static String formatLengthProfile(double length) {
        Formatter format = new Formatter(Locale.US);
        return format.format("%5.1f", length).toString().trim();
    }

    public static boolean equals0(double value) {
        return Math.abs(value) < 1.0E-7;
    }
}

