/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JPanel;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.util.Parser;

public class AltitudeProfilePanel
extends JPanel
implements TrackObserver {
    private Track track = null;
    private Point selectedPoint = null;
    private static final int ALT_WIDTH = 35;
    private static final int LENGTH_HEIGHT = 15;
    private static final int BORDER_HEIGHT = 14;

    public void setSelectedPoint(Point selectedPoint) {
        this.selectedPoint = selectedPoint;
        this.repaint();
    }

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        if (this.track != null) {
            this.track.removeTrackObserver(this);
        }
        this.track = track;
        this.track.addTrackObserver(this);
        this.repaint();
    }

    public AltitudeProfilePanel() {
        this.setPreferredSize(new Dimension(200, 100));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.track != null) {
            Graphics2D g2D = (Graphics2D)g;
            double trackLength = this.track.getLength();
            double maxElevation = this.track.getHighestElevation();
            double minElevation = this.track.getLowestElevation();
            double altitudeDifference = maxElevation - minElevation;
            double scaleUnit = this.altitudeScaleUnit(altitudeDifference);
            double scaleMinAltitude = this.calcScaleMinAltitude(minElevation, scaleUnit);
            double scaleMaxAltitude = this.calcScaleMaxAltitude(maxElevation, scaleUnit);
            double scaleAltitudeDifference = scaleMaxAltitude - scaleMinAltitude;
            double scaleUnitLength = this.lengthScaleUnit(trackLength);
            int width = this.getWidth() - 35;
            int height = this.getHeight() - 14 - 15;
            g2D.setColor(Color.WHITE);
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2D.setColor(Color.LIGHT_GRAY);
            double alt = scaleMinAltitude;
            while (alt < scaleMaxAltitude + scaleUnit) {
                g2D.drawLine(0, height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14, this.getWidth(), height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14);
                g2D.drawString(Parser.formatAltProfile(alt), 2, height - 1 - (int)((alt - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 12);
                alt += scaleUnit;
            }
            double length = 0.0;
            while (length < trackLength) {
                g2D.drawLine((int)(length / trackLength * (double)width) + 35, 0, (int)(length / trackLength * (double)width) + 35, this.getHeight() - 15);
                g2D.drawString(Parser.formatLengthProfile(length), (int)(length / trackLength * (double)width) + 35 - 4, this.getHeight() - 15 + 11);
                length += scaleUnitLength;
            }
            g2D.drawString("m/km", 1, this.getHeight() - 15 + 11);
            g2D.setColor(Color.BLACK);
            g2D.drawLine(35, 0, 35, this.getHeight() - 15);
            g2D.drawLine(35, this.getHeight() - 15, this.getWidth(), this.getHeight() - 15);
            g2D.setColor(Color.RED);
            ArrayList<Point> points = this.track.getPoints();
            Point firstPoint = this.track.getFirstPoint();
            double distance = 0.0;
            int i = 1;
            while (i < points.size()) {
                Point secondPoint = points.get(i);
                double delta = firstPoint.distance(secondPoint);
                g2D.drawLine((int)(distance / trackLength * (double)width) + 35, height - 1 - (int)((firstPoint.getElevation() - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14, (int)((distance + delta) / trackLength * (double)width + 35.0), height - 1 - (int)((secondPoint.getElevation() - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14);
                if (this.selectedPoint == firstPoint) {
                    g2D.setColor(Color.GREEN);
                    g2D.drawLine((int)(distance / trackLength * (double)width) + 35, this.getHeight() - 15, (int)(distance / trackLength * (double)width) + 35, height - 1 - (int)((firstPoint.getElevation() - scaleMinAltitude) / scaleAltitudeDifference * (double)height) + 14);
                    g2D.setColor(Color.RED);
                }
                distance += delta;
                firstPoint = secondPoint;
                ++i;
            }
        }
    }

    @Override
    public void trackModified(Track track) {
        if (this.track.equals(track)) {
            this.repaint();
        }
    }

    public double altitudeScaleUnit(double altitudeDifference) {
        double[] scaleUnits = new double[]{1.0, 2.5, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0};
        int i = 0;
        while (i < scaleUnits.length) {
            if (4.0 * scaleUnits[i] > altitudeDifference) {
                return scaleUnits[i];
            }
            ++i;
        }
        return 1000.0;
    }

    public double lengthScaleUnit(double length) {
        double[] scaleUnits = new double[]{0.1, 0.2, 0.5, 1.0, 2.5, 5.0, 10.0, 25.0, 50.0, 100.0, 250.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0};
        int i = 0;
        while (i < scaleUnits.length) {
            if (7.0 * scaleUnits[i] > length) {
                return scaleUnits[i];
            }
            ++i;
        }
        return 5000.0;
    }

    public double calcScaleMinAltitude(double minAltitude, double scaleUnit) {
        return Math.floor(minAltitude / scaleUnit) * scaleUnit;
    }

    public double calcScaleMaxAltitude(double maxAltitude, double scaleUnit) {
        return Math.ceil(maxAltitude / scaleUnit) * scaleUnit;
    }
}

