/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.util.TourPlaner;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.util.MapExtract;
import jgpstrackedit.map.util.MapObserver;
import jgpstrackedit.util.Parser;
import jgpstrackedit.view.PointView;
import jgpstrackedit.view.TrackView;
import jgpstrackedit.view.TracksView;
import jgpstrackedit.view.Transform;
import jgpstrackedit.view.ZoomObserver;

public class TracksPanel
extends JPanel
implements ZoomObserver,
ComponentListener,
MapObserver,
Runnable {
    private TracksView tracksView;
    private boolean showDayTourMarkers = false;
    private boolean showBonds = false;
    private boolean showCoordinates = false;
    private boolean pointDeleteMode = false;
    private boolean showScale = true;
    private String cursorText = "";
    private Color cursorTextColor = Color.BLACK;
    private int mouseX;
    private int mouseY;
    private ArrayList<Point> bondPoints = new ArrayList();
    private boolean autoRefresh = true;
    private Point rectanglePoint = null;

    public boolean isShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean showScale) {
        this.showScale = showScale;
    }

    public Point getRectanglePoint() {
        return this.rectanglePoint;
    }

    public void setRectanglePoint(Point rectanglePoint) {
        this.rectanglePoint = rectanglePoint;
    }

    public String getCursorText() {
        return this.cursorText;
    }

    public void setCursorText(String cursorText, Color color) {
        this.cursorText = cursorText;
        this.cursorTextColor = color;
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        if (autoRefresh) {
            new Thread(this).start();
        }
    }

    public boolean isPointDeleteMode() {
        return this.pointDeleteMode;
    }

    public void setPointDeleteMode(boolean pointDeleteMode) {
        this.pointDeleteMode = pointDeleteMode;
        if (pointDeleteMode) {
            this.setCursorText("delete", Color.RED);
            this.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            this.setCursorText("", Color.RED);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void addBondPoint(Point bondPoint) {
        this.bondPoints.add(bondPoint);
    }

    public void removeBondPoint(Point bondPoint) {
        this.bondPoints.remove(bondPoint);
    }

    public void clearBondPoints() {
        this.bondPoints.clear();
    }

    public boolean isShowBonds() {
        return this.showBonds;
    }

    public void setShowBonds(boolean show) {
        this.showBonds = show;
    }

    public boolean isShowDayTourMarkers() {
        return this.showDayTourMarkers;
    }

    public void setShowDayTourMarkers(boolean showDayTourMarkers) {
        this.showDayTourMarkers = showDayTourMarkers;
    }

    public TracksPanel(TracksView tracksView) {
        this.setPreferredSize(new Dimension(100, 100));
        this.initComponents();
        this.tracksView = tracksView;
        tracksView.addZoomObserver(this);
        this.addComponentListener(this);
        new Thread(this).start();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        BasicStroke symbolStroke = new BasicStroke(1.0f);
        BasicStroke selectedLineStroke = new BasicStroke(Configuration.getIntProperty("SELECTED_LINE_WIDTH"));
        BasicStroke unselectedLineStroke = new BasicStroke(Configuration.getIntProperty("UNSELECTED_LINE_WIDTH"));
        TileManager tileManager = TileManager.getCurrentTileManager();
        if (tileManager != null) {
            tileManager.paintMap(g2D, Transform.getUpperLeftBoundary().getLongitude(), Transform.getUpperLeftBoundary().getLatitude(), Transform.getLowerRightBoundary().getLongitude(), Transform.getLowerRightBoundary().getLatitude(), this.getWidth(), this.getHeight());
        } else {
            g2D.setColor(Color.WHITE);
            g2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        for (TrackView trackView : this.tracksView.getTracksView()) {
            PointView end;
            if (trackView.isSelected()) {
                g2D.setStroke(selectedLineStroke);
            } else {
                g2D.setStroke(unselectedLineStroke);
            }
            Color trackColor = trackView.getColor();
            g2D.setColor(trackColor);
            PointView previousPoint = null;
            for (PointView point : trackView.getPoints()) {
                if (trackView.isSelected()) {
                    point.paint(g2D, point.getPoint() == trackView.getSelectedPoint());
                }
                if (!(previousPoint == null || previousPoint.isOutView() && point.isOutView())) {
                    g2D.drawLine(previousPoint.getX(), previousPoint.getY(), point.getX(), point.getY());
                }
                previousPoint = point;
            }
            g2D.setStroke(symbolStroke);
            if (!trackView.isSelected()) continue;
            PointView start = trackView.getFirstPoint();
            if (start != null) {
                start.paintStartMarker(g2D);
            }
            if ((end = trackView.getLastPoint()) == null) continue;
            end.paintEndMarker(g2D);
        }
        if (this.isShowDayTourMarkers()) {
            List<Point> markers = new TourPlaner(this.tracksView.getSelectedTrackView().getTrack()).dayTourMarkers();
            for (Point point : markers) {
                g2D.drawRect(Transform.screenX(point.getLongitude()) - 8, Transform.screenY(point.getLatitude()) - 8, 17, 17);
                g2D.drawLine(Transform.screenX(point.getLongitude()) - 35, Transform.screenY(point.getLatitude()), Transform.screenX(point.getLongitude()) + 35, Transform.screenY(point.getLatitude()));
                g2D.drawLine(Transform.screenX(point.getLongitude()), Transform.screenY(point.getLatitude()) - 35, Transform.screenX(point.getLongitude()), Transform.screenY(point.getLatitude()) + 35);
            }
        }
        for (Point point : this.bondPoints) {
            g2D.drawLine(this.mouseX, this.mouseY, Transform.screenX(point.getLongitude()), Transform.screenY(point.getLatitude()));
        }
        if (this.isShowBonds()) {
            g2D.drawLine(this.mouseX - 15, this.mouseY, this.mouseX + 15, this.mouseY);
            g2D.drawLine(this.mouseX, this.mouseY - 15, this.mouseX, this.mouseY + 15);
        }
        if (this.cursorText.length() > 0) {
            g2D.setColor(Color.WHITE);
            g2D.fillRect(this.mouseX + 12, this.mouseY + 4, this.cursorText.length() * 6, 13);
            g2D.setColor(this.cursorTextColor);
            g2D.drawString(this.cursorText, this.mouseX + 13, this.mouseY + 4 + 1 + 10);
        }
        if (this.isShowCoordinates()) {
            g2D.setColor(Color.WHITE);
            g2D.fillRect(this.mouseX + 4, this.mouseY - 2 - 11, 140, 13);
            g2D.setColor(Color.BLACK);
            g2D.drawString(Parser.trim_0("" + Transform.mapLongitude(this.mouseX)) + " " + Parser.trim_0("" + Transform.mapLatitude(this.mouseY)), this.mouseX + 5, this.mouseY - 2);
        }
        if (this.rectanglePoint != null) {
            int tx = Transform.screenX(this.rectanglePoint.getLongitude());
            int n = Transform.screenY(this.rectanglePoint.getLatitude());
            g2D.setColor(Color.BLACK);
            g2D.drawRect(tx, n, Math.abs(this.mouseX - tx), Math.abs(this.mouseY - n));
        }
        if (this.isShowScale() && tileManager != null) {
            tileManager.paintScale(g2D, 30, this.getHeight() - 30);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.tracksView.getLeftUpperBoundary() != null) {
            Transform.setNewScreenDimension(this.getWidth(), this.getHeight());
            this.tracksView.setView(Transform.getLowerRightBoundary(), Transform.getUpperLeftBoundary());
            this.repaint();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void modifiedZoom(Point leftUpperBoundary, Point rightLowerBoundary, boolean recalculateZoomLevel) {
        if (leftUpperBoundary != null) {
            Transform.setTransform(leftUpperBoundary, rightLowerBoundary, this.getWidth(), this.getHeight(), recalculateZoomLevel);
        }
        this.tracksView.setView(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
        this.repaint();
    }

    public void moveNorth() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double delta = (leftUpperBoundary.getLatitude() - rightLowerBoundary.getLatitude()) / 3.0;
        leftUpperBoundary.setLatitude(leftUpperBoundary.getLatitude() + delta);
        rightLowerBoundary.setLatitude(rightLowerBoundary.getLatitude() + delta);
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void moveSouth() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double delta = (leftUpperBoundary.getLatitude() - rightLowerBoundary.getLatitude()) / 3.0;
        leftUpperBoundary.setLatitude(leftUpperBoundary.getLatitude() - delta);
        rightLowerBoundary.setLatitude(rightLowerBoundary.getLatitude() - delta);
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void moveWest() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double delta = (rightLowerBoundary.getLongitude() - leftUpperBoundary.getLongitude()) / 3.0;
        leftUpperBoundary.setLongitude(leftUpperBoundary.getLongitude() - delta);
        rightLowerBoundary.setLongitude(rightLowerBoundary.getLongitude() - delta);
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void moveEast() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double delta = (rightLowerBoundary.getLongitude() - leftUpperBoundary.getLongitude()) / 3.0;
        leftUpperBoundary.setLongitude(leftUpperBoundary.getLongitude() + delta);
        rightLowerBoundary.setLongitude(rightLowerBoundary.getLongitude() + delta);
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void move(double xDeltaPercent, double yDeltaPercent) {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double deltaX = (rightLowerBoundary.getLongitude() - leftUpperBoundary.getLongitude()) * xDeltaPercent;
        double deltaY = (leftUpperBoundary.getLatitude() - rightLowerBoundary.getLatitude()) * yDeltaPercent;
        leftUpperBoundary.setLatitude(leftUpperBoundary.getLatitude() - deltaY);
        rightLowerBoundary.setLatitude(rightLowerBoundary.getLatitude() - deltaY);
        leftUpperBoundary.setLongitude(leftUpperBoundary.getLongitude() - deltaX);
        rightLowerBoundary.setLongitude(rightLowerBoundary.getLongitude() - deltaX);
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void zoomIn() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double width = rightLowerBoundary.getLongitude() - leftUpperBoundary.getLongitude();
        leftUpperBoundary.setLongitude(leftUpperBoundary.getLongitude() + width / 4.0);
        rightLowerBoundary.setLongitude(rightLowerBoundary.getLongitude() - width / 4.0);
        double height = leftUpperBoundary.getLatitude() - rightLowerBoundary.getLatitude();
        leftUpperBoundary.setLatitude(leftUpperBoundary.getLatitude() - height / 4.0);
        rightLowerBoundary.setLatitude(rightLowerBoundary.getLatitude() + height / 4.0);
        Transform.zoomIn();
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void zoomOut() {
        Point leftUpperBoundary = Transform.getUpperLeftBoundary();
        Point rightLowerBoundary = Transform.getLowerRightBoundary();
        double width = rightLowerBoundary.getLongitude() - leftUpperBoundary.getLongitude();
        leftUpperBoundary.setLongitude(leftUpperBoundary.getLongitude() - width / 2.0);
        rightLowerBoundary.setLongitude(rightLowerBoundary.getLongitude() + width / 2.0);
        double height = leftUpperBoundary.getLatitude() - rightLowerBoundary.getLatitude();
        leftUpperBoundary.setLatitude(leftUpperBoundary.getLatitude() + height / 2.0);
        rightLowerBoundary.setLatitude(rightLowerBoundary.getLatitude() - height / 2.0);
        Transform.zoomOut();
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, false);
    }

    public void zoom(Point leftUpperBoundary, Point rightLowerBoundary) {
        this.modifiedZoom(leftUpperBoundary, rightLowerBoundary, true);
    }

    @Override
    public void mapTilesUpdated() {
        this.repaint();
    }

    @Override
    public void run() {
        while (this.isAutoRefresh()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.repaint();
        }
    }

    public void setMousePosition(int screenX, int screenY) {
        this.mouseX = screenX;
        this.mouseY = screenY;
    }

    public void setShowCoordinates(boolean selected) {
        this.showCoordinates = selected;
    }

    public boolean isShowCoordinates() {
        return this.showCoordinates;
    }

    public void zoom(Point zoomPoint) {
        Transform.zoomCenter(zoomPoint);
        this.tracksView.setView(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
        this.repaint();
    }

    public void zoom(MapExtract mapExtract) {
        Transform.zoom(mapExtract.getZoomLevel(), mapExtract.getUpperLeftBoundary());
        this.tracksView.setView(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
        this.repaint();
    }
}

