/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.ImageSources;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import jmap.Base.DataSources.ImageSource;
import jmap.Base.MapManager;
import jmap.Base.ZoomLevel;
import jmap.DataSources.ImageSources.TileImageFetcher;
import org.w3c.dom.Element;

public class OSImageFetcher
extends TileImageFetcher {
    String url = "http://tiles.ordnancesurvey.co.uk/osmapapi/tile/9D6DBD21C1A3608DE0405F0AC86054FE/";
    private static String[][] GBGridLetters = new String[][]{{"SV", "SQ", "SL", "SF", "SA", "NV", "NQ", "NL", "NF", "NA", "HV", "HQ", "HL", "HF", "HA"}, {"SW", "SR", "SM", "SG", "SB", "NW", "NR", "NM", "NG", "NB", "HW", "HR", "HM", "HG", "HB"}, {"SX", "SS", "SN", "SH", "SC", "NX", "NS", "NN", "NH", "NC", "HX", "HS", "HN", "HH", "HC"}, {"SY", "ST", "SO", "SJ", "SD", "NY", "NT", "NO", "NJ", "ND", "HY", "HT", "HO", "HJ", "HD"}, {"SZ", "SU", "SP", "SK", "SE", "NZ", "NU", "NP", "NK", "NE", "HZ", "HU", "HP", "HK", "HE"}, {"TV", "TQ", "TL", "TF", "TA", "OV", "OQ", "OL", "OF", "OA", "JV", "JQ", "JL", "JF", "JA"}, {"TW", "TR", "TM", "TG", "TB", "OW", "OR", "OM", "OG", "OB", "JW", "JR", "JM", "JG", "JB"}, {"TX", "TS", "TN", "TH", "TC", "OX", "OS", "ON", "OH", "OC", "JX", "JS", "JN", "JH", "JC"}, {"TY", "TT", "TO", "TJ", "TD", "OY", "OT", "OO", "OJ", "OD", "JY", "JT", "JO", "JJ", "JD"}, {"TZ", "TU", "TP", "TK", "TE", "OZ", "OU", "OP", "OK", "OE", "JZ", "JU", "JP", "JK", "JE"}};

    public Image getImage(Point2D position, ZoomLevel zl) {
        if (zl.getZoomData() == null) {
            return null;
        }
        double zoomLevel = (Double)zl.getZoomData();
        return this.createTile(this.url + zl.getFolderName() + "/", ".png?URL=http://www.getamap.ordnancesurveyleisure.co.uk", (int)(position.getX() / zoomLevel), (int)((1343562.5 - position.getY()) / zoomLevel), zl);
    }

    public ZoomLevel getZoomLevel(Element el) {
        ZoomLevel zl;
        double mapSize = Double.parseDouble(el.getAttribute("mapSize"));
        if (el.getAttribute("isOpenData").equals("0")) {
            zl = new ZoomLevel(el.getAttribute("dir"), el.getAttribute("name"), (Point2D)new Point2D.Double(mapSize, mapSize), new Point(250, 250), (ImageSource)this);
            zl.setZoomData((Object)mapSize);
        } else {
            int imgSize = Integer.parseInt(el.getAttribute("imgSize"));
            zl = new ZoomLevel(el.getAttribute("dir"), el.getAttribute("name"), (Point2D)new Point2D.Double(mapSize, mapSize), new Point(imgSize, imgSize), (ImageSource)this);
            zl.setCanDownloadData(false);
        }
        return zl;
    }

    public String zoomLevelToXml(ZoomLevel zl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mapSize", zl.getMapSize().getX());
        map.put("imgSize", zl.getImgSize().x);
        map.put("name", zl.getName());
        map.put("dir", zl.getFolderName());
        if (zl.canDownloadData()) {
            map.put("isOpenData", "0");
        } else {
            map.put("isOpenData", "1");
        }
        return MapManager.createXMLElenemt((String)"ZoomLevel", (String)"", map);
    }

    @Deprecated
    public Map<String, Object> getXmlAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "OSMap");
        map.put("class", "jmap.DataSources.ImageSources.OSImageFetcher");
        map.put("copyrightNotice", "Reproduced from Ordnance Survey map data by permission of Ordnance Survey, \u00a9 Crown copyright.");
        return map;
    }

    public String toString(Point2D p) {
        String cenXhun = String.valueOf(p.getX() % 100000.0);
        String cenYhun = String.valueOf(p.getY() % 100000.0);
        cenXhun = cenXhun.substring(0, 3);
        cenYhun = cenYhun.substring(0, 3);
        int cenXblock = (int)p.getX() / 100000;
        int cenYblock = (int)p.getY() / 100000;
        String coordStr = cenXblock < 0 || cenYblock < 0 ? "Outside" : GBGridLetters[cenXblock][cenYblock] + " " + cenXhun + " " + cenYhun;
        return coordStr;
    }

    public Point2D fromString(String s) {
        return OSImageFetcher.staticFromString(s);
    }

    public static Point staticFromString(String s) {
        String[] ss = s.split(" ");
        for (int i = 0; i < GBGridLetters.length; ++i) {
            String[] strings = GBGridLetters[i];
            for (int j = 0; j < strings.length; ++j) {
                String string = strings[j];
                if (!string.equals(ss[0].toUpperCase())) continue;
                String x = String.valueOf(i) + ss[1];
                String y = String.valueOf(j) + ss[2];
                return new Point(Integer.parseInt(x) * 100, Integer.parseInt(y) * 100);
            }
        }
        return null;
    }

    public Point2D longLatToLocal(double lon, double lat) {
        lat = Math.toRadians(lat);
        lon = Math.toRadians(lon);
        double a = 6377563.396;
        double b = 6356256.91;
        double F0 = 0.9996012717;
        double lat0 = Math.toRadians(49.0);
        double lon0 = Math.toRadians(-2.0);
        int N0 = -100000;
        int E0 = 400000;
        double e2 = 1.0 - b * b / (a * a);
        double n = (a - b) / (a + b);
        double n2 = n * n;
        double n3 = n * n * n;
        double cosLat = Math.cos(lat);
        double sinLat = Math.sin(lat);
        double nu = a * F0 / Math.sqrt(1.0 - e2 * sinLat * sinLat);
        double rho = a * F0 * (1.0 - e2) / Math.pow(1.0 - e2 * sinLat * sinLat, 1.5);
        double eta2 = nu / rho - 1.0;
        double Ma = (1.0 + n + 1.0 * n2 + 1.0 * n3) * (lat - lat0);
        double Mb = (3.0 * n + 3.0 * n * n + 2.0 * n3) * Math.sin(lat - lat0) * Math.cos(lat + lat0);
        double Mc = (1.0 * n2 + 1.0 * n3) * Math.sin(2.0 * (lat - lat0)) * Math.cos(2.0 * (lat + lat0));
        double Md = 1.0 * n3 * Math.sin(3.0 * (lat - lat0)) * Math.cos(3.0 * (lat + lat0));
        double M = b * F0 * (Ma - Mb + Mc - Md);
        double cos3lat = cosLat * cosLat * cosLat;
        double cos5lat = cos3lat * cosLat * cosLat;
        double tan2lat = Math.tan(lat) * Math.tan(lat);
        double tan4lat = tan2lat * tan2lat;
        double I = M + (double)N0;
        double II = nu / 2.0 * sinLat * cosLat;
        double III = nu / 24.0 * sinLat * cos3lat * (5.0 - tan2lat + 9.0 * eta2);
        double IIIA = nu / 720.0 * sinLat * cos5lat * (61.0 - 58.0 * tan2lat + tan4lat);
        double IV = nu * cosLat;
        double V = nu / 6.0 * cos3lat * (nu / rho - tan2lat);
        double VI = nu / 120.0 * cos5lat * (5.0 - 18.0 * tan2lat + tan4lat + 14.0 * eta2 - 58.0 * tan2lat * eta2);
        double dLon = lon - lon0;
        double dLon2 = dLon * dLon;
        double dLon3 = dLon2 * dLon;
        double dLon4 = dLon3 * dLon;
        double dLon5 = dLon4 * dLon;
        double dLon6 = dLon5 * dLon;
        double N = I + II * dLon2 + III * dLon4 + IIIA * dLon6;
        double E = (double)E0 + IV * dLon + V * dLon3 + VI * dLon5;
        return new Point((int)E, (int)N);
    }

    public Point2D localToLongLat(Point2D p) {
        double Md;
        double Mc;
        double Mb;
        double Ma;
        double E = p.getX();
        double N = p.getY();
        double a = 6377563.396;
        double b = 6356256.91;
        double F0 = 0.9996012717;
        double lat0 = 0.8552113334772214;
        double lon0 = -Math.PI / 90;
        double N0 = -100000.0;
        double E0 = 400000.0;
        double e2 = 1.0 - b * b / (a * a);
        double n = (a - b) / (a + b);
        double n2 = n * n;
        double n3 = n * n * n;
        double lat = lat0;
        double M = 0.0;
        while (N - N0 - (M = b * F0 * ((Ma = (1.0 + n + 1.0 * n2 + 1.0 * n3) * ((lat = (N - N0 - M) / (a * F0) + lat) - lat0)) - (Mb = (3.0 * n + 3.0 * n * n + 2.0 * n3) * Math.sin(lat - lat0) * Math.cos(lat + lat0)) + (Mc = (1.0 * n2 + 1.0 * n3) * Math.sin(2.0 * (lat - lat0)) * Math.cos(2.0 * (lat + lat0))) - (Md = 1.0 * n3 * Math.sin(3.0 * (lat - lat0)) * Math.cos(3.0 * (lat + lat0))))) >= 1.0E-5) {
        }
        double cosLat = Math.cos(lat);
        double sinLat = Math.sin(lat);
        double nu = a * F0 / Math.sqrt(1.0 - e2 * sinLat * sinLat);
        double rho = a * F0 * (1.0 - e2) / Math.pow(1.0 - e2 * sinLat * sinLat, 1.5);
        double eta2 = nu / rho - 1.0;
        double tanLat = Math.tan(lat);
        double tan2lat = tanLat * tanLat;
        double tan4lat = tan2lat * tan2lat;
        double tan6lat = tan4lat * tan2lat;
        double secLat = 1.0 / cosLat;
        double nu3 = nu * nu * nu;
        double nu5 = nu3 * nu * nu;
        double nu7 = nu5 * nu * nu;
        double VII = tanLat / (2.0 * rho * nu);
        double VIII = tanLat / (24.0 * rho * nu3) * (5.0 + 3.0 * tan2lat + eta2 - 9.0 * tan2lat * eta2);
        double IX = tanLat / (720.0 * rho * nu5) * (61.0 + 90.0 * tan2lat + 45.0 * tan4lat);
        double X = secLat / nu;
        double XI = secLat / (6.0 * nu3) * (nu / rho + 2.0 * tan2lat);
        double XII = secLat / (120.0 * nu5) * (5.0 + 28.0 * tan2lat + 24.0 * tan4lat);
        double XIIA = secLat / (5040.0 * nu7) * (61.0 + 662.0 * tan2lat + 1320.0 * tan4lat + 720.0 * tan6lat);
        double dE = E - E0;
        double dE2 = dE * dE;
        double dE3 = dE2 * dE;
        double dE4 = dE2 * dE2;
        double dE5 = dE3 * dE2;
        double dE6 = dE4 * dE2;
        double dE7 = dE5 * dE2;
        lat = lat - VII * dE2 + VIII * dE4 - IX * dE6;
        double lon = lon0 + X * dE - XI * dE3 + XII * dE5 - XIIA * dE7;
        return new Point2D.Double(Math.toDegrees(lon), Math.toDegrees(lat));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point2D mapGoto(Point2D currPos) {
        String[] s = JOptionPane.showInputDialog("Enter new position map coordinates (<x>,<y>) or OS grid reference (e.g. AA 123 456)", (Object)this.toString(currPos)).split(",");
        if (s.length == 1) {
            Point2D p = this.fromString(s[0]);
            if (p != null) return p;
            JOptionPane.showMessageDialog(null, "There was an error in the format of the position.\nPlease ensure it is a valid grid referance e.g. AA 123 456");
            return null;
        } else {
            try {
                return new Point2D.Double(Double.parseDouble(s[0]), Double.parseDouble(s[1]));
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(null, "There was an error in the format of the position.\nPlease ensure it is in the form '<x>,<y>', where <x> and <y> are numbers");
            }
        }
        return null;
    }
}

