/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.ImageSources;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import jmap.Base.DataSources.ImageSource;
import jmap.Base.MapManager;
import jmap.Base.ZoomLevel;
import jmap.DataSources.ImageSources.TileImageFetcher;
import org.w3c.dom.Element;

public class OSMImageFetcher
extends TileImageFetcher {
    private String baseUrl = "http://tile.openstreetmap.org/";

    public Image getImage(Point2D position, ZoomLevel zl) {
        int zoomLevel = (Integer)zl.getZoomData();
        return this.createTile(this.baseUrl + String.valueOf(zoomLevel) + "/", ".png", (int)Math.floor(position.getX() / Math.pow(2.0, 17 - zoomLevel)), (int)Math.floor((Math.pow(2.0, 17.0) - position.getY()) / Math.pow(2.0, 17 - zoomLevel) - 1.0), zl);
    }

    public String toString(Point2D p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Point2D fromString(String s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Point2D longLatToLocal(double lon, double lat) {
        double x = (lon + 180.0) / 360.0 * 131072.0;
        double y = Math.pow(2.0, 17.0) - (1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) * 65536.0;
        return new Point2D.Double(x, y);
    }

    public Point2D localToLongLat(Point2D p) {
        double lon = p.getX() / Math.pow(2.0, 17.0) * 360.0 - 180.0;
        double lat = Math.toDegrees(Math.atan(Math.sinh(Math.PI - Math.PI * 2 * p.getY() / Math.pow(2.0, 17.0))));
        return new Point2D.Double(lon, lat);
    }

    public Point2D mapGoto(Point2D currPos) {
        String[] s = JOptionPane.showInputDialog("Enter new position in map coordinates: ", (Object)(String.valueOf(currPos.getX()) + "," + String.valueOf(currPos.getY()))).split(",");
        try {
            return new Point2D.Double(Double.parseDouble(s[0]), Double.parseDouble(s[1]));
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(null, "There was an error in the format of the position.\nPlease ensure it is in the form '<x>,<y>', where <x> and <y> are numbers");
            return null;
        }
    }

    public ZoomLevel getZoomLevel(Element el) {
        double size = Math.pow(2.0, 17 - Integer.parseInt(el.getAttribute("zoomLevel")));
        String name = "OSM" + el.getAttribute("zoomLevel");
        ZoomLevel zl = new ZoomLevel(name, name, (Point2D)new Point2D.Double(size, size), new Point(256, 256), (ImageSource)this);
        zl.setZoomData((Object)Integer.parseInt(el.getAttribute("zoomLevel")));
        return zl;
    }

    public String zoomLevelToXml(ZoomLevel zl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zoomLevel", zl.getName().replace("OSM", ""));
        return MapManager.createXMLElenemt((String)"ZoomLevel", (String)"", map);
    }

    @Deprecated
    public Map<String, Object> getXmlAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("class", "jmap.DataSources.ImageSources.OSMImageFetcher");
        map.put("name", "OSMMap");
        map.put("copyrightNotice", "Map data \u00a9 OpenStreetMap (www.openstreetmap.org) contributors, CC BY-SA (www.creativecommons.org)");
        return map;
    }
}

