/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.OSOpenData;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import jmap.Base.ZoomLevel;
import jmap.DataSources.GeoData.Route;
import jmap.DataSources.GeoData.Waypoint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class UKHeight {
    private final String zipFile;
    private Map<String, HeightFile> loadedFiles = new HashMap<String, HeightFile>();
    private static String[][] GBGridLetters = new String[][]{{"SV", "SQ", "SL", "SF", "SA", "NV", "NQ", "NL", "NF", "NA", "HV", "HQ", "HL", "HF", "HA"}, {"SW", "SR", "SM", "SG", "SB", "NW", "NR", "NM", "NG", "NB", "HW", "HR", "HM", "HG", "HB"}, {"SX", "SS", "SN", "SH", "SC", "NX", "NS", "NN", "NH", "NC", "HX", "HS", "HN", "HH", "HC"}, {"SY", "ST", "SO", "SJ", "SD", "NY", "NT", "NO", "NJ", "ND", "HY", "HT", "HO", "HJ", "HD"}, {"SZ", "SU", "SP", "SK", "SE", "NZ", "NU", "NP", "NK", "NE", "HZ", "HU", "HP", "HK", "HE"}, {"TV", "TQ", "TL", "TF", "TA", "OV", "OQ", "OL", "OF", "OA", "JV", "JQ", "JL", "JF", "JA"}, {"TW", "TR", "TM", "TG", "TB", "OW", "OR", "OM", "OG", "OB", "JW", "JR", "JM", "JG", "JB"}, {"TX", "TS", "TN", "TH", "TC", "OX", "OS", "ON", "OH", "OC", "JX", "JS", "JN", "JH", "JC"}, {"TY", "TT", "TO", "TJ", "TD", "OY", "OT", "OO", "OJ", "OD", "JY", "JT", "JO", "JJ", "JD"}, {"TZ", "TU", "TP", "TK", "TE", "OZ", "OU", "OP", "OK", "OE", "JZ", "JU", "JP", "JK", "JE"}};

    public UKHeight(String zipFile) {
        this.zipFile = zipFile;
    }

    public String getZipFile() {
        return this.zipFile;
    }

    public double getHeight(Point2D p) throws IOException {
        String[] s = UKHeight.toString(p).split(" ");
        int x = Integer.parseInt(s[1].substring(0, 1));
        int y = Integer.parseInt(s[2].substring(0, 1));
        x -= x % 2;
        y -= y % 2;
        String heightFile = "DTM/ASCII/data/" + s[0].toLowerCase() + "/" + s[0].toLowerCase() + String.valueOf(x) + String.valueOf(y) + ".asc";
        if (!this.loadedFiles.containsKey(heightFile)) {
            this.loadedFiles.put(heightFile, this.getHeightData(this.zipFile, heightFile));
        }
        HeightFile hf = this.loadedFiles.get(heightFile);
        Point2D.Double offset = new Point2D.Double(hf.getBottomLeft().getX() - p.getX(), hf.getBottomLeft().getY() - p.getY());
        return hf.getData()[(int)(-((Point2D)offset).getX() / 50.0)][(int)(400.0 + ((Point2D)offset).getY() / 50.0)];
    }

    private HeightFile getHeightData(String zipFile, String heightFile) throws IOException {
        ZipFile zf = new ZipFile(zipFile);
        return this.getHeightData(zf.getInputStream(zf.getEntry(heightFile)));
    }

    private HeightFile getHeightData(InputStream is) throws IOException {
        String[] s;
        HeightFile hf = new HeightFile();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        for (int q = 0; q < 5; ++q) {
            Point p;
            s = br.readLine();
            if (s.toLowerCase().startsWith("ncols")) {
                p = hf.getDataSize();
                p.x = Integer.parseInt(s.split(" ")[1]);
                hf.setDataSize(p);
                continue;
            }
            if (s.toLowerCase().startsWith("nrows")) {
                p = hf.getDataSize();
                p.y = Integer.parseInt(s.split(" ")[1]);
                hf.setDataSize(p);
                continue;
            }
            if (s.toLowerCase().startsWith("xllcenter")) {
                hf.getBottomLeft().setLocation(Double.parseDouble(s.split(" ")[1]), hf.getBottomLeft().getY());
                continue;
            }
            if (s.toLowerCase().startsWith("yllcenter")) {
                hf.getBottomLeft().setLocation(hf.getBottomLeft().getX(), Double.parseDouble(s.split(" ")[1]));
                continue;
            }
            if (!s.toLowerCase().startsWith("cellsize")) continue;
            hf.setCellSize(Integer.parseInt(s.split(" ")[1]));
        }
        for (int y = 0; y < hf.getDataSize().y; ++y) {
            s = br.readLine().split(" ");
            for (int x = 0; x < hf.getDataSize().x; ++x) {
                hf.addHeight(x, y, Double.parseDouble(s[x]));
            }
        }
        return hf;
    }

    public void plotGraph(Route r, ZoomLevel zl) throws IOException {
        XYSeries series = new XYSeries((Comparable)((Object)r.getName()));
        double distance = 0.0;
        Point2D lastP = zl.getImageSource().longLatToLocal(r.getWaypoint(0).getPosition());
        for (Waypoint w : r.getWaypoints()) {
            Point2D p = zl.getImageSource().longLatToLocal(w.getPosition());
            if (!p.equals(lastP)) {
                double dDist = p.distance(lastP);
                Point2D.Double vector = new Point2D.Double((p.getX() - lastP.getX()) / dDist, (p.getY() - lastP.getY()) / dDist);
                int q = 0;
                while ((double)q < dDist) {
                    Point2D.Double p2 = new Point2D.Double(lastP.getX() + ((Point2D)vector).getX() * (double)q, lastP.getY() + ((Point2D)vector).getY() * (double)q);
                    series.add((distance + (double)q) / 1000.0, this.getHeight(p2));
                    ++q;
                }
            }
            series.add((distance += p.distance(lastP)) / 1000.0, this.getHeight(p));
            lastP = p;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart("Route Profile", "Distance (km)", "Height (m)", dataset, PlotOrientation.VERTICAL, true, true, false);
        ChartPanel panel = new ChartPanel(chart);
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
    }

    public static String toString(Point2D p) {
        String cenXhun = String.valueOf((int)p.getX() % 100000);
        String cenYhun = String.valueOf((int)p.getY() % 100000);
        while (cenXhun.length() < 5) {
            cenXhun = "0" + cenXhun;
        }
        while (cenYhun.length() < 5) {
            cenYhun = "0" + cenYhun;
        }
        cenXhun = cenXhun.substring(0, 3);
        cenYhun = cenYhun.substring(0, 3);
        int cenXblock = (int)p.getX() / 100000;
        int cenYblock = (int)p.getY() / 100000;
        String coordStr = cenXblock < 0 || cenYblock < 0 ? "Outside" : GBGridLetters[cenXblock][cenYblock] + " " + cenXhun + " " + cenYhun;
        return coordStr;
    }

    public static Point FromString(String s) {
        String[] ss = s.split(" ");
        for (int i = 0; i < GBGridLetters.length; ++i) {
            String[] strings = GBGridLetters[i];
            for (int j = 0; j < strings.length; ++j) {
                String string = strings[j];
                if (!string.equals(ss[0].toUpperCase())) continue;
                String x = String.valueOf(i) + ss[1];
                String y = String.valueOf(j) + ss[2];
                return new Point(Integer.parseInt(x) * 100, Integer.parseInt(y) * 100);
            }
        }
        return null;
    }

    public class HeightFile {
        private Point dataSize = new Point();
        private Point2D bottemLeft = new Point2D.Double();
        private double[][] data;
        private int cellSize;

        public Point getDataSize() {
            return this.dataSize;
        }

        public void setDataSize(Point dataSize) {
            this.dataSize = dataSize;
            this.data = new double[dataSize.x][dataSize.y];
        }

        public Point2D getBottomLeft() {
            return this.bottemLeft;
        }

        public void setBottomLeft(Point2D bottomLeft) {
            this.bottemLeft = bottomLeft;
        }

        public double[][] getData() {
            return this.data;
        }

        public void addHeight(int x, int y, double height) {
            this.data[x][y] = height;
        }

        public int getCellSize() {
            return this.cellSize;
        }

        public void setCellSize(int cellSize) {
            this.cellSize = cellSize;
        }
    }
}

