/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.Plugins;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmap.Base.DataSources.Plugin;
import jmap.Base.JarFile;
import jmap.Base.MapManager;
import jmap.Base.ZoomLevel;
import jmap.gui.CollapsiblePanel;
import jmap.gui.Main;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Gazetteer
extends Plugin
implements Runnable {
    public ArrayList<GazetteerEntry> entries = new ArrayList();
    protected ArrayList<String> names = new ArrayList();
    protected BufferedReader reader = null;
    private boolean ready = false;
    private Thread t;
    final JPanel mainPanel = new JPanel();
    ArrayList<ActionListener> listeners = new ArrayList(0);

    public Gazetteer() {
        super("Find Place");
    }

    public GazetteerEntry[] getEntrys(String s) {
        return this.getEntrys(s, true);
    }

    public GazetteerEntry[] searchEntrys(String s) {
        return this.getEntrys(s, false);
    }

    public GazetteerEntry[] getEntrys(String s, boolean absolute) {
        int i;
        if (absolute) {
            i = this.names.indexOf(s);
            if (i == -1) {
                return null;
            }
        } else {
            i = 0;
        }
        ArrayList<GazetteerEntry> retAl = new ArrayList<GazetteerEntry>();
        int limit = absolute ? this.names.lastIndexOf(s) + 1 : this.names.size();
        while (i < limit) {
            if (absolute && this.names.get(i).equalsIgnoreCase(s) || !absolute && this.names.get(i).toLowerCase().contains(s.toLowerCase())) {
                retAl.add(this.entries.get(i));
            }
            ++i;
        }
        return retAl.toArray(new GazetteerEntry[retAl.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String s = this.reader.readLine();
            while (s != null) {
                GazetteerEntry entry = new GazetteerEntry(s);
                this.entries.add(entry);
                this.names.add(entry.getName());
                s = this.reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Gazetteer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Gazetteer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Gazetteer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.ready = true;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void draw(Graphics g, Point2D topLeft, int bottem, double xRatio, double yRatio, ZoomLevel zl) {
    }

    public JPanel getSidebarDisplay() {
        this.mainPanel.removeAll();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(new JLabel("Search For Place..."));
        final JTextField textField = new JTextField();
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    if (!Gazetteer.this.isReady()) {
                        JOptionPane.showMessageDialog(Gazetteer.this.mainPanel, "Error: Data is still being loaded.");
                    } else {
                        GazetteerEntry[] entrys = Gazetteer.this.getEntrys(textField.getText(), false);
                        if (entrys.length == 0) {
                            JOptionPane.showMessageDialog(Gazetteer.this.mainPanel, "No place found with that name.");
                        } else {
                            Gazetteer.this.addSearch(textField.getText(), entrys);
                        }
                    }
                }
            }
        });
        textField.setMaximumSize(new Dimension(Short.MAX_VALUE, textField.getPreferredSize().height));
        this.mainPanel.add(textField);
        return this.mainPanel;
    }

    private void addEntries(final GazetteerEntry entry, CollapsiblePanel panel) {
        JButton bookmark = new JButton(entry.getName() + ": " + entry.getKilometerRef());
        bookmark.setBorder(null);
        bookmark.setContentAreaFilled(false);
        bookmark.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 1) {
                    Main.map.setMapPos((Point2D)entry.getPosition());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                ((JButton)e.getSource()).setContentAreaFilled(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                ((JButton)e.getSource()).setContentAreaFilled(false);
            }
        });
        panel.getPanel().add(bookmark);
    }

    public void addSearch(String searchTerm, GazetteerEntry[] search) {
        CollapsiblePanel panel = this.createPanel(searchTerm);
        for (int q = 0; q < search.length; ++q) {
            this.addEntries(search[q], panel);
            this.mainPanel.add((Component)panel);
        }
        this.mainPanel.updateUI();
    }

    private CollapsiblePanel createPanel(String s) {
        final CollapsiblePanel panel = new CollapsiblePanel(s);
        panel.getPanel().setLayout(new BoxLayout(panel.getPanel(), 1));
        panel.getButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getButton() == 3) {
                    panel.setVisible(false);
                }
            }
        });
        return panel;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireActionEvents(ActionEvent event) {
        System.out.println(this.listeners.size());
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(event);
        }
    }

    public void configure(MapManager mapManager) {
        try {
            this.configure("jar://50kgaz2011.txt", mapManager);
        }
        catch (FileNotFoundException | IllegalArgumentException | MalformedURLException ex) {
            Logger.getLogger(Gazetteer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void configure(Element el, MapManager mapManager) {
        NodeList nl = el.getElementsByTagName("InputFile");
        if (nl.getLength() != 1) {
            throw new IllegalArgumentException("No file specified for DataSources.Gazetteer.");
        }
        try {
            this.configure(nl.item(0).getTextContent(), mapManager);
        }
        catch (FileNotFoundException | IllegalArgumentException | MalformedURLException ex) {
            Logger.getLogger(Gazetteer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void configure(String inputFile, MapManager mapManager) throws IllegalArgumentException, MalformedURLException, FileNotFoundException {
        InputStream is = null;
        if (inputFile.startsWith("jar://")) {
            JarFile jf;
            Iterator i$ = mapManager.getJarFiles().iterator();
            while (i$.hasNext() && (is = (jf = (JarFile)i$.next()).getResource(inputFile.replace("jar://", ""))) == null) {
            }
        } else {
            is = new FileInputStream(new File(inputFile));
        }
        if (is == null) {
            throw new FileNotFoundException();
        }
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.t = new Thread(this);
        this.t.start();
    }

    protected String dataToXml() {
        return MapManager.createXMLElenemt((String)"InputFile", (Object)"jar://50kgaz2011.txt");
    }

    public class GazetteerEntry {
        protected String kilometerRef;
        protected String name;
        protected String tileRef;
        protected String greenwichMeridian;
        protected String countyCode;
        protected String countyName;
        protected String fullCountyName;
        protected String featureCode;
        protected String editDate;
        protected String updateCode;
        protected int sequenceNumber;
        protected int latDegrees;
        protected int longDegrees;
        protected int northings;
        protected int eastings;
        protected int[] sheet;
        protected float latMinutes;
        protected float longMinutes;
        protected Point pos = null;
        protected boolean featureAntiquity = false;
        protected boolean featureForest = false;
        protected boolean featureFarm = false;
        protected boolean featureHill = false;
        protected boolean featureAntiquityRoman = false;
        protected boolean featureCity = false;
        protected boolean featureTown = false;
        protected boolean featureOther = false;
        protected boolean featureWater = false;
        protected boolean featureAllOther = false;

        public GazetteerEntry(String s) {
            String[] arr = s.split(":");
            this.sequenceNumber = Integer.parseInt(arr[0]);
            this.kilometerRef = arr[1];
            this.name = arr[2];
            this.tileRef = arr[3];
            this.latDegrees = Integer.parseInt(arr[4]);
            this.latMinutes = Float.parseFloat(arr[5]);
            this.longDegrees = Integer.parseInt(arr[6]);
            this.longMinutes = Float.parseFloat(arr[7]);
            this.northings = Integer.parseInt(arr[8]);
            this.eastings = Integer.parseInt(arr[9]);
            this.greenwichMeridian = arr[10];
            this.countyCode = arr[11];
            this.countyName = arr[12];
            this.fullCountyName = arr[13];
            this.featureCode = arr[14];
            this.editDate = arr[15];
            this.updateCode = arr[16];
            this.sheet = new int[3];
            for (int q = 0; q < 3; ++q) {
                this.sheet[q] = Integer.parseInt(arr[17 + q]);
            }
            this.pos = new Point(this.eastings, this.northings);
            if (this.featureCode.contains("A")) {
                this.featureAntiquity = true;
            }
            if (this.featureCode.contains("F")) {
                this.featureForest = true;
            }
            if (this.featureCode.contains("FM")) {
                this.featureFarm = true;
            }
            if (this.featureCode.contains("H")) {
                this.featureHill = true;
            }
            if (this.featureCode.contains("R")) {
                this.featureAntiquityRoman = true;
            }
            if (this.featureCode.contains("C")) {
                this.featureCity = true;
            }
            if (this.featureCode.contains("T")) {
                this.featureTown = true;
            }
            if (this.featureCode.contains("O")) {
                this.featureOther = true;
            }
            if (this.featureCode.contains("W")) {
                this.featureWater = true;
            }
            if (this.featureCode.contains("X")) {
                this.featureAllOther = true;
            }
        }

        public GazetteerEntry(String kilometerRef, String name, String tileRef, String greenwichMeridian, String countyCode, String countyName, String fullCountyName, String featureCode, String editDate, String updateCode, int sequenceNumber, int latDegrees, int longDegrees, int northings, int eastings, int[] sheet, float latMinutes, float longMinutes) {
            this.kilometerRef = kilometerRef;
            this.name = name;
            this.tileRef = tileRef;
            this.greenwichMeridian = greenwichMeridian;
            this.countyCode = countyCode;
            this.countyName = countyName;
            this.fullCountyName = fullCountyName;
            this.featureCode = featureCode;
            this.editDate = editDate;
            this.updateCode = updateCode;
            this.sequenceNumber = sequenceNumber;
            this.latDegrees = latDegrees;
            this.longDegrees = longDegrees;
            this.northings = northings;
            this.eastings = eastings;
            this.sheet = sheet;
            this.latMinutes = latMinutes;
            this.longMinutes = longMinutes;
        }

        public String getKilometerRef() {
            return this.kilometerRef;
        }

        public String getName() {
            return this.name;
        }

        public String getTileRef() {
            return this.tileRef;
        }

        public String getGreenwichMeridian() {
            return this.greenwichMeridian;
        }

        public String getCountyCode() {
            return this.countyCode;
        }

        public String getCountyName() {
            return this.countyName;
        }

        public String getFullCountyName() {
            return this.fullCountyName;
        }

        public String getFeatureCode() {
            return this.featureCode;
        }

        public String getEditDate() {
            return this.editDate;
        }

        public String getUpdateCode() {
            return this.updateCode;
        }

        public int getSequenceNumber() {
            return this.sequenceNumber;
        }

        public int getLatDegrees() {
            return this.latDegrees;
        }

        public int getLongDegrees() {
            return this.longDegrees;
        }

        public int getNorthings() {
            return this.northings;
        }

        public int getEastings() {
            return this.eastings;
        }

        public int[] getSheet() {
            return this.sheet;
        }

        public float getLatMinutes() {
            return this.latMinutes;
        }

        public float getLongMinutes() {
            return this.longMinutes;
        }

        public Point getPosition() {
            return this.pos;
        }

        public boolean isFeatureAntiquity() {
            return this.featureAntiquity;
        }

        public boolean isFeatureForest() {
            return this.featureForest;
        }

        public boolean isFeatureFarm() {
            return this.featureFarm;
        }

        public boolean isFeatureHill() {
            return this.featureHill;
        }

        public boolean isFeatureAntiquityRoman() {
            return this.featureAntiquityRoman;
        }

        public boolean isFeatureCity() {
            return this.featureCity;
        }

        public boolean isFeatureTown() {
            return this.featureTown;
        }

        public boolean isFeatureOther() {
            return this.featureOther;
        }

        public boolean isFeatureWater() {
            return this.featureWater;
        }

        public boolean isFeatureAllOther() {
            return this.featureAllOther;
        }
    }
}

