/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.Plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import jmap.Base.DataSources.Plugin;
import jmap.Base.MapComponent;
import jmap.Base.MapManager;
import jmap.Base.PaintListener;
import jmap.Base.ZoomLevel;
import jmap.DataSources.GeoData.Document;
import jmap.DataSources.GeoData.GPXDocument;
import jmap.DataSources.GeoData.KMLDocument;
import jmap.DataSources.GeoData.Route;
import jmap.DataSources.GeoData.Waypoint;
import jmap.DataSources.OSOpenData.UKHeight;
import jmap.gui.Main;
import jmap.gui.Tree;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MapObjects
extends Plugin {
    protected JPanel mainPanel = new JPanel();
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private final JTree jTree = new JTree(this.rootNode);
    protected DefaultMutableTreeNode Waypoints = new DefaultMutableTreeNode("Waypoints");
    protected DefaultMutableTreeNode Routes = new DefaultMutableTreeNode("Routes");
    protected DefaultMutableTreeNode Tracks = new DefaultMutableTreeNode("Tracks");
    protected Route editRoute = null;
    protected MapComponent clipboard = null;
    private ArrayList<Document> documents = new ArrayList();
    private ArrayList<String> savedDocuments = new ArrayList();
    private Document selectedMapDocument = null;
    private JComboBox jComboBox1;
    private Point last = null;
    private Point transformed = null;
    private int lastWp = -1;
    private MapManager mapManager = null;
    private UKHeight height = null;

    public MapObjects() {
        super("Files");
    }

    public void configure(MapManager mapManager) {
        this.initComponents();
        this.mapManager = mapManager;
        this.documents.add(new TempDocumenmt());
        this.jComboBox1.addItem("Untitled");
        Main.map.addMouseListener((MouseListener)new ViewerMouseAdaptor());
    }

    public void configure(Element el, MapManager mapManager) {
        this.configure(mapManager);
        NodeList nl = el.getElementsByTagName("File");
        for (int q = 0; q < nl.getLength(); ++q) {
            Element el2 = (Element)nl.item(q);
            if (!el2.hasAttribute("name")) continue;
            this.OpenFile(el2.getAttribute("name"));
            this.savedDocuments.add(el2.getAttribute("name"));
        }
        nl = el.getElementsByTagName("HeightMap");
        if (nl.getLength() > 0 && ((Element)nl.item(0)).hasAttribute("name")) {
            this.height = new UKHeight(((Element)nl.item(0)).getAttribute("name"));
        }
    }

    private void initComponents() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        JMenuItem item = new JMenuItem("Open File...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showOpenDialog((Component)Main.map) == 0) {
                    MapObjects.this.OpenFile(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        item.setBorder(new MetalBorders.ButtonBorder());
        menuBar.add(item);
        item = new JMenuItem("Save");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MapObjects.this.selectedMapDocument.write();
                }
                catch (IOException ex) {
                    Logger.getLogger(MapObjects.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        item.setBorder(new MetalBorders.ButtonBorder());
        menuBar.add(item);
        JMenu menu = new JMenu("Save As");
        item = new JMenuItem("GPX File...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(MapObjects.this.selectedMapDocument.getFile());
                if (chooser.showSaveDialog((Component)Main.map) == 0) {
                    try {
                        Document doc;
                        if (MapObjects.this.selectedMapDocument.getClass().equals(GPXDocument.class)) {
                            doc = MapObjects.this.selectedMapDocument;
                            doc.setFile(chooser.getSelectedFile().getAbsolutePath());
                        } else {
                            doc = new GPXDocument(chooser.getSelectedFile().getAbsolutePath());
                            doc.setWaypoints(MapObjects.this.selectedMapDocument.getWaypoints());
                            doc.setRoutes(MapObjects.this.selectedMapDocument.getRoutes());
                            doc.setTracks(MapObjects.this.selectedMapDocument.getTracks());
                        }
                        doc.write();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(MapObjects.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        menu.add(item);
        menuBar.add(menu);
        this.jComboBox1 = new JComboBox();
        this.jComboBox1.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = MapObjects.this.jComboBox1.getSelectedIndex();
                if (MapObjects.this.documents.size() > index && index >= 0) {
                    MapObjects.this.selectedMapDocument = (Document)MapObjects.this.documents.get(index);
                    MapObjects.this.createTree(MapObjects.this.selectedMapDocument);
                }
            }
        });
        this.jTree.setMinimumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.rootNode.add(this.Waypoints);
        this.rootNode.add(this.Routes);
        this.rootNode.add(this.Tracks);
        this.jTree.setRootVisible(false);
        this.jTree.setExpandsSelectedPaths(true);
        this.jTree.setSelectionPath(new TreePath(new Object[]{this.rootNode, this.Waypoints}));
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Object component = MapObjects.this.jTree.getSelectionPath().getLastPathComponent();
                if (component.getClass().equals(WaypointTree.class) || component.getClass().equals(RouteTree.class)) {
                    ((Tree)component).mouseClick(e);
                } else if (component.getClass().equals(DefaultMutableTreeNode.class) && e.getButton() == 3) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
                    if (node.getUserObject() == "Waypoints") {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem item = new JMenuItem("Add waypoint");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Main.map.addMouseListener((MouseListener)new MouseAdapter(){

                                    @Override
                                    public void mouseClicked(MouseEvent e) {
                                        if (e.getButton() == 1) {
                                            Point p = e.getPoint();
                                            ((Point2D)p).setLocation(Main.map.getMapPos().getX() - ((double)(Main.map.getWidth() / 2) - ((Point2D)p).getX()) * Main.map.getImgtoMapX(), Main.map.getMapPos().getY() - ((double)(Main.map.getHeight() / 2) - ((double)Main.map.getHeight() - ((Point2D)p).getY())) * Main.map.getImgtoMapY());
                                            Waypoint waypoint = new Waypoint((Point2D)p);
                                            String name = JOptionPane.showInputDialog("Enter name of new waypoint:");
                                            if (name != null && !name.equals("")) {
                                                waypoint.setName(name);
                                            }
                                            MapObjects.this.Waypoints.add((MutableTreeNode)((Object)new WaypointTree((MapComponent)waypoint)));
                                            MapObjects.this.selectedMapDocument.addWaypoint(waypoint);
                                            MapObjects.this.jTree.updateUI();
                                        }
                                        Main.map.removeMouseListener((MouseListener)this);
                                    }
                                });
                            }
                        });
                        menu.add(item);
                        menu.add(new JSeparator());
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    } else if (node.getUserObject() == "Routes") {
                        JPopupMenu menu = new JPopupMenu();
                        JMenuItem item = new JMenuItem("Add route");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String name = JOptionPane.showInputDialog("Enter name of new Route:");
                                if (name != null && !name.equals("")) {
                                    Route r = new Route(name, Route.ROUTE_TYPE.ROUTE);
                                    MapObjects.this.Routes.add((MutableTreeNode)((Object)new RouteTree((MapComponent)r)));
                                    MapObjects.this.selectedMapDocument.addRoute(r);
                                    MapObjects.this.jTree.updateUI();
                                }
                            }
                        });
                        menu.add(item);
                        menu.add(new JSeparator());
                        item = new JMenuItem("Paste");
                        item.setEnabled(MapObjects.this.clipboard != null);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (MapObjects.this.clipboard.getClass().equals(Waypoint.class)) {
                                    MapObjects.this.Waypoints.add((MutableTreeNode)((Object)new WaypointTree((MapComponent)((Waypoint)MapObjects.this.clipboard))));
                                    MapObjects.this.selectedMapDocument.addWaypoint((Waypoint)MapObjects.this.clipboard);
                                    MapObjects.this.jTree.updateUI();
                                } else if (MapObjects.this.clipboard.getClass().equals(Route.class)) {
                                    MapObjects.this.Routes.add((MutableTreeNode)((Object)new RouteTree((MapComponent)((Route)MapObjects.this.clipboard))));
                                    MapObjects.this.selectedMapDocument.addRoute((Route)MapObjects.this.clipboard);
                                    MapObjects.this.jTree.updateUI();
                                }
                            }
                        });
                        menu.add(item);
                        menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.jTree);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.add(menuBar);
        this.mainPanel.add(this.jComboBox1);
        this.mainPanel.add(jScrollPane);
    }

    public void draw(Graphics g, Point2D topLeft, int bottem, double xRatio, double yRatio, ZoomLevel zl) {
        Point pos;
        Tree t;
        if (this.Waypoints.getChildCount() > 0) {
            for (t = (Tree)this.Waypoints.getFirstChild(); t != null; t = (Tree)t.getNextSibling()) {
                t.getComponent().draw(g, topLeft, bottem, xRatio, yRatio, zl);
            }
        }
        if (this.Routes.getChildCount() > 0) {
            for (t = (Tree)this.Routes.getFirstChild(); t != null; t = (Tree)t.getNextSibling()) {
                t.getComponent().draw(g, topLeft, bottem, xRatio, yRatio, zl);
            }
        }
        if (this.Tracks.getChildCount() > 0) {
            for (t = (Tree)this.Tracks.getFirstChild(); t != null; t = (Tree)t.getNextSibling()) {
                t.getComponent().draw(g, topLeft, bottem, xRatio, yRatio, zl);
            }
        }
        if ((pos = this.getMouseOverRoute((Point2D)topLeft, (double)xRatio, (double)yRatio, (ZoomLevel)zl).pos) != null) {
            g.setColor(Color.RED);
            g.drawOval(pos.x - 5, pos.y - 5, 10, 10);
            g.fillOval(pos.x - 2, pos.y - 2, 4, 4);
        }
        Main.map.repaint();
    }

    public JPanel getSidebarDisplay() {
        return this.mainPanel;
    }

    private void createTree(Document doc) {
        this.Waypoints.removeAllChildren();
        this.Routes.removeAllChildren();
        this.Tracks.removeAllChildren();
        for (Waypoint w : doc.getWaypoints()) {
            this.Waypoints.add((MutableTreeNode)((Object)new WaypointTree((MapComponent)w)));
        }
        for (Route r : doc.getRoutes()) {
            this.Routes.add((MutableTreeNode)((Object)new RouteTree((MapComponent)r)));
        }
        for (Route t : doc.getTracks()) {
            this.Tracks.add((MutableTreeNode)((Object)new RouteTree((MapComponent)t)));
        }
        this.jTree.updateUI();
    }

    protected String dataToXml() {
        String content = "";
        for (String s : this.savedDocuments) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", s);
            content = content + MapManager.createXMLElenemt((String)"File", (String)"", map);
        }
        if (this.height != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", this.height.getZipFile());
            content = content + MapManager.createXMLElenemt((String)"HeightMap", (String)"", map);
        }
        return content;
    }

    protected void OpenFile(String file) {
        GPXDocument document = null;
        if (file.toLowerCase().endsWith(".gpx")) {
            document = new GPXDocument(file);
        } else if (file.toLowerCase().endsWith(".kml")) {
            document = new KMLDocument(file);
        }
        document.parseDocument(this.mapManager);
        this.documents.add((Document)document);
        this.jComboBox1.addItem(new File(file).getName());
    }

    protected MouseOverRouteData getMouseOverRoute(Point2D topLeft, double xRatio, double yRatio, ZoomLevel zl) {
        MouseOverRouteData ret = new MouseOverRouteData();
        Point mouseLocation = Main.map.getMousePosition();
        if (mouseLocation != null) {
            ((Point2D)mouseLocation).setLocation(Main.map.getMapPos().getX() - ((double)(Main.map.getWidth() / 2) - ((Point2D)mouseLocation).getX()) * Main.map.getImgtoMapX(), Main.map.getMapPos().getY() - ((double)(Main.map.getHeight() / 2) - ((double)Main.map.getHeight() - ((Point2D)mouseLocation).getY())) * Main.map.getImgtoMapY());
            double distMin = Double.MAX_VALUE;
            for (Route r : this.selectedMapDocument.getRoutes()) {
                if (r.isEmpty()) continue;
                Point2D lastP = null;
                for (Waypoint w : r.getWaypoints()) {
                    Point2D p = Main.map.getZoomLevel().getImageSource().longLatToLocal(w.getPosition());
                    if (lastP != null) {
                        double v2Dist;
                        Point2D.Double v1 = new Point2D.Double(p.getX() - lastP.getX(), p.getY() - lastP.getY());
                        Point2D.Double v2 = new Point2D.Double(((Point2D)mouseLocation).getX() - lastP.getX(), ((Point2D)mouseLocation).getY() - lastP.getY());
                        double v1Dist = v1.distance(0.0, 0.0);
                        double a = v1Dist * (v2Dist = v2.distance(0.0, 0.0));
                        if (a != 0.0) {
                            a = Math.acos((((Point2D)v1).getX() * ((Point2D)v2).getX() + ((Point2D)v1).getY() * ((Point2D)v2).getY()) / a);
                        }
                        if (Math.abs(v2Dist * Math.sin(a)) < 4.0 / (Math.sqrt(xRatio * xRatio + yRatio * yRatio) * Math.sin(a)) && v2Dist * Math.cos(a) < v1Dist && v2Dist * Math.cos(a) > 0.0 && v2Dist * Math.sin(a) < distMin) {
                            distMin = v2Dist * Math.sin(a);
                            double tmpDx = lastP.getX() + v2Dist * Math.cos(a) * ((Point2D)v1).getX() / v1Dist;
                            double tmpDy = lastP.getY() + v2Dist * Math.cos(a) * ((Point2D)v1).getY() / v1Dist;
                            ret.pos = new Point((int)((tmpDx - topLeft.getX()) * xRatio), Main.map.getHeight() - (int)((tmpDy - topLeft.getY()) * yRatio));
                            ret.mapLocation = new Point2D.Double(tmpDx, tmpDy);
                            ret.route = r;
                            ret.waypoint = w;
                            ret.found = true;
                        }
                    }
                    lastP = p;
                }
            }
        }
        return ret;
    }

    public class TempDocumenmt
    extends Document {
        public TempDocumenmt() {
            super("");
        }

        public void parseDocument(MapManager mapManager) {
        }

        public void write() throws IOException {
        }
    }

    class RouteTree
    extends Tree {
        final RouteTree THIS;

        public RouteTree(MapComponent component) {
            super(component);
            this.THIS = this;
        }

        public void mouseClick(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() > 1 && ((Route)this.getComponent()).getWaypoints().size() > 0) {
                Main.map.setMapPos(Main.map.getZoomLevel().getImageSource().longLatToLocal(((Route)this.getComponent()).getWaypoint(0).getPosition()));
            } else if (e.getButton() == 3) {
                final Route r = (Route)this.component;
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Add Point");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        r.drawEndPoint = false;
                        final PaintListener pl = new PaintListener(){

                            public void paint(Graphics g) {
                                if (r.getWaypoints().size() > 0) {
                                    Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
                                    Point locationOnScreen = Main.map.getLocationOnScreen();
                                    Point p = r.getWaypoint(r.getWaypoints().size() - 1).toScreenCoords(Main.map.getTopLeft(), Main.map.getMaptoImgX(), Main.map.getMaptoImgY(), Main.map.getZoomLevel());
                                    Color c = g.getColor();
                                    g.setColor(r.getColour());
                                    g.drawLine(p.x, Main.map.getHeight() - p.y, mouseLocation.x - (int)locationOnScreen.getX(), mouseLocation.y - (int)locationOnScreen.getY());
                                    g.setColor(c);
                                    Main.map.repaint();
                                }
                            }
                        };
                        Main.map.addPaintListener(pl);
                        Main.map.addMouseListener((MouseListener)new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getButton() == 1) {
                                    Point p = e.getPoint();
                                    ((Point2D)p).setLocation(Main.map.getMapPos().getX() - ((double)(Main.map.getWidth() / 2) - ((Point2D)p).getX()) * Main.map.getImgtoMapX(), Main.map.getMapPos().getY() - ((double)(Main.map.getHeight() / 2) - ((double)Main.map.getHeight() - ((Point2D)p).getY())) * Main.map.getImgtoMapY());
                                    Waypoint waypoint = new Waypoint(Main.map.getZoomLevel().getImageSource().localToLongLat((Point2D)p));
                                    r.addWaypoint(waypoint);
                                    Main.map.repaint();
                                } else {
                                    Main.map.removeMouseListener((MouseListener)this);
                                    Main.map.removePaintListener(pl);
                                    r.drawEndPoint = true;
                                    Main.map.setCursor(Cursor.getDefaultCursor());
                                }
                            }
                        });
                        Main.map.setCursor(Cursor.getPredefinedCursor(1));
                    }
                });
                menu.add(item);
                menu.add(new JSeparator());
                item = new JMenuItem("Copy");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapObjects.this.clipboard = r;
                    }
                });
                menu.add(item);
                item = new JMenuItem("Length");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(MapObjects.this.mainPanel, "Route is " + String.valueOf(r.getRouteLength(Main.map.getZoomLevel()) / 1000) + "." + String.valueOf(r.getRouteLength(Main.map.getZoomLevel()) % 1000 / 100) + "km (" + String.valueOf(r.getRouteLength(Main.map.getZoomLevel()) / 1600) + "miles).");
                    }
                });
                menu.add(item);
                item = new JMenuItem("Route Profile");
                item.setEnabled(MapObjects.this.height != null);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MapObjects.this.height.plotGraph((Route)RouteTree.this.getComponent(), Main.map.getZoomLevel());
                        }
                        catch (IOException ex) {
                            Logger.getLogger(MapObjects.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
                menu.add(item);
                menu.add(new JSeparator());
                item = new JMenuItem("Delete");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapObjects.this.Routes.remove((MutableTreeNode)((Object)RouteTree.this.THIS));
                        MapObjects.this.selectedMapDocument.removeRoute(r);
                        MapObjects.this.jTree.updateUI();
                        Main.map.paint(Main.map.getGraphics());
                    }
                });
                menu.add(item);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class WaypointTree
    extends Tree {
        final WaypointTree THIS;

        public WaypointTree(MapComponent component) {
            super(component);
            this.THIS = this;
        }

        public void mouseClick(MouseEvent e) {
            if (e.getButton() == 1) {
                Main.map.setMapPos(((Waypoint)this.getComponent()).getPosition());
            } else if (e.getButton() == 3) {
                final Waypoint wp = (Waypoint)this.getComponent();
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Copy");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapObjects.this.clipboard = wp;
                    }
                });
                menu.add(item);
                menu.add(new JSeparator());
                item = new JMenuItem("Delete");
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MapObjects.this.Waypoints.remove((MutableTreeNode)((Object)WaypointTree.this.THIS));
                        MapObjects.this.selectedMapDocument.removeWaypoint(wp);
                        MapObjects.this.jTree.updateUI();
                        Main.map.paint(Main.map.getGraphics());
                    }
                });
                menu.add(item);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class ViewerMouseAdaptor
    extends MouseAdapter {
        ViewerMouseAdaptor() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                final MouseOverRouteData mord = MapObjects.this.getMouseOverRoute(Main.map.getTopLeft(), Main.map.getMaptoImgX(), Main.map.getMaptoImgY(), Main.map.getZoomLevel());
                if (mord.pos != null) {
                    JPopupMenu menu = new JPopupMenu("Edit Route");
                    JMenuItem item = new JMenuItem("Add Point of Interest/Waymarker");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Waypoint waypoint = new Waypoint(Main.map.getZoomLevel().getImageSource().localToLongLat(mord.mapLocation));
                            String name = JOptionPane.showInputDialog("Enter name of new waypoint:");
                            if (name != null && !name.equals("")) {
                                waypoint.setName(name);
                                MapObjects.this.Waypoints.add((MutableTreeNode)((Object)new WaypointTree((MapComponent)waypoint)));
                                MapObjects.this.selectedMapDocument.addWaypoint(waypoint);
                                MapObjects.this.jTree.updateUI();
                            }
                        }
                    });
                    menu.add(item);
                    item = new JMenuItem("Split Route");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Waypoint waypoint = new Waypoint(Main.map.getZoomLevel().getImageSource().localToLongLat(mord.mapLocation));
                            String name = JOptionPane.showInputDialog("Enter name of new route:", (Object)mord.route.getName());
                            if (name != null && !name.equals("")) {
                                int q;
                                int index = mord.route.getWaypoints().indexOf(mord.waypoint);
                                mord.route.instertWaypoint(index, waypoint);
                                Route newRoute = new Route(name, Route.ROUTE_TYPE.ROUTE);
                                for (q = index; q < mord.route.getWaypoints().size(); ++q) {
                                    newRoute.addWaypoint(mord.route.getWaypoint(q));
                                }
                                for (q = newRoute.getWaypoints().size() - 1; q > 0; --q) {
                                    mord.route.removeWaypoint(newRoute.getWaypoint(q));
                                }
                                MapObjects.this.Routes.add((MutableTreeNode)((Object)new RouteTree((MapComponent)newRoute)));
                                MapObjects.this.selectedMapDocument.addRoute(newRoute);
                                MapObjects.this.jTree.updateUI();
                            }
                        }
                    });
                    menu.add(item);
                    menu.show((Component)Main.map, mord.pos.x, mord.pos.y);
                }
            }
        }
    }

    protected class MouseOverRouteData {
        boolean found = false;
        Point pos;
        Point2D mapLocation;
        Route route;
        Waypoint waypoint;

        protected MouseOverRouteData() {
        }
    }
}

