/*
 * Decompiled with CFR 0.152.
 */
package jmap.Base.DataSources;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import jmap.Base.MapManager;
import jmap.Base.ZoomLevel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public abstract class ImageSource {
    private String copyrightNotice;
    private static boolean useProxy = false;
    private static String proxyPassword;

    public abstract Image getImage(Point2D var1, ZoomLevel var2);

    public String getCopyrightNotice() {
        return this.copyrightNotice;
    }

    public void setCopyrightNotice(String copyrightNotice) {
        this.copyrightNotice = copyrightNotice;
    }

    public boolean hasCopyrightNotice() {
        return !this.copyrightNotice.isEmpty();
    }

    public String toString(Point2D position) {
        return "(" + String.valueOf(position.getX()) + "," + String.valueOf(position.getY()) + ")";
    }

    public Point2D fromString(String s) {
        String[] strings = s.replace("(", "").replace(")", "").split(",");
        return new Point2D.Double(Double.parseDouble(strings[0]), Double.parseDouble(strings[1]));
    }

    public Point2D longLatToLocal(Point2D p) {
        return this.longLatToLocal(p.getX(), p.getY());
    }

    public abstract Point2D longLatToLocal(double var1, double var3);

    public abstract Point2D localToLongLat(Point2D var1);

    public abstract Point2D mapGoto(Point2D var1);

    public abstract Point2D mapGotoLatLong(Point2D var1);

    public ZoomLevel getZoomLevel(Element el) {
        NodeList nl = el.getElementsByTagName("imageSize");
        if (nl.getLength() != 1) {
            return null;
        }
        Point imgSize = new Point(Integer.parseInt(((Element)nl.item(0)).getAttribute("x")), Integer.parseInt(((Element)nl.item(0)).getAttribute("y")));
        nl = el.getElementsByTagName("mapSize");
        if (nl.getLength() != 1) {
            return null;
        }
        Point2D.Double mapSize = new Point2D.Double(Double.parseDouble(((Element)nl.item(0)).getAttribute("x")), Double.parseDouble(((Element)nl.item(0)).getAttribute("y")));
        String name = el.getAttribute("name");
        String dir = el.hasAttribute("folder") ? el.getAttribute("folder") : name;
        return new ZoomLevel(dir, name, mapSize, imgSize, this);
    }

    public String zoomLevelToXml(ZoomLevel zl) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("x", zl.getImgSize().x);
        attributeMap.put("y", zl.getImgSize().y);
        String content = MapManager.createXMLElenemt("imageSize", "", attributeMap);
        attributeMap.clear();
        attributeMap.put("x", zl.getMapSize().getX());
        attributeMap.put("y", zl.getMapSize().getY());
        content = content + MapManager.createXMLElenemt("mapSize", "", attributeMap);
        attributeMap.clear();
        attributeMap.put("name", zl.getName());
        attributeMap.put("folder", zl.getFolderName());
        return MapManager.createXMLElenemt("ZoomLevel", content, attributeMap);
    }

    public static void setProxy(String host, int port, String username, String password) {
        System.getProperties().put("proxySet", "true");
        System.getProperties().put("proxyHost", host);
        System.getProperties().put("proxyPort", String.valueOf(port));
        proxyPassword = username + ":" + password;
        useProxy = true;
    }

    public static void proxyOff() {
        useProxy = false;
    }

    public static InputStream downloadData(String url) throws MalformedURLException, ProtocolException, IOException {
        HttpURLConnection http = (HttpURLConnection)new URL(url).openConnection();
        if (useProxy) {
            http.setRequestProperty("Proxy-Authorization", "Basic " + new BASE64Encoder().encode(proxyPassword.getBytes()));
        }
        http.setRequestMethod("GET");
        http.connect();
        if (http.getResponseCode() != 200) {
            return null;
        }
        InputStream i = http.getInputStream();
        return i;
    }
}

