/*
 * Decompiled with CFR 0.152.
 */
package jmap.Base;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JarFile {
    final File jarFile;
    private Map<String, String> plugins = new HashMap<String, String>();
    private Map<String, String> imageSources = new HashMap<String, String>();
    private List<String> classes = new ArrayList<String>();

    public JarFile(File jarFile) throws MalformedURLException, SAXException, IOException, ParserConfigurationException {
        Element el;
        int q;
        this.jarFile = jarFile;
        if (!jarFile.exists()) {
            throw new FileNotFoundException("Cannot find jar file '" + jarFile + "'.");
        }
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{jarFile.toURI().toURL()}, this.getClass().getClassLoader());
        InputStream is = ((ClassLoader)loader).getResourceAsStream("Config.xml");
        if (is == null) {
            throw new IOException("Missing jar config file.");
        }
        Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is).getDocumentElement();
        NodeList nl = root.getElementsByTagName("ImageSource");
        for (q = 0; q < nl.getLength(); ++q) {
            el = (Element)nl.item(q);
            this.imageSources.put(el.getAttribute("name"), el.getAttribute("class"));
            this.classes.add(el.getAttribute("class"));
        }
        nl = root.getElementsByTagName("Plugin");
        for (q = 0; q < nl.getLength(); ++q) {
            el = (Element)nl.item(q);
            this.plugins.put(el.getAttribute("name"), el.getAttribute("class"));
            this.classes.add(el.getAttribute("class"));
        }
    }

    public String getPath() {
        return this.jarFile.getAbsolutePath();
    }

    public Map<String, String> getImageSources() {
        return this.imageSources;
    }

    public Map<String, String> getPlugins() {
        return this.plugins;
    }

    public boolean containsClass(String name) {
        return this.classes.contains(name);
    }

    public boolean containsImageSource(String name) {
        return this.getImageSources().containsKey(name);
    }

    public boolean containsPlugin(String name) {
        return this.getPlugins().containsKey(name);
    }

    public Object loadClass(String className) throws MalformedURLException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{this.jarFile.toURI().toURL()}, this.getClass().getClassLoader());
        Class<?> clazz = Class.forName(className, true, loader);
        Class<Object> runClass = clazz.asSubclass(Object.class);
        Constructor<Object> ctor = runClass.getConstructor(new Class[0]);
        return ctor.newInstance(new Object[0]);
    }

    public InputStream getResource(String path) throws MalformedURLException {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{this.jarFile.toURI().toURL()}, this.getClass().getClassLoader());
        return ((ClassLoader)loader).getResourceAsStream(path);
    }
}

