/*
 * Decompiled with CFR 0.152.
 */
package jmap.Base;

import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmap.Base.DataSources.ImageSource;
import jmap.Base.DataSources.Plugin;
import jmap.Base.JarFile;
import jmap.Base.MapComponent;
import jmap.Base.ZoomLevel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MapManager {
    private short version = 0;
    private final String directory;
    private final String path;
    private List<JarFile> jarFiles = new ArrayList<JarFile>();
    protected List<MapComponent> mapComponents = new ArrayList<MapComponent>();
    protected Point2D startLocation = new Point(0, 0);
    protected int startZoomlevel = 0;
    protected List<ZoomLevel> zoomLevels = new ArrayList<ZoomLevel>();
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public MapManager(String path) throws FileNotFoundException {
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException("Map file not found: " + path);
        }
        this.path = f.getAbsolutePath();
        this.directory = f.getParentFile().getAbsolutePath();
    }

    public void setupMapManager() throws ParserConfigurationException, SAXException, IOException, MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        File map = new File(this.getPath());
        if (!map.exists()) {
            throw new FileNotFoundException("Cannot find map config file.");
        }
        this.setupMapManager(new FileInputStream(map));
    }

    public void setupMapManager(InputStream map) throws ParserConfigurationException, SAXException, IOException, MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Element rootEl = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(map).getDocumentElement();
        if (rootEl.hasAttribute("version")) {
            this.version = Short.parseShort(rootEl.getAttribute("version"));
        }
        switch (this.version) {
            case 1: {
                this.setupV1(rootEl);
                break;
            }
            default: {
                throw new IOException("Map version not supported.");
            }
        }
    }

    private void setupV1(Element rootEl) throws IOException, NoSuchMethodException, IllegalArgumentException, SAXException, NumberFormatException, IllegalAccessException, ClassNotFoundException, InstantiationException, ParserConfigurationException, InvocationTargetException {
        Element el;
        int q;
        NodeList nl = rootEl.getElementsByTagName("JarFile");
        for (q = 0; q < nl.getLength(); ++q) {
            el = (Element)nl.item(q);
            if (!el.hasAttribute("path")) continue;
            this.addJarFile(new JarFile(new File(el.getAttribute("path"))));
        }
        nl = rootEl.getElementsByTagName("ImageSource");
        for (q = 0; q < nl.getLength(); ++q) {
            el = (Element)nl.item(q);
            if (el.hasAttribute("class")) {
                ImageSource is = el.hasAttribute("jarFile") ? (ImageSource)new JarFile(new File(el.getAttribute("jarFile"))).loadClass(el.getAttribute("class")) : (ImageSource)this.loadClass(el.getAttribute("class"));
                NodeList nl1 = el.getElementsByTagName("ZoomLevel");
                for (int w = 0; w < nl1.getLength(); ++w) {
                    Element e = (Element)nl1.item(w);
                    ZoomLevel zl = is.getZoomLevel(e);
                    zl.setIndex(w);
                    if (e.hasAttribute("copyrightNotice")) {
                        zl.setCopyrightNotice(e.getAttribute("copyrightNotice"));
                    }
                    this.addZoomLevel(zl);
                }
                if (!el.hasAttribute("copyrightNotice")) continue;
                is.setCopyrightNotice(el.getAttribute("copyrightNotice"));
                continue;
            }
            System.err.println("No class specified for ImageSource " + String.valueOf(q + 1));
        }
        if (this.getZoomLevels().isEmpty()) {
            throw new IOException("No zoom levels found.");
        }
        nl = rootEl.getElementsByTagName("Plugin");
        for (q = 0; q < nl.getLength(); ++q) {
            el = (Element)nl.item(q);
            Plugin p = el.hasAttribute("jarFile") ? (Plugin)new JarFile(new File(el.getAttribute("jarFile"))).loadClass(el.getAttribute("class")) : (Plugin)this.loadClass(el.getAttribute("class"));
            p.configure(el, this);
            this.addMapComponent(p);
        }
        nl = rootEl.getElementsByTagName("Start");
        if (nl.getLength() != 0) {
            Element el2 = (Element)nl.item(0);
            this.startLocation = new Point2D.Double(Double.parseDouble(el2.getAttribute("x")), Double.parseDouble(el2.getAttribute("y")));
            this.startZoomlevel = Integer.parseInt(el2.getAttribute("zoomLevel"));
        }
    }

    private Object loadClass(String className) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        for (JarFile file : this.getJarFiles()) {
            if (!file.containsClass(className)) continue;
            return file.loadClass(className);
        }
        return null;
    }

    public String copyFileToMapDirectory(File input, String directory) throws FileNotFoundException, IOException {
        String newFile = this.getDirectory() + directory + "/" + input.getName();
        File f = new File(newFile).getParentFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        Files.copy(input.toPath(), new FileOutputStream(newFile));
        return newFile;
    }

    public Image downloadTile(Point2D tileCentre, ZoomLevel zl) throws IOException {
        Image image = zl.getImageSource().getImage(tileCentre, zl);
        return this.saveTile(zl, tileCentre, image);
    }

    public Image saveTile(ZoomLevel zl, Point2D tileCentre, Image image) throws IOException {
        File f = new File(this.getDirectory() + "/" + zl.getFolderName() + "/" + String.valueOf(tileCentre.getX()) + "_" + String.valueOf(tileCentre.getY()) + "." + zl.getFileExtension());
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            System.out.println("Failed to make: " + f.getParent());
            return image;
        }
        try {
            if (image != null) {
                FileOutputStream out = new FileOutputStream(f);
                ImageIO.write((RenderedImage)((Object)image), zl.getFileExtension().toUpperCase(), out);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MapManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return image;
    }

    public void save() throws FileNotFoundException {
        switch (this.version) {
            case 1: {
                this.saveV1();
            }
        }
    }

    private void saveV1() throws FileNotFoundException {
        HashMap<String, Object> m;
        String content = "";
        for (JarFile jf : this.getJarFiles()) {
            m = new HashMap<String, Object>();
            m.put("path", jf.getPath());
            content = content + MapManager.createXMLElenemt("JarFile", "", m);
        }
        for (MapComponent mc : this.getMapComponents()) {
            content = content + mc.toXml();
        }
        ImageSource lastImageSource = this.getZoomLevels().get(0).getImageSource();
        String s = "";
        for (ZoomLevel zl : this.getZoomLevels()) {
            if (zl.getImageSource() != lastImageSource) {
                HashMap<String, Object> m2 = new HashMap<String, Object>();
                m2.put("class", lastImageSource.getClass().getName());
                if (lastImageSource.hasCopyrightNotice()) {
                    m2.put("copyrightNotice", lastImageSource.getCopyrightNotice());
                }
                content = content + MapManager.createXMLElenemt("ImageSource", s, m2);
                s = "";
                lastImageSource = zl.getImageSource();
            }
            s = s + zl.toXml();
        }
        m = new HashMap();
        m.put("class", lastImageSource.getClass().getName());
        if (lastImageSource.hasCopyrightNotice()) {
            m.put("copyrightNotice", lastImageSource.getCopyrightNotice());
        }
        content = content + MapManager.createXMLElenemt("ImageSource", s, m);
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("zoomLevel", this.getStartZoomLevel());
        attributeMap.put("x", this.getStart().getX());
        attributeMap.put("y", this.getStart().getY());
        content = content + MapManager.createXMLElenemt("Start", "", attributeMap);
        attributeMap.clear();
        attributeMap.put("version", this.version);
        String xml = XML_HEADER + MapManager.createXMLElenemt("JMap", content, attributeMap);
        try (PrintWriter pw = new PrintWriter(this.getPath());){
            pw.write(xml);
            pw.flush();
        }
    }

    public void setStart(int zoomLevel, Point2D location) {
        this.startZoomlevel = zoomLevel;
        this.startLocation = location;
    }

    public void addJarFile(JarFile jarFile) {
        if (jarFile != null) {
            this.getJarFiles().add(jarFile);
        }
    }

    public List<JarFile> getJarFiles() {
        return this.jarFiles;
    }

    public void addMapComponent(MapComponent mc) {
        if (mc != null) {
            this.getMapComponents().add(mc);
        }
    }

    public boolean removeMapComponent(MapComponent mc) {
        return this.getMapComponents().remove(mc);
    }

    public List<MapComponent> getMapComponents() {
        return this.mapComponents;
    }

    public void addZoomLevel(ZoomLevel zoomLevel) {
        if (zoomLevel != null) {
            this.getZoomLevels().add(zoomLevel);
        }
    }

    public boolean removeZoomLevel(ZoomLevel zoomLevel) {
        return this.getZoomLevels().remove(zoomLevel);
    }

    public List<ZoomLevel> getZoomLevels() {
        return this.zoomLevels;
    }

    public String getDirectory() {
        return this.directory + "/";
    }

    public Point2D getStart() {
        return this.startLocation;
    }

    public void setStart(Point2D start) {
        this.startLocation = start;
    }

    public ImageSource getImageSource(ZoomLevel zl) {
        return zl.getImageSource();
    }

    public int getStartZoomLevel() {
        return this.startZoomlevel;
    }

    public String getPath() {
        return this.path;
    }

    public static Point2D stringToPoint2D(String s) {
        String[] ss = s.split(",");
        return new Point2D.Double(Double.parseDouble(ss[0]), Double.parseDouble(ss[1]));
    }

    public static String point2DToString(Point2D p) {
        return String.valueOf(p.getX()) + "," + String.valueOf(p.getY());
    }

    public static void XmlOut(Node node, PrintWriter out) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                break;
            }
            case 1: {
                out.print('<' + node.getNodeName());
                NamedNodeMap nnm = node.getAttributes();
                if (nnm != null) {
                    int len = nnm.getLength();
                    for (int i = 0; i < len; ++i) {
                        Attr attr = (Attr)nnm.item(i);
                        out.print(' ' + attr.getNodeName() + "=\"" + attr.getNodeValue() + '\"');
                    }
                }
                out.print('>');
                break;
            }
            case 5: {
                out.print('&' + node.getNodeName() + ';');
                break;
            }
            case 4: {
                out.print("<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 3: {
                out.print(node.getNodeValue());
                break;
            }
            case 7: {
                out.print("<?" + node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            MapManager.XmlOut(child, out);
        }
        if (type == 1) {
            out.print("</" + node.getNodeName() + ">\n");
        }
        out.flush();
    }

    public static String createXMLElenemt(String name, Object content) {
        return MapManager.createXMLElenemt(name, content, null);
    }

    public static String createXMLElenemt(String name, Object content, Map<String, Object> attrabutes) {
        return MapManager.createXMLElenemt(name, String.valueOf(content), attrabutes);
    }

    public static String createXMLElenemt(String name, String content, Map<String, Object> attrabutes) {
        String s = "<" + name;
        if (attrabutes != null) {
            for (Map.Entry<String, Object> e : attrabutes.entrySet()) {
                s = s + " " + e.getKey() + "=\"" + String.valueOf(e.getValue()) + "\"";
            }
        }
        s = content.contains("<") ? s + ">\n" + String.valueOf(content) + "</" + name + ">\n" : s + ">" + String.valueOf(content) + "</" + name + ">\n";
        return s;
    }

    public static String createExtensionsElement(String content) {
        return MapManager.createXMLElenemt("extensions", MapManager.createXMLElenemt("jmap", content));
    }
}

