/*
 * Decompiled with CFR 0.152.
 */
package jmap.Base;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import jmap.Base.MapComponent;
import jmap.Base.MapManager;
import jmap.Base.Viewer;
import jmap.Base.ZoomLevel;

public class SaveImg
extends Thread {
    private Point2D exportStart;
    private Point2D exportFinish;
    private Point2D imageSize;
    private ZoomLevel zoomLevel;
    private MapManager mapManager;
    private String path;
    private boolean notify = true;
    private boolean online;

    public SaveImg(Point2D exportStart, Point2D exportFinish, Point2D imageSize, ZoomLevel zoomLevel, MapManager mapManager, String path, boolean online) {
        this.exportStart = new Point2D.Double(exportStart.getX() - zoomLevel.getMapSize().getX() / 2.0, exportStart.getY() - zoomLevel.getMapSize().getY() / 2.0);
        this.exportFinish = new Point2D.Double(exportFinish.getX() - zoomLevel.getMapSize().getX() / 2.0, exportFinish.getY() - zoomLevel.getMapSize().getY() / 2.0);
        this.imageSize = imageSize;
        this.zoomLevel = zoomLevel;
        this.mapManager = mapManager;
        this.path = path;
        this.online = online;
    }

    @Override
    public void run() {
        double imX = (double)this.zoomLevel.getImgSize().x / this.zoomLevel.getMapSize().getX();
        double imY = (double)this.zoomLevel.getImgSize().y / this.zoomLevel.getMapSize().getY();
        try {
            if (this.imageSize == null) {
                this.saveImage(this.exportStart, this.exportFinish);
            } else {
                for (double x = this.exportStart.getX(); x < this.exportFinish.getX(); x += this.imageSize.getX() * imX) {
                    for (double y = this.exportFinish.getY(); y < this.exportStart.getY(); y += this.imageSize.getY() * imY) {
                        this.saveImage(new Point2D.Double(x, y + this.imageSize.getY() * imY), new Point2D.Double(x + this.imageSize.getX() * imX, y));
                    }
                }
            }
        }
        catch (IOException ex) {
            if (this.notify) {
                JOptionPane.showMessageDialog(null, "Export to '" + this.path + "' unsuccessful\nError Message: " + ex.getMessage());
            }
            Logger.getLogger(SaveImg.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void saveImage(Point2D start, Point2D finish) throws FileNotFoundException, IOException {
        Point2D ss = this.toScreen(start);
        Point2D sf = this.toScreen(finish);
        BufferedImage image = new BufferedImage((int)(sf.getX() - ss.getX()), (int)(ss.getY() - sf.getY()), 1);
        Graphics g = image.getGraphics();
        int colms = image.getWidth() / this.zoomLevel.getImgSize().x + 3;
        int rows = image.getHeight() / this.zoomLevel.getImgSize().y + 2;
        Point2D.Double topleft_imgs = new Point2D.Double(this.exportStart.getX() - this.exportStart.getX() % this.zoomLevel.getMapSize().getX(), this.exportStart.getY() - this.exportStart.getY() % this.zoomLevel.getMapSize().getY());
        for (int q = 0; q < colms; ++q) {
            for (int w = -rows; w < rows; ++w) {
                Image img = this.getImage(((Point2D)topleft_imgs).getX() + (double)q * this.zoomLevel.getMapSize().getX(), ((Point2D)topleft_imgs).getY() + (double)w * this.zoomLevel.getMapSize().getY());
                if (img == null) continue;
                g.drawImage(img, (int)((double)(q * this.zoomLevel.getImgSize().x) - (this.exportStart.getX() - ((Point2D)topleft_imgs).getX()) * ((double)this.zoomLevel.getImgSize().x / this.zoomLevel.getMapSize().getX()) - (double)(this.zoomLevel.getImgSize().x / 2)), (int)((double)(-w * this.zoomLevel.getImgSize().y) + (this.exportStart.getY() - ((Point2D)topleft_imgs).getY()) * ((double)this.zoomLevel.getImgSize().y / this.zoomLevel.getMapSize().getY()) - (double)(this.zoomLevel.getImgSize().y / 2)), new ImageObserver(){

                    @Override
                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        return true;
                    }
                });
            }
        }
        for (MapComponent mc : this.mapManager.getMapComponents()) {
            mc.draw(g, new Point2D.Double(this.exportStart.getX(), this.exportFinish.getY()), image.getHeight(), (double)this.zoomLevel.getImgSize().x / this.zoomLevel.getMapSize().getX(), (double)this.zoomLevel.getImgSize().y / this.zoomLevel.getMapSize().getY(), this.zoomLevel);
        }
        String copyrightNotice = "";
        if (this.zoomLevel.hasCopyrightNotice()) {
            copyrightNotice = this.zoomLevel.getCopyrightNotice();
        }
        if (this.zoomLevel.getImageSource().hasCopyrightNotice()) {
            copyrightNotice = this.zoomLevel.getImageSource().getCopyrightNotice();
        }
        if (!copyrightNotice.isEmpty()) {
            FontMetrics fm = g.getFontMetrics();
            int height = fm.getHeight();
            int curX = 10;
            int y = image.getHeight() - 5 - fm.getHeight();
            ArrayList<String> strings = new ArrayList<String>();
            String s = "";
            for (String w : copyrightNotice.split(" ")) {
                int stringWidth = fm.stringWidth(s + w + " ");
                if (stringWidth >= image.getWidth() - 20) {
                    strings.add(s);
                    s = "";
                    y -= fm.getHeight();
                    height += fm.getHeight();
                }
                s = s + w + " ";
            }
            strings.add(s);
            int width = image.getWidth() - 20;
            if (strings.size() == 1) {
                width = fm.stringWidth((String)strings.get(0));
            }
            Color old = g.getColor();
            g.setColor(Color.WHITE);
            g.fillRect(10, y, width, height);
            g.setColor(Color.BLACK);
            y += fm.getHeight();
            for (String l : strings) {
                g.drawString(l, 10, y);
                y += fm.getHeight();
            }
            g.setColor(old);
        }
        FileOutputStream out = new FileOutputStream(new File(this.path));
        ImageIO.write((RenderedImage)image, "PNG", out);
        if (this.notify) {
            JOptionPane.showMessageDialog(null, "Export to '" + this.path + "' successful");
        }
    }

    private Point2D toScreen(Point2D p) {
        return new Point2D.Double(p.getX() * (double)this.zoomLevel.getImgSize().x / this.zoomLevel.getMapSize().getX(), p.getY() * (double)this.zoomLevel.getImgSize().y / this.zoomLevel.getMapSize().getY());
    }

    public Image getImage(double x, double y) {
        Image img = null;
        File f = new File(this.mapManager.getDirectory() + "/" + this.zoomLevel.getFolderName() + "/" + String.valueOf(x) + "_" + String.valueOf(y) + ".png");
        if (f.exists()) {
            try {
                img = ImageIO.read(f);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, "File '" + f.getAbsolutePath() + "' not found", ex);
            }
            catch (IOException ex) {
                f.delete();
                Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, "Error loading '" + f.getAbsolutePath() + "'", ex);
            }
        } else if (this.online) {
            try {
                img = this.mapManager.downloadTile(new Point2D.Double(x, y), this.zoomLevel);
            }
            catch (IOException ex) {
                Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return img;
    }
}

