/*
 * Decompiled with CFR 0.152.
 */
package jmap.Base;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import jmap.Base.MapComponent;
import jmap.Base.MapManager;
import jmap.Base.PaintListener;
import jmap.Base.ZoomLevel;

public class Viewer
extends JComponent {
    protected boolean online = false;
    protected Point2D mapPos = new Point2D.Double(0.0, 0.0);
    private MapManager mapManager;
    private Map<Point2D, MapImage> imageMap = Collections.synchronizedMap(new HashMap());
    protected double scale = 1.0;
    protected int zoomlevel = 0;
    ArrayList<PaintListener> paintListeners = new ArrayList();
    private ThreadPoolExecutor execSvc = (ThreadPoolExecutor)Executors.newFixedThreadPool(8);

    public void setMapManager(MapManager mapManager) {
        this.mapManager = mapManager;
        if (mapManager != null) {
            this.setMapPos(mapManager.getStart());
            this.setZoomLevel(mapManager.getStartZoomLevel());
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setZoomLevel(int zoomLevel) {
        if (zoomLevel >= 0 && zoomLevel < this.mapManager.getZoomLevels().size()) {
            this.zoomlevel = zoomLevel;
        }
        this.setScale(1.0);
        this.clearImageBuffer();
        for (Runnable r : this.execSvc.getQueue()) {
            this.execSvc.remove(r);
        }
        this.repaint();
    }

    public ZoomLevel getZoomLevel() {
        return this.mapManager.getZoomLevels().get(this.zoomlevel);
    }

    public void zoomIn() {
        this.setZoomLevel(this.zoomlevel + 1);
    }

    public void zoomOut() {
        this.setZoomLevel(this.zoomlevel - 1);
    }

    public Point2D getMapSize() {
        return this.getZoomLevel().getMapSize();
    }

    public Point getImgSize() {
        Point p = this.getZoomLevel().getImgSize();
        return new Point((int)(this.scale * p.getX()), (int)(this.scale * p.getY()));
    }

    public double getMaptoImgX() {
        return (double)this.getImgSize().x / this.getMapSize().getX();
    }

    public double getMaptoImgY() {
        return (double)this.getImgSize().y / this.getMapSize().getY();
    }

    public double getImgtoMapX() {
        return this.getMapSize().getX() / (double)this.getImgSize().x;
    }

    public double getImgtoMapY() {
        return this.getMapSize().getY() / (double)this.getImgSize().y;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void deleteShownImages() {
        if (this.getZoomLevel().canDownloadData()) {
            Point i = this.getImgSize();
            Point2D m = this.getMapSize();
            int width = (int)(((double)this.getWidth() / ((Point2D)i).getX() + 2.0) * ((Point2D)i).getX());
            int height = (int)(((double)this.getHeight() / ((Point2D)i).getY() + 2.0) * ((Point2D)i).getY());
            int colms = (int)((double)width / ((Point2D)i).getX());
            int rows = (int)((double)height / ((Point2D)i).getY());
            Point2D.Double screenTopLeft = new Point2D.Double(this.mapPos.getX() - (double)((this.getWidth() - this.getImgSize().x) / 2) * this.getImgtoMapX(), this.mapPos.getY() + (double)((this.getHeight() - this.getImgSize().y) / 2) * this.getImgtoMapY());
            Point2D.Double topleft_imgs = new Point2D.Double((double)((int)(((Point2D)screenTopLeft).getX() / m.getX())) * m.getX(), (double)((int)(((Point2D)screenTopLeft).getY() / m.getY())) * m.getY());
            for (int q = 0; q < colms; ++q) {
                for (int w = 0; w < rows; ++w) {
                    new File(this.getMapManager().getDirectory() + "/" + this.getZoomLevel().getFolderName() + "/" + String.valueOf(((Point2D)topleft_imgs).getX() + (double)q * m.getX()) + "_" + String.valueOf(((Point2D)topleft_imgs).getY() + (double)w * m.getY()) + ".png").delete();
                }
            }
        }
        this.clearImageBuffer();
        this.repaint();
    }

    public String getCopyrightNotice() {
        if (this.getZoomLevel().hasCopyrightNotice()) {
            return this.getZoomLevel().getCopyrightNotice();
        }
        if (this.getZoomLevel().getImageSource().hasCopyrightNotice()) {
            return this.getZoomLevel().getImageSource().getCopyrightNotice();
        }
        return "";
    }

    public void clearImageBuffer() {
        this.imageMap.clear();
    }

    public Point2D getTopLeft() {
        return new Point2D.Double(this.mapPos.getX() - (double)(this.getWidth() / 2) * this.getImgtoMapX(), this.mapPos.getY() - (double)this.getHeight() / (2.0 * this.getMaptoImgY()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getMapManager() == null) {
            return;
        }
        Point i = this.getImgSize();
        Point2D m = this.getMapSize();
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        Point2D.Double screenTopLeft = new Point2D.Double(this.mapPos.getX() - ((double)((this.getWidth() - i.x) / 2) * this.getImgtoMapX() + this.getZoomLevel().getMapSize().getX() / 2.0), this.mapPos.getY() + ((double)((this.getHeight() - i.y) / 2) * this.getImgtoMapY() - this.getZoomLevel().getMapSize().getY() / 2.0));
        Point2D.Double mapOffset = new Point2D.Double(-((Point2D)screenTopLeft).getX() % m.getX(), -m.getY() + ((Point2D)screenTopLeft).getY() % m.getY());
        for (int x = 0; x < this.getWidth() / i.x + 2; ++x) {
            for (int y = 0; y < this.getHeight() / i.y + 2; ++y) {
                Point2D.Double p = new Point2D.Double(((Point2D)screenTopLeft).getX() + ((Point2D)mapOffset).getX() + (double)x * m.getX(), ((Point2D)screenTopLeft).getY() - ((Point2D)mapOffset).getY() - (double)y * m.getY());
                if (!this.imageMap.containsKey(p)) {
                    MapImage image = new MapImage(p);
                    image.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Viewer.this.repaint();
                        }
                    });
                    image.start();
                    this.imageMap.put(p, image);
                }
                g.drawImage(this.imageMap.get(p).getImage(), x * i.x + (int)(((Point2D)mapOffset).getX() * this.getMaptoImgX()), y * i.y + (int)(((Point2D)mapOffset).getY() * this.getMaptoImgY()), this);
            }
        }
        for (MapComponent mc : this.getMapManager().getMapComponents()) {
            mc.draw(g, this.getTopLeft(), this.getHeight(), this.getMaptoImgX(), this.getMaptoImgY(), this.getZoomLevel());
        }
        this.firePaintEvent(g);
    }

    public void setMapPos(double x, double y) {
        this.setMapPos(new Point2D.Double(x, y));
    }

    public void setMapPos(Point2D p) {
        this.mapPos = (Point2D)p.clone();
        this.repaint();
    }

    public Point2D getMapPos() {
        return this.mapPos;
    }

    public void scroll(double x, double y) {
        if (x == 0.0 && y == 0.0 || this.getMapManager() == null) {
            return;
        }
        this.mapPos.setLocation(this.mapPos.getX() - x * this.getImgtoMapX(), this.mapPos.getY() + y * this.getImgtoMapY());
        this.repaint();
    }

    public void addPaintListener(PaintListener listener) {
        this.paintListeners.add(listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.paintListeners.remove(listener);
    }

    protected void firePaintEvent(Graphics g) {
        for (PaintListener pl : this.paintListeners) {
            pl.paint(g);
        }
    }

    public MapManager getMapManager() {
        return this.mapManager;
    }

    public class MapImage
    implements Runnable {
        private Image image;
        private Point2D position;
        private Thread thread = new Thread(this);
        private ArrayList<ActionListener> listeners = new ArrayList();

        public MapImage(Point2D position) {
            this.position = position;
            Point i = Viewer.this.getImgSize();
            this.image = Viewer.this.createImage(i.x, i.y);
            this.image.getGraphics().fillRect(0, 0, i.x, i.y);
        }

        public void start() {
            this.thread.start();
        }

        public Image getImage() {
            if (Viewer.this.getScale() != 1.0) {
                try {
                    BufferedImage i = (BufferedImage)this.image;
                    return i.getScaledInstance((int)((double)i.getWidth() * Viewer.this.getScale()), (int)((double)i.getHeight() * Viewer.this.getScale()), 2);
                }
                catch (Exception ex) {
                    Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return this.image;
        }

        @Override
        public void run() {
            File f = new File(Viewer.this.getMapManager().getDirectory() + "/" + Viewer.this.getZoomLevel().getFolderName() + "/" + String.valueOf(this.position.getX()) + "_" + String.valueOf(this.position.getY()) + "." + Viewer.this.getZoomLevel().getFileExtension());
            if (f.exists()) {
                try {
                    this.image = ImageIO.read(f);
                    this.returnImage();
                }
                catch (FileNotFoundException ex) {
                    Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, "File '" + f.getAbsolutePath() + "' not found", ex);
                }
                catch (Exception ex) {
                    f.delete();
                    Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, "Error loading '" + f.getAbsolutePath() + "'", ex);
                }
            } else if (Viewer.this.online) {
                Viewer.this.execSvc.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MapImage.this.image = Viewer.this.getMapManager().downloadTile(MapImage.this.position, Viewer.this.getZoomLevel());
                            MapImage.this.returnImage();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Viewer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
        }

        private void returnImage() {
            if (this.image == null) {
                Point i = Viewer.this.getImgSize();
                this.image = Viewer.this.createImage(i.x, i.y);
                this.image.getGraphics().fillRect(0, 0, i.x, i.y);
            }
            this.fireActionEvent(0);
        }

        public void addActionListener(ActionListener listener) {
            this.listeners.add(listener);
        }

        public void removeActionListener(ActionListener listener) {
            this.listeners.remove(listener);
        }

        public void fireActionEvent(int type) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).actionPerformed(new ActionEvent(this, type, ""));
            }
        }
    }
}

