/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.GeoData;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jmap.Base.MapManager;
import jmap.DataSources.GeoData.Route;
import jmap.DataSources.GeoData.Waypoint;

public abstract class Document {
    protected String uri;
    private Collection<Waypoint> waypoints = new ArrayList<Waypoint>();
    private Collection<Route> routes = new ArrayList<Route>();
    private Collection<Route> tracks = new ArrayList<Route>();

    public Document(String file) {
        this.uri = file;
    }

    public String getFile() {
        return this.uri;
    }

    public void setFile(String file) {
        this.uri = file;
    }

    public void addRoute(Route route) {
        this.routes.add(route);
    }

    public void addTrack(Route track) {
        this.tracks.add(track);
    }

    public void addWaypoint(Waypoint waypoint) {
        this.getWaypoints().add(waypoint);
    }

    public void removeRoute(Route route) {
        this.routes.remove(route);
    }

    public void removeTrack(Route track) {
        this.tracks.remove(track);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.waypoints.remove(waypoint);
    }

    public void setWaypoints(Collection<Waypoint> waypoints) {
        this.waypoints = waypoints;
    }

    public void setRoutes(Collection<Route> routes) {
        this.routes = routes;
    }

    public void setTracks(Collection<Route> tracks) {
        this.tracks = tracks;
    }

    public Collection<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public Collection<Route> getRoutes() {
        return this.routes;
    }

    public Collection<Route> getTracks() {
        return this.tracks;
    }

    public abstract void parseDocument(MapManager var1);

    public abstract void write() throws IOException;
}

