/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.GeoData;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jmap.Base.MapManager;
import jmap.DataSources.GeoData.Document;
import jmap.DataSources.GeoData.Route;
import jmap.DataSources.GeoData.Waypoint;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GPXDocument
extends Document {
    public static String GPX_VERSION = "1.1";

    public GPXDocument(String uri) {
        super(uri);
    }

    @Override
    public void write() throws FileNotFoundException {
        String content = "";
        for (Waypoint w : this.getWaypoints()) {
            content = content + this.WaypointXml(w, "wpt");
        }
        for (Route r : this.getRoutes()) {
            content = content + this.RouteXml(r);
        }
        for (Route t : this.getTracks()) {
            content = content + this.RouteXml(t);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("version", GPX_VERSION);
        m.put("creator", "jmap - jmaps.sourceforge.net");
        m.put("xmlns", "http://www.topografix.com/GPX/1/1");
        m.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        m.put("xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + MapManager.createXMLElenemt("gpx", content, m);
        try (PrintWriter pw = new PrintWriter(this.uri);){
            pw.write(xml);
            pw.flush();
        }
    }

    private String WaypointXml(Waypoint w, String type) {
        String s = "";
        if (w.getName() != null) {
            s = s + MapManager.createXMLElenemt("name", w.getName());
        }
        if (w.getComment() != null) {
            s = s + MapManager.createXMLElenemt("cmt", w.getComment());
        }
        for (Map.Entry<String, List<String>> e : w.getProperties().entrySet()) {
            String name = e.getKey();
            for (String p : e.getValue()) {
                s = s + MapManager.createXMLElenemt(name, p);
            }
        }
        s = s + MapManager.createExtensionsElement(MapManager.createXMLElenemt("colour", w.getColour().getRGB()));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("lon", String.valueOf(w.getPosition().getX()));
        m.put("lat", String.valueOf(w.getPosition().getY()));
        return MapManager.createXMLElenemt(type, s, m);
    }

    private String RouteXml(Route r) {
        String s = "";
        if (r.getName() != null) {
            s = s + MapManager.createXMLElenemt("name", r.getName());
        }
        if (r.getComment() != null) {
            s = s + MapManager.createXMLElenemt("cmt", r.getComment());
        }
        s = s + MapManager.createExtensionsElement(MapManager.createXMLElenemt("colour", r.getColour().getRGB()));
        String type = "";
        if (r.getRouteType().equals((Object)Route.ROUTE_TYPE.ROUTE)) {
            for (Waypoint waypoint : r.getWaypoints()) {
                s = s + this.WaypointXml(waypoint, "rtept");
            }
            type = "rte";
        } else if (r.getRouteType().equals((Object)Route.ROUTE_TYPE.TRACK)) {
            String s1 = "";
            for (Waypoint waypoint : r.getWaypoints()) {
                s1 = s1 + this.WaypointXml(waypoint, "trkpt");
            }
            s = s + MapManager.createXMLElenemt("trkseg", s1);
            type = "trk";
        }
        return MapManager.createXMLElenemt(type, s);
    }

    @Override
    public void parseDocument(MapManager mapManager) {
        try {
            int q;
            org.w3c.dom.Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(this.uri));
            Element el = doc.getDocumentElement();
            NodeList nl = el.getElementsByTagName("wpt");
            for (q = 0; q < nl.getLength(); ++q) {
                this.addWaypoint(this.parseWaypoint((Element)nl.item(q)));
            }
            nl = el.getElementsByTagName("rte");
            for (q = 0; q < nl.getLength(); ++q) {
                this.addRoute(this.parseRoute((Element)nl.item(q)));
            }
            nl = el.getElementsByTagName("trk");
            for (q = 0; q < nl.getLength(); ++q) {
                this.addTrack(this.parseRoute((Element)nl.item(q)));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(GPXDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Route parseRoute(Element el) {
        Route r = null;
        if (el.getTagName().equals("rte")) {
            r = new Route(Route.ROUTE_TYPE.ROUTE);
        } else if (el.getTagName().equals("trk")) {
            r = new Route(Route.ROUTE_TYPE.TRACK);
        }
        NodeList nl = el.getElementsByTagName("name");
        if (nl.getLength() > 0) {
            r.setName(nl.item(0).getTextContent());
        }
        if ((nl = el.getElementsByTagName("cmt")).getLength() > 0) {
            r.setComment(nl.item(0).getTextContent());
        }
        nl = null;
        if (r.getRouteType().equals((Object)Route.ROUTE_TYPE.ROUTE)) {
            nl = el.getElementsByTagName("rtept");
        } else if (r.getRouteType().equals((Object)Route.ROUTE_TYPE.TRACK)) {
            nl = el.getElementsByTagName("trkpt");
        }
        for (int q = 0; q < nl.getLength(); ++q) {
            Element element = (Element)nl.item(q);
            if (element.hasAttribute("lat") && element.getAttribute("lat").trim().isEmpty() || element.hasAttribute("lon") && element.getAttribute("lon").trim().isEmpty()) continue;
            r.addWaypoint(this.parseWaypoint(element));
        }
        return r;
    }

    private Waypoint parseWaypoint(Element el) {
        Waypoint w = new Waypoint();
        NodeList nl = el.getChildNodes();
        block8: for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element e = (Element)nl.item(i);
            switch (e.getTagName()) {
                case "name": {
                    w.setName(e.getTextContent());
                    continue block8;
                }
                case "cmt": {
                    w.setComment(e.getTextContent());
                    continue block8;
                }
                default: {
                    w.setProperty(e.getTagName(), e.getTextContent(), false);
                }
            }
        }
        w.setPosition(Float.parseFloat(el.getAttribute("lon")), Float.parseFloat(el.getAttribute("lat")));
        return w;
    }
}

