/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.GeoData;

import de.micromata.opengis.kml.v_2_2_0.Coordinate;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.LineString;
import de.micromata.opengis.kml.v_2_2_0.MultiGeometry;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Point;
import java.io.File;
import java.io.IOException;
import jmap.Base.MapManager;
import jmap.DataSources.GeoData.Document;
import jmap.DataSources.GeoData.Route;
import jmap.DataSources.GeoData.Waypoint;

public class KMLDocument
extends Document {
    public KMLDocument(String uri) {
        super(uri);
    }

    @Override
    public void parseDocument(MapManager mapManager) {
        Kml kml = Kml.unmarshal((File)new File(this.uri));
        this.recurse(kml.getFeature(), mapManager);
    }

    @Override
    public void write() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void recurse(Feature f, MapManager mapManager) {
        if (f.getClass().equals(de.micromata.opengis.kml.v_2_2_0.Document.class)) {
            for (Feature f1 : ((de.micromata.opengis.kml.v_2_2_0.Document)f).getFeature()) {
                this.recurse(f1, mapManager);
            }
        }
        if (f.getClass().equals(Folder.class)) {
            for (Feature f1 : ((Folder)f).getFeature()) {
                this.recurse(f1, mapManager);
            }
        }
        if (f.getClass().equals(Placemark.class)) {
            this.checkGeomerty(((Placemark)f).getGeometry(), (Placemark)f, mapManager);
        }
    }

    private void checkGeomerty(Geometry g, Placemark p, MapManager mapManager) {
        if (g.getClass().equals(MultiGeometry.class)) {
            for (Geometry g1 : ((MultiGeometry)p.getGeometry()).getGeometry()) {
                this.checkGeomerty(g1, p, mapManager);
            }
        }
        if (g.getClass().equals(LineString.class)) {
            Route r = new Route(p.getName(), Route.ROUTE_TYPE.ROUTE);
            r.setComment(p.getDescription());
            for (Coordinate c : ((LineString)g).getCoordinates()) {
                Waypoint wp = new Waypoint();
                wp.setPosition(c.getLongitude(), c.getLatitude());
                r.addWaypoint(wp);
            }
            this.addRoute(r);
        } else if (g.getClass().equals(Point.class)) {
            Waypoint wp = new Waypoint();
            wp.setName(p.getName());
            wp.setComment(p.getDescription());
            Coordinate c = (Coordinate)((Point)g).getCoordinates().get(0);
            wp.setPosition(c.getLongitude(), c.getLongitude());
            this.addWaypoint(wp);
        }
    }
}

