/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.GeoData;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import jmap.Base.MapComponent;
import jmap.Base.ZoomLevel;
import jmap.DataSources.GeoData.Waypoint;

public class Route
extends MapComponent {
    protected String comment;
    protected Color colour = null;
    public boolean drawEndPoint = true;
    protected ArrayList<Waypoint> waypoints = new ArrayList();
    protected final ROUTE_TYPE type;

    public Route(ROUTE_TYPE type) {
        this.type = type;
    }

    public Route(String name, ROUTE_TYPE type) {
        this.type = type;
        this.name = name;
    }

    @Override
    public void draw(Graphics g, Point2D topLeft, int bottem, double xRatio, double yRatio, ZoomLevel zl) {
        Color old = g.getColor();
        g.setColor(this.getColour());
        Point last = null;
        Iterator<Waypoint> it = this.getWaypoints().iterator();
        while (it.hasNext()) {
            Waypoint wp = it.next();
            if (last == null || !it.hasNext() && this.drawEndPoint) {
                wp.draw(g, topLeft, bottem, xRatio, yRatio, zl);
            }
            Point p = wp.toScreenCoords(topLeft, xRatio, yRatio, zl);
            if (last != null) {
                g.drawLine(p.x, bottem - p.y, last.x, bottem - last.y);
            }
            last = p;
            if ((wp.getName() == null || wp.getName().trim().equals("")) && (wp.getComment() == null || wp.getComment().trim().equals(""))) continue;
            wp.draw(g, topLeft, bottem, xRatio, yRatio, zl);
        }
        g.setColor(old);
    }

    public int getRouteLength(ZoomLevel zl) {
        int tot = 0;
        Point2D lastP = zl.getImageSource().longLatToLocal(this.getWaypoint(0).getPosition());
        for (Waypoint wp : this.getWaypoints()) {
            Point2D p = zl.getImageSource().longLatToLocal(wp.getPosition());
            tot = (int)((double)tot + Math.sqrt(p.distanceSq(lastP)));
            lastP = p;
        }
        return tot;
    }

    public void addOffset(Point2D offset) {
        for (Waypoint wp : this.getWaypoints()) {
            Point2D p = wp.getPosition();
            wp.setPosition(p.getX() + offset.getX(), p.getY() + offset.getY());
        }
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public Waypoint getWaypoint(int i) {
        if (i < 0 || i > this.getWaypoints().size() || this.getWaypoints().isEmpty()) {
            return null;
        }
        return this.getWaypoints().get(i);
    }

    public void addWaypoint(Waypoint p) {
        this.getWaypoints().add(p);
    }

    public void removeWaypoint(Waypoint p) {
        this.getWaypoints().remove(p);
    }

    public void instertWaypoint(int index, Waypoint p) {
        this.waypoints.add(index, p);
    }

    public void setColour(Color c) {
        this.colour = c;
    }

    public final Color getColour() {
        this.colour = Color.RED;
        return this.colour;
    }

    public boolean isEmpty() {
        return this.getWaypoints().isEmpty();
    }

    public ROUTE_TYPE getRouteType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isDrawEndPoint() {
        return this.drawEndPoint;
    }

    public void setDrawEndPoint(boolean drawEndPoint) {
        this.drawEndPoint = drawEndPoint;
    }

    public static enum ROUTE_TYPE {
        ROUTE,
        TRACK;

    }
}

