/*
 * Decompiled with CFR 0.152.
 */
package jmap.DataSources.GeoData;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jmap.Base.MapComponent;
import jmap.Base.ZoomLevel;

public class Waypoint
extends MapComponent {
    protected String comment;
    public boolean configVisible = false;
    protected Color colour = Color.RED;
    protected Point2D position;
    protected Map<String, List<String>> properties = new HashMap<String, List<String>>();

    public Waypoint() {
    }

    public Waypoint(Point2D p) {
        this.setPosition(p);
    }

    public Waypoint(double x, double y) {
        this.setPosition(x, y);
    }

    @Override
    public void draw(Graphics g, Point2D topLeft, int bottem, double xRatio, double yRatio, ZoomLevel zl) {
        Color c = g.getColor();
        g.setColor(this.getColour());
        Point p = this.toScreenCoords(topLeft, xRatio, yRatio, zl);
        g.fillOval((int)((Point2D)p).getX() - 5, bottem - (int)((Point2D)p).getY() - 5, 10, 10);
        g.setColor(Color.BLACK);
        g.drawOval((int)((Point2D)p).getX() - 5, bottem - (int)((Point2D)p).getY() - 5, 10, 10);
        g.setColor(c);
        String s = this.getName();
        if (s != null) {
            g.drawString(s, (int)((Point2D)p).getX(), bottem - (int)((Point2D)p).getY());
        }
    }

    public final void setPosition(double x, double y) {
        this.setPosition(new Point2D.Double(x, y));
    }

    public final void setPosition(Point2D p) {
        this.position = p;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public Point toScreenCoords(Point2D topLeft, double xRatio, double yRatio, ZoomLevel zl) {
        return Waypoint.toScreenCoords(topLeft, zl.getImageSource().longLatToLocal(this.getPosition()), xRatio, yRatio);
    }

    public static Point toScreenCoords(Point2D topLeft, Point2D p, double xRatio, double yRatio) {
        try {
            return new Point((int)((p.getX() - topLeft.getX()) * xRatio), (int)((p.getY() - topLeft.getY()) * yRatio));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Map<String, List<String>> getProperties() {
        return this.properties;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public void setProperty(String name, String value, boolean replace) {
        List<String> list;
        if (replace || !this.properties.containsKey(name)) {
            list = new ArrayList<String>();
        } else {
            list = this.properties.get(name);
            if (list == null) {
                list = new ArrayList();
            }
        }
        list.add(value);
        this.properties.put(name, list);
    }

    public List<String> getPropertyValues(String name) {
        if (!this.properties.containsKey(name)) {
            return null;
        }
        return this.properties.get(name);
    }

    public String getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            return null;
        }
        return this.properties.get(name).get(0);
    }
}

