/*
 * Decompiled with CFR 0.152.
 */
package jmap.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import jmap.Base.DataSources.Plugin;
import jmap.Base.JarFile;
import jmap.Base.MapComponent;
import jmap.Base.MapManager;
import jmap.Base.PaintListener;
import jmap.Base.SaveImg;
import jmap.Base.Viewer;
import jmap.Base.ZoomLevel;
import jmap.DataSources.GeoData.Waypoint;
import jmap.gui.VerticalToggleButton;
import org.xml.sax.SAXException;

public class Main
extends JFrame
implements Runnable {
    public static Viewer map = new Viewer();
    private Thread t = new Thread(this);
    private final Preferences preferences = Preferences.userNodeForPackage(Main.class);
    private Point lastMousePosition = null;
    private Point mouseCaughtPostition = null;
    PaintListener paintListener = new PaintListener(){

        @Override
        public void paint(Graphics g) {
            Color old;
            if (Main.this.mouseCaughtPostition != null) {
                g.setColor(Color.ORANGE);
                g.fillOval(((Main)Main.this).mouseCaughtPostition.x, ((Main)Main.this).mouseCaughtPostition.y, 5, 5);
                g.setColor(Color.BLACK);
                g.drawOval(((Main)Main.this).mouseCaughtPostition.x, ((Main)Main.this).mouseCaughtPostition.y, 6, 6);
            }
            Point pS = null;
            Point pF = null;
            if (Main.this.exportStart != null) {
                old = g.getColor();
                g.setColor(Color.WHITE);
                pS = Waypoint.toScreenCoords(map.getTopLeft(), Main.this.exportStart, map.getMaptoImgX(), map.getMaptoImgY());
                g.fillOval((int)((Point2D)pS).getX() - 4, (int)((double)map.getHeight() - ((Point2D)pS).getY() - 4.0), 8, 8);
                g.setColor(Color.BLACK);
                g.drawOval((int)((Point2D)pS).getX() - 4, (int)((double)map.getHeight() - ((Point2D)pS).getY() - 4.0), 8, 8);
                g.setColor(old);
            }
            if (Main.this.exportFinish != null) {
                old = g.getColor();
                g.setColor(Color.WHITE);
                pF = Waypoint.toScreenCoords(map.getTopLeft(), Main.this.exportFinish, map.getMaptoImgX(), map.getMaptoImgY());
                g.fillOval((int)((Point2D)pF).getX() - 4, (int)((double)map.getHeight() - ((Point2D)pF).getY() - 4.0), 8, 8);
                g.setColor(Color.BLACK);
                g.drawOval((int)((Point2D)pF).getX() - 4, (int)((double)map.getHeight() - ((Point2D)pF).getY() - 4.0), 8, 8);
                g.setColor(old);
            }
            if (pS != null && pF != null) {
                old = g.getColor();
                g.setColor(Color.BLACK);
                g.drawRect((int)((Point2D)pS).getX(), (int)((double)map.getHeight() - ((Point2D)pS).getY()), (int)(((Point2D)pF).getX() - ((Point2D)pS).getX()), (int)(((Point2D)pS).getY() - ((Point2D)pF).getY()));
                g.setColor(old);
            }
        }
    };
    public Point2D exportStart = null;
    public Point2D exportFinish = null;
    private boolean copyMap = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JDialog copyMapsDialog;
    private JCheckBoxMenuItem isOnlineJCheckBoxMenuItem;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem12;
    private JMenuItem jMenuItem13;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;
    private JPanel mapPanel;
    private JCheckBoxMenuItem startFromLastLocationCheckBoxMenuItem;

    public Main(String[] args) {
        String mapFile;
        this.initComponents();
        this.mapPanel.add(map);
        map.setSize(this.mapPanel.getWidth(), this.mapPanel.getHeight());
        map.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = e.getLocationOnScreen();
                Point offset = new Point(p.x - ((Main)Main.this).lastMousePosition.x, p.y - ((Main)Main.this).lastMousePosition.y);
                map.scroll(offset.x, offset.y);
                Point p2 = e.getPoint();
                if (p2.x < 5) {
                    p.x = Main.map.getLocationOnScreen().x + map.getWidth() - 10;
                }
                if (p2.x > map.getWidth() - 5) {
                    p.x = Main.map.getLocationOnScreen().x + 10;
                }
                if (p2.y < 5) {
                    p.y = Main.map.getLocationOnScreen().y + map.getHeight() - 10;
                }
                if (p2.y > map.getHeight() - 5) {
                    p.y = Main.map.getLocationOnScreen().y + 10;
                }
                try {
                    new Robot().mouseMove(p.x, p.y);
                }
                catch (AWTException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                Main.this.lastMousePosition = p;
            }
        });
        map.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Main.this.mouseCaughtPostition = null;
                Main.this.repaint();
                Main.this.lastMousePosition = e.getLocationOnScreen();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 2) {
                    Main.this.mouseCaughtPostition = e.getPoint();
                    Main.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Main.this.lastMousePosition = null;
            }
        });
        map.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Point p = e.getPoint();
                double xM = ((Point2D)p).getX() - (double)(map.getWidth() / 2);
                double yM = (double)(map.getHeight() / 2) - ((Point2D)p).getY();
                double xP = xM * map.getImgtoMapX() + map.getMapPos().getX();
                double yP = yM * map.getImgtoMapY() + map.getMapPos().getY();
                if (e.getWheelRotation() != 0) {
                    if (e.isControlDown()) {
                        if (e.getWheelRotation() > 0) {
                            if (map.getScale() > 1.0 && e.getWheelRotation() > 0) {
                                map.setScale(map.getScale() / 2.0);
                            } else {
                                map.setScale(map.getScale() / 1.1);
                            }
                        } else if (map.getScale() < 1.0) {
                            map.setScale(map.getScale() * 1.1);
                        } else {
                            map.setScale(map.getScale() * 2.0);
                        }
                    } else if (e.getWheelRotation() < 0) {
                        map.zoomIn();
                    } else {
                        map.zoomOut();
                    }
                    map.setMapPos(xP - xM * map.getImgtoMapX(), yP - yM * map.getImgtoMapY());
                }
                for (int q = 0; q < Main.this.jMenu3.getItemCount(); ++q) {
                    JMenuItem item = Main.this.jMenu3.getItem(q);
                    if (item == null || !item.getText().equals(map.getZoomLevel().getName())) continue;
                    item.setSelected(true);
                    break;
                }
            }
        });
        map.addPaintListener(this.paintListener);
        boolean mapLoaded = false;
        if (args.length > 0) {
            if (new File(args[0]).isFile()) {
                this.loadMap(args[0]);
                mapLoaded = true;
            } else {
                JOptionPane.showMessageDialog(map, "Unable to find map file: " + args[0], "Error", 0);
            }
        }
        this.isOnlineJCheckBoxMenuItem.setSelected(this.preferences.getBoolean("isOnlineJCheckBoxMenuItem.selected", true));
        if (!mapLoaded && (mapFile = this.preferences.get("defaultMap", null)) != null) {
            if (new File(mapFile).isFile()) {
                this.loadMap(mapFile);
            } else {
                JOptionPane.showMessageDialog(map, "Unable to find map file: " + mapFile, "Error", 0);
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (map.getMapManager() == null) {
                    return;
                }
                Main.this.preferences.putBoolean("isOnlineJCheckBoxMenuItem.selected", Main.this.isOnlineJCheckBoxMenuItem.isSelected());
                if (Main.this.preferences.getBoolean(map.getMapManager().getPath() + ".saveLastPosition", false)) {
                    Main.this.preferences.put(map.getMapManager().getPath() + ".startPosition", MapManager.point2DToString(map.getMapPos()));
                    Main.this.preferences.put(map.getMapManager().getPath() + ".startZoomLevel", String.valueOf(map.getZoomLevel().getIndex()));
                }
                super.windowClosing(e);
            }
        });
    }

    protected void addPlugin(final MapComponent mc) {
        if (map.getMapManager() == null) {
            return;
        }
        final JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setLayout(new GridLayout());
        final VerticalToggleButton button = new VerticalToggleButton(mc.getName(), false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.closeTabs(button);
                if (((JToggleButton)e.getSource()).isSelected()) {
                    bar.removeAll();
                    bar.add(mc.getSidebarDisplay());
                    JScrollPane pane = new JScrollPane(bar);
                    Main.this.jSplitPane1.setLeftComponent(pane);
                    if (Main.this.jSplitPane1.getLastDividerLocation() > 50) {
                        Main.this.jSplitPane1.setDividerLocation(Main.this.jSplitPane1.getLastDividerLocation());
                    } else {
                        Main.this.jSplitPane1.setDividerLocation(250);
                    }
                }
            }
        });
        this.jToolBar1.add(button);
        this.jToolBar1.setVisible(this.jToolBar1.getComponentCount() != 0);
        final JMenuItem item = new JMenuItem(mc.getName());
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "Are you sure you want to remove the plugin '" + mc.getName() + "' from the map?", "Remove Plugin", 0) == 0) {
                    Main.this.jToolBar1.remove(button);
                    Main.this.jSplitPane1.setDividerLocation(0);
                    Main.this.jMenu6.remove(item);
                    map.getMapManager().removeMapComponent(mc);
                    try {
                        map.getMapManager().save();
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(null, "Error writing to map file.");
                    }
                    Main.this.repaint();
                }
            }
        });
        this.jMenu6.add(item);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.copyMapsDialog = new JDialog((Frame)this, true);
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jSplitPane1 = new JSplitPane();
        this.mapPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem9 = new JMenuItem();
        this.startFromLastLocationCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.isOnlineJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem13 = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jMenuItem10 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem12 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenu4 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jFileChooser1.setName("jFileChooser1");
        this.copyMapsDialog.setTitle("Copy Map");
        this.copyMapsDialog.setBackground(Color.white);
        this.copyMapsDialog.setName("copyMapsDialog");
        this.jLabel1.setText("Select scales to copy:");
        this.jLabel1.setName("jLabel1");
        this.jScrollPane1.setName("jScrollPane1");
        this.jList1.setName("jList1");
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setMnemonic('c');
        this.jButton1.setText("Cancel");
        this.jButton1.setToolTipText("");
        this.jButton1.setName("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setMnemonic('o');
        this.jButton2.setText("OK");
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jButton2ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Download missing tiles");
        this.jCheckBox1.setName("jCheckBox1");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout copyMapsDialogLayout = new GroupLayout(this.copyMapsDialog.getContentPane());
        this.copyMapsDialog.getContentPane().setLayout(copyMapsDialogLayout);
        copyMapsDialogLayout.setHorizontalGroup(copyMapsDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(copyMapsDialogLayout.createSequentialGroup().addContainerGap().addGroup(copyMapsDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(copyMapsDialogLayout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, copyMapsDialogLayout.createSequentialGroup().addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 46, Short.MAX_VALUE).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))).addContainerGap()));
        copyMapsDialogLayout.setVerticalGroup(copyMapsDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(copyMapsDialogLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 218, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(copyMapsDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2).addGroup(copyMapsDialogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jCheckBox1))).addContainerGap()));
        this.setDefaultCloseOperation(3);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(0);
        this.jSplitPane1.setDividerSize(2);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Main.this.jSplitPane1ComponentResized(evt);
            }
        });
        this.mapPanel.setName("mapPanel");
        this.mapPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Main.this.mapPanelComponentResized(evt);
            }
        });
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.jLabel2.setName("jLabel2");
        this.jLabel2.setOpaque(true);
        this.jLabel3.setName("jLabel3");
        this.jLabel3.setOpaque(true);
        this.jLabel4.setName("jLabel4");
        this.jLabel4.setOpaque(true);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4))).addContainerGap(879, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addComponent(this.jLabel4));
        GroupLayout mapPanelLayout = new GroupLayout(this.mapPanel);
        this.mapPanel.setLayout(mapPanelLayout);
        mapPanelLayout.setHorizontalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        mapPanelLayout.setVerticalGroup(mapPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mapPanelLayout.createSequentialGroup().addContainerGap(512, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)));
        this.jSplitPane1.setRightComponent(this.mapPanel);
        this.jToolBar1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.jMenuBar1.setName("jMenuBar1");
        this.jMenu1.setText("File");
        this.jMenu1.setDoubleBuffered(true);
        this.jMenu1.setName("jMenu1");
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem2.setText("Open Map");
        this.jMenuItem2.setName("jMenuItem2");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("Import Map");
        this.jMenuItem3.setName("jMenuItem3");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem3ActionPerformed1(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jSeparator1.setName("jSeparator1");
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem4.setText("Save");
        this.jMenuItem4.setName("jMenuItem3");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.jMenuItem8.setText("Exit");
        this.jMenuItem8.setName("jMenuItem8");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem8);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Map");
        this.jMenu2.setName("jMenu2");
        this.jMenuItem9.setText("Set Home Location");
        this.jMenuItem9.setName("jMenuItem9");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem9);
        this.startFromLastLocationCheckBoxMenuItem.setText("Start From Last Location");
        this.startFromLastLocationCheckBoxMenuItem.setName("startFromLastLocationCheckBoxMenuItem");
        this.startFromLastLocationCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.startFromLastLocationCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.startFromLastLocationCheckBoxMenuItem);
        this.jSeparator5.setName("jSeparator5");
        this.jMenu2.add(this.jSeparator5);
        this.isOnlineJCheckBoxMenuItem.setSelected(true);
        this.isOnlineJCheckBoxMenuItem.setText("Online Mode");
        this.isOnlineJCheckBoxMenuItem.setToolTipText("");
        this.isOnlineJCheckBoxMenuItem.setName("isOnlineJCheckBoxMenuItem");
        this.isOnlineJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.isOnlineJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.isOnlineJCheckBoxMenuItem);
        this.jMenuItem7.setText("Delete Images");
        this.jMenuItem7.setName("jMenuItem7");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem7);
        this.jSeparator4.setName("jSeparator4");
        this.jMenu2.add(this.jSeparator4);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.jMenuItem5.setText("Go To (Map Coordinates)...");
        this.jMenuItem5.setName("jMenuItem5");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem5);
        this.jMenuItem13.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem13.setText("Go To(Latitude/Longitude)...");
        this.jMenuItem13.setName("jMenuItem13");
        this.jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem13ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem13);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu5.setText("Export Map");
        this.jMenu5.setName("jMenu5");
        this.jMenuItem10.setText("Set Start Point");
        this.jMenuItem10.setName("jMenuItem10");
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem10);
        this.jMenuItem11.setText("Set Finish Point");
        this.jMenuItem11.setName("jMenuItem11");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem11);
        this.jSeparator3.setName("jSeparator3");
        this.jMenu5.add(this.jSeparator3);
        this.jMenuItem6.setText("Export to other map");
        this.jMenuItem6.setEnabled(false);
        this.jMenuItem6.setName("jMenuItem6");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem6);
        this.jMenuItem12.setText("Save as image");
        this.jMenuItem12.setEnabled(false);
        this.jMenuItem12.setName("jMenuItem12");
        this.jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem12ActionPerformed(evt);
            }
        });
        this.jMenu5.add(this.jMenuItem12);
        this.jMenuBar1.add(this.jMenu5);
        this.jMenu3.setText("Scale");
        this.jMenu3.setName("jMenu3");
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu4.setText("Plugins");
        this.jMenu4.setName("jMenu4");
        this.jMenuItem1.setText("Add Plugin");
        this.jMenuItem1.setName("jMenuItem1");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu4.add(this.jMenuItem1);
        this.jMenu6.setText("Remove Plugin");
        this.jMenu6.setName("jMenu6");
        this.jMenu4.add(this.jMenu6);
        this.jMenuBar1.add(this.jMenu4);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 23, -2).addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, 887, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1));
        this.pack();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("Open Map");
        FileNameExtensionFilter ff = new FileNameExtensionFilter("JMap Map (.jmap)", "jmap");
        this.jFileChooser1.addChoosableFileFilter(ff);
        this.jFileChooser1.setFileFilter(ff);
        if (this.jFileChooser1.showOpenDialog(map) == 0) {
            this.loadMap(this.jFileChooser1.getSelectedFile().getAbsolutePath());
        }
        this.jFileChooser1.removeChoosableFileFilter(ff);
    }

    private void isOnlineJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        map.setOnline(this.isOnlineJCheckBoxMenuItem.isSelected());
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        if (map.getMapManager() == null) {
            return;
        }
        try {
            map.getMapManager().save();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this.rootPane, "File not found!");
        }
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        Point2D p = map.getZoomLevel().getImageSource().mapGoto(map.getMapPos());
        if (p != null) {
            map.setMapPos(p);
        }
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        map.getMapManager().setStart(map.getZoomLevel().getIndex(), map.getMapPos());
        try {
            map.getMapManager().save();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "File not found!", "Error Saving Map", 0);
        }
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        map.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                double x = map.getMapPos().getX() + (((Point2D)p).getX() - (double)(map.getWidth() / 2)) * map.getImgtoMapX();
                double y = map.getMapPos().getY() + ((double)(map.getHeight() / 2) - ((Point2D)p).getY()) * map.getImgtoMapY();
                Main.this.exportStart = new Point2D.Double(x, y);
                map.removeMouseListener(this);
                Main.this.repaint();
            }
        });
        if (this.exportFinish != null) {
            this.jMenuItem6.setEnabled(true);
            this.jMenuItem12.setEnabled(true);
        }
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        map.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = map.getMousePosition();
                double x = map.getMapPos().getX() + (((Point2D)p).getX() - (double)(map.getWidth() / 2)) * map.getImgtoMapX();
                double y = map.getMapPos().getY() + ((double)(map.getHeight() / 2) - ((Point2D)p).getY()) * map.getImgtoMapY();
                Main.this.exportFinish = new Point2D.Double(x, y);
                map.removeMouseListener(this);
                Main.this.repaint();
            }
        });
        if (this.exportStart != null) {
            this.jMenuItem6.setEnabled(true);
            this.jMenuItem12.setEnabled(true);
        }
    }

    private void jMenuItem12ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("Save Map Extract");
        FileNameExtensionFilter ff = new FileNameExtensionFilter("PNG Images", "png");
        this.jFileChooser1.addChoosableFileFilter(ff);
        this.jFileChooser1.setFileFilter(ff);
        if (this.jFileChooser1.showSaveDialog(this) == 0) {
            String file = this.jFileChooser1.getSelectedFile().getAbsolutePath();
            if (!file.toLowerCase().endsWith(".jpg") || !file.toLowerCase().endsWith(".jpeg")) {
                file = file + ".jpg";
            }
            SaveImg saveImg = new SaveImg(this.exportStart, this.exportFinish, null, map.getZoomLevel(), map.getMapManager(), file, map.isOnline());
            saveImg.start();
        }
        this.jFileChooser1.removeChoosableFileFilter(ff);
    }

    private void mapPanelComponentResized(ComponentEvent evt) {
        map.setSize(this.mapPanel.getWidth(), this.mapPanel.getHeight());
    }

    private void jSplitPane1ComponentResized(ComponentEvent evt) {
        boolean shown = false;
        for (int q = 0; q < this.jToolBar1.getComponentCount(); ++q) {
            Component c = this.jToolBar1.getComponent(q);
            if (!c.getClass().equals(VerticalToggleButton.class) || !((VerticalToggleButton)c).isSelected()) continue;
            shown = true;
        }
        if (!shown) {
            this.jSplitPane1.setDividerLocation(0);
        }
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Delete all displayed images?", "Delete Action", 0) == 0) {
            map.deleteShownImages();
        }
    }

    private void startFromLastLocationCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.preferences.putBoolean(map.getMapManager().getPath() + ".saveLastPosition", this.startFromLastLocationCheckBoxMenuItem.isSelected());
    }

    private void jMenuItem13ActionPerformed(ActionEvent evt) {
        Point2D p = map.getZoomLevel().getImageSource().mapGotoLatLong(map.getMapPos());
        if (p != null) {
            map.setMapPos(p);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("Load Plugin");
        FileNameExtensionFilter ff = new FileNameExtensionFilter("Jar Archive (.jar)", "jar");
        this.jFileChooser1.addChoosableFileFilter(ff);
        this.jFileChooser1.setFileFilter(ff);
        if (this.jFileChooser1.showOpenDialog(this) == 0) {
            try {
                JarFile jarFile = new JarFile(this.jFileChooser1.getSelectedFile());
                Map<String, String> plugins = jarFile.getPlugins();
                JComboBox<Object> comboBox = new JComboBox<Object>(plugins.keySet().toArray());
                if (JOptionPane.showConfirmDialog(null, comboBox, "Select Plugin To Load", 2) == 0) {
                    Plugin p = (Plugin)jarFile.loadClass(plugins.get((String)comboBox.getSelectedItem()));
                    p.configure(map.getMapManager());
                    map.getMapManager().addMapComponent(p);
                    map.getMapManager().addJarFile(jarFile);
                    map.getMapManager().save();
                    this.addPlugin(p);
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.jFileChooser1.removeChoosableFileFilter(ff);
    }

    private void jMenuItem3ActionPerformed1(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("Import Map");
        FileNameExtensionFilter ff = new FileNameExtensionFilter("Jar File (.jar)", "jar");
        this.jFileChooser1.addChoosableFileFilter(ff);
        this.jFileChooser1.setFileFilter(ff);
        if (this.jFileChooser1.showOpenDialog(this) == 0) {
            block30: {
                try {
                    JarFile jarFile = new JarFile(this.jFileChooser1.getSelectedFile());
                    Map<String, String> inputSources = jarFile.getImageSources();
                    JComboBox<Object> comboBox = new JComboBox<Object>(inputSources.keySet().toArray());
                    if (JOptionPane.showConfirmDialog(null, comboBox, "Select Map To Import", 2) != 0) break block30;
                    this.jFileChooser1.removeChoosableFileFilter(ff);
                    this.jFileChooser1.setDialogTitle("Save Map");
                    ff = new FileNameExtensionFilter("JMap Map (.jmap)", "jmap");
                    this.jFileChooser1.addChoosableFileFilter(ff);
                    this.jFileChooser1.setFileFilter(ff);
                    if (this.jFileChooser1.showSaveDialog(this) == 0) {
                        File f = this.jFileChooser1.getSelectedFile();
                        if (!f.getPath().toLowerCase().endsWith(".jmap")) {
                            f = new File(f.getAbsolutePath() + ".jmap");
                        }
                        InputStream inputStream = jarFile.getResource(inputSources.get((String)comboBox.getSelectedItem()).replaceAll("\\.", "/") + ".jmap");
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                             PrintWriter pw = new PrintWriter(f);){
                            String s = br.readLine();
                            while (s != null) {
                                pw.println(s);
                                s = br.readLine();
                            }
                        }
                        MapManager mapManager = new MapManager(f.getAbsolutePath());
                        mapManager.addJarFile(jarFile);
                        mapManager.setupMapManager();
                        mapManager.save();
                        this.loadMap(f.getAbsolutePath());
                    }
                    this.jFileChooser1.removeChoosableFileFilter(ff);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException | SAXException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.jFileChooser1.removeChoosableFileFilter(ff);
        }
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (ZoomLevel zl : map.getMapManager().getZoomLevels()) {
            listModel.add(zl.getIndex(), zl.getName());
        }
        this.jList1.setModel(listModel);
        this.jList1.setSelectedIndex(map.getZoomLevel().getIndex());
        this.copyMapsDialog.pack();
        this.copyMapsDialog.setVisible(true);
        if (!this.copyMap || this.jFileChooser1.showOpenDialog(this) != 0) {
            return;
        }
        MapManager mapManager = null;
        if (this.jFileChooser1.getSelectedFile().exists()) {
            try {
                mapManager = new MapManager(this.jFileChooser1.getSelectedFile().getAbsolutePath());
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.exportFinish.getX() < this.exportStart.getX()) {
            double tmp = this.exportFinish.getX();
            this.exportFinish.setLocation(this.exportStart.getX(), this.exportFinish.getY());
            this.exportStart.setLocation(tmp, this.exportStart.getY());
        }
        if (this.exportFinish.getY() > this.exportStart.getY()) {
            double tmp = this.exportFinish.getY();
            this.exportFinish.setLocation(this.exportFinish.getX(), this.exportStart.getY());
            this.exportStart.setLocation(this.exportStart.getX(), tmp);
        }
        Point2D.Double topleft_imgs = new Point2D.Double(this.exportStart.getX() - this.exportStart.getX() % map.getMapSize().getX(), this.exportStart.getY() - this.exportStart.getY() % map.getMapSize().getY());
        for (int i : this.jList1.getSelectedIndices()) {
            ZoomLevel zl = map.getMapManager().getZoomLevels().get(i);
            for (double x = ((Point2D)topleft_imgs).getX(); x < this.exportFinish.getX(); x += map.getMapSize().getX()) {
                for (double y = ((Point2D)topleft_imgs).getY(); y > this.exportFinish.getY(); y -= map.getMapSize().getY()) {
                    Point2D.Double p = new Point2D.Double(x, y);
                    File f = new File(map.getMapManager().getDirectory() + "/" + zl.getFolderName() + "/" + String.valueOf(((Point2D)p).getX()) + "_" + String.valueOf(((Point2D)p).getY()) + "." + zl.getFileExtension());
                    Image img = null;
                    if (f.exists()) {
                        try {
                            img = ImageIO.read(f);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (this.jCheckBox1.isSelected()) {
                        img = zl.getImageSource().getImage(p, zl);
                    }
                    if (img == null) continue;
                    try {
                        mapManager.saveTile(zl, p, img);
                        continue;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        JOptionPane.showMessageDialog(this, "Finished exporting to other map.");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.copyMapsDialog.setVisible(false);
        this.copyMap = false;
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.copyMapsDialog.setVisible(false);
        this.copyMap = this.jList1.getSelectedIndices().length != 0;
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    private void loadMap(String path) {
        try {
            this.jMenu3.removeAll();
            this.jMenu6.removeAll();
            this.jToolBar1.removeAll();
            MapManager mapManager = new MapManager(path);
            try {
                mapManager.setupMapManager();
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            map.setMapManager(mapManager);
            for (MapComponent mc : mapManager.getMapComponents()) {
                if (!mc.getType().equals((Object)MapComponent.MAP_COMPONENT_TYPE.PLUGIN)) continue;
                this.addPlugin(mc);
            }
            for (final ZoomLevel zl : map.getMapManager().getZoomLevels()) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(zl.getName());
                if (zl.equals(map.getZoomLevel())) {
                    item.setSelected(true);
                }
                this.buttonGroup2.add(item);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        map.setZoomLevel(zl.getIndex());
                        Main.this.jLabel2.setText(map.getCopyrightNotice());
                    }
                });
                this.jMenu3.add(item);
            }
            this.jLabel2.setText(map.getCopyrightNotice());
            if (!this.t.isAlive()) {
                this.t.start();
            }
            map.setOnline(this.isOnlineJCheckBoxMenuItem.isSelected());
            boolean tmpB = this.preferences.getBoolean(map.getMapManager().getPath() + ".saveLastPosition", false);
            this.startFromLastLocationCheckBoxMenuItem.setSelected(tmpB);
            if (tmpB) {
                map.setMapPos(MapManager.stringToPoint2D(this.preferences.get(map.getMapManager().getPath() + ".startPosition", MapManager.point2DToString(map.getMapManager().getStart()))));
                map.setZoomLevel(Integer.parseInt(this.preferences.get(map.getMapManager().getPath() + ".startZoomLevel", String.valueOf(map.getMapManager().getStartZoomLevel()))));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            map.setMapManager(null);
            JOptionPane.showMessageDialog(this, "Error reading map file: " + path + "\nError message: " + ex.getLocalizedMessage(), "Error", 0);
            Logger.getLogger(Main.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private void closeTabs(VerticalToggleButton v) {
        for (Component c : this.jToolBar1.getComponents()) {
            if (!c.getClass().equals(VerticalToggleButton.class) || c.equals(v)) continue;
            this.jSplitPane1.setDividerLocation(0);
            ((VerticalToggleButton)c).setSelected(false);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.setTitle("JMap - Pos: " + map.getZoomLevel().getImageSource().toString(map.getMapPos()) + "(" + map.getMapPos() + "), Zoom Level: " + map.getZoomLevel().getName() + ", Image Scale: " + String.valueOf(map.getScale()));
                    if (this.mouseCaughtPostition != null) {
                        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
                        double x = ((double)mouseLocation.x - this.mouseCaughtPostition.getX()) / (double)map.getWidth();
                        double y = ((double)mouseLocation.y - this.mouseCaughtPostition.getY()) / (double)map.getHeight();
                        int a = 500;
                        int b = 20;
                        double X = (double)a * x * x + (double)b * Math.abs(x);
                        double Y = (double)a * y * y + (double)b * Math.abs(y);
                        if (x > 0.0) {
                            X = -X;
                        }
                        if (y > 0.0) {
                            Y = -Y;
                        }
                        map.scroll((int)X, (int)Y);
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Main(args).setVisible(true);
            }
        });
    }
}

