/*
 * Decompiled with CFR 0.152.
 */
package kb;

import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import java.util.logging.Level;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kb.ClipboardManager;

public class ActivationHotKeyHandler {
    private static final ActivationHotKeyHandler INSTANCE = new ActivationHotKeyHandler();
    private static Provider provider;

    public static ActivationHotKeyHandler getInstance() {
        return INSTANCE;
    }

    private ActivationHotKeyHandler() {
        try {
            Provider.logger.setLevel(Level.SEVERE);
            provider = Provider.getCurrentProvider((boolean)true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void registerActivationHotKey(KeyStroke keyStroke) {
        if (provider == null) {
            return;
        }
        provider.reset();
        if (keyStroke != null) {
            provider.register(keyStroke, new HotKeyListener(){

                public void onHotKey(HotKey arg0) {
                    ActivationHotKeyHandler.this.hotKeyPressed();
                }
            });
        }
    }

    private void hotKeyPressed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClipboardManager.getInstance().showMainFrame();
            }
        });
    }

    public void shutdown() {
        if (provider == null) {
            return;
        }
        try {
            provider.reset();
            provider.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

