/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.util.concurrent.Semaphore;
import kb.clipboard.ClipboardAcessor;
import kb.utils.ExecutorServices;

public final class ClipboardChangeListener {
    private static final long CLIPBOARD_CHANGE_CHECK_INTERVAL = 500L;
    private static final ClipboardChangeListener INSTANCE = new ClipboardChangeListener();
    private final Semaphore semaphore = new Semaphore(1);
    private volatile boolean paused = false;
    private volatile boolean started = false;

    private ClipboardChangeListener() {
    }

    public static ClipboardChangeListener getInstance() {
        return INSTANCE;
    }

    public synchronized void startListening() {
        if (this.started) {
            throw new IllegalStateException("Clipboard change listener is already started.");
        }
        this.started = true;
        this.submitClipboardChangeListening();
    }

    private void submitClipboardChangeListening() {
        ExecutorServices.CLIPBOARD_CHANGE_LISTENER_EXECUTOR_SERVICE.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(500L);
                        ClipboardChangeListener.this.waitIfPaused();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    ClipboardAcessor.checkForClipboardChangeAndWait();
                }
            }
        });
    }

    private void waitIfPaused() throws InterruptedException {
        try {
            this.semaphore.acquire();
        }
        finally {
            this.semaphore.release();
        }
    }

    public synchronized void pauseListening() {
        if (this.paused) {
            throw new IllegalStateException("Clipboard change listener is already paused.");
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.paused = true;
    }

    public synchronized void continueListening() {
        if (!this.paused) {
            throw new IllegalStateException("Clipboard change listener is not paused.");
        }
        this.semaphore.release();
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

