/*
 * Decompiled with CFR 0.152.
 */
package kb;

import kb.ClipboardContent;
import kb.FileNameGenerator;
import kb.utils.ObjectIO;
import kb.utils.Utils;

public abstract class ClipboardItem {
    private static final String ITEM_SUFFIX = "item";
    private final String displayText;
    private final String fileName;
    private volatile String name;
    private volatile boolean deleted;

    public ClipboardItem(String displayText, String fileName, String name) {
        this.displayText = displayText;
        this.fileName = fileName;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void deletePersistedContent() {
        if (this.fileName != null) {
            new ObjectIO().delete(this.fileName);
        }
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected static final String getNewFileName() {
        return FileNameGenerator.generate("history/", ITEM_SUFFIX);
    }

    public abstract ClipboardContent getContent();

    public boolean equalsByValue(ClipboardItem other, ClipboardContent otherContent) {
        if (Utils.areEqualsNullsIncluded(this.getName(), other.getName())) {
            return true;
        }
        String name = this.getName() == null ? "" : this.getName().trim();
        String otherName = other.getName() == null ? "" : other.getName().trim();
        return name.equals(otherName);
    }

    public abstract ClipboardItem createClonedInstance();
}

