/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.io.File;
import javax.swing.ImageIcon;
import kb.ClipboardChangeListener;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.ImageClipboardContent;
import kb.ImageClipboardItem;
import kb.ItemGroup;
import kb.ItemGroupHolder;
import kb.TextClipboardContent;
import kb.TextClipboardItem;
import kb.UserException;
import kb.clipboard.ClipboardAcessor;
import kb.gui.MainFrame;
import kb.gui.ShortcutKeyItem;
import kb.gui.prefs.MyPreferences;
import kb.utils.ObjectIO;

public final class ClipboardManager {
    private static ClipboardManager INSTANCE;
    private ItemGroup clipboardHistory;

    private ClipboardManager() {
        this.loadPrefs();
        this.clipboardHistory = ItemGroupHolder.getInstance().getClipboardHistory();
        ClipboardAcessor.init();
        MainFrame.initInstance();
        this.initCliboardListener();
        this.initShortcutKeys();
        this.createFavoritesGroupIfNeeded();
        this.deleteErrorFilesIfExist();
    }

    private void deleteErrorFilesIfExist() {
        try {
            this.doDeleteErrorFilesIfExists();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doDeleteErrorFilesIfExists() {
        String[] stringArray = new File(System.getProperty("user.dir")).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName.startsWith("hs_err_pid") && fileName.endsWith(".log")) {
                new ObjectIO().delete(fileName);
            }
            ++n2;
        }
    }

    private void createFavoritesGroupIfNeeded() {
        if (this.shouldCreateFavoritesGroup()) {
            try {
                ItemGroupHolder.getInstance().addNewItemGroup("Favorites");
            }
            catch (UserException userException) {
                // empty catch block
            }
        }
    }

    private boolean shouldCreateFavoritesGroup() {
        return ItemGroupHolder.getInstance().getItemGroups().isEmpty() && !MyPreferences.INSTANCE.areAllGroupsManuallyDeleted();
    }

    private void initShortcutKeys() {
        ShortcutKeyItem.reinitShortcutKeys();
    }

    private void loadPrefs() {
        ShortcutKeyItem.loadPersistedState();
    }

    public static void start() {
        if (INSTANCE == null) {
            INSTANCE = new ClipboardManager();
        }
    }

    public static ClipboardManager getInstance() {
        return INSTANCE;
    }

    private void initCliboardListener() {
        if (MyPreferences.INSTANCE.isPaused()) {
            MainFrame.getInstance().pauseClipboardChangeTracking();
        }
        ClipboardChangeListener.getInstance().startListening();
    }

    public void clipboardChanged(ClipboardContent clipboardContent) {
        try {
            this.clipboardHistory.addOrMoveItemToTop(this.createClipboardItem(clipboardContent));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private ClipboardItem createClipboardItem(ClipboardContent clipboardContent) {
        if (clipboardContent instanceof TextClipboardContent) {
            return new TextClipboardItem(((TextClipboardContent)clipboardContent).getText());
        }
        return new ImageClipboardItem(new ImageIcon(((ImageClipboardContent)clipboardContent).getImage()));
    }

    public void showMainFrame() {
        MainFrame.getInstance().showFrame();
    }

    public void copyToClipboard(String text) {
        TextClipboardContent clipboardContent = new TextClipboardContent(text);
        ClipboardAcessor.writeToClipboard(clipboardContent);
        this.clipboardChanged(clipboardContent);
    }
}

