/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import kb.ClipboardManager;
import kb.utils.ExecutorServices;

public class ExternEventListener {
    public static final int PORT = 57521;

    public static boolean start() {
        try {
            ServerSocket serverSocket = new ServerSocket(57521);
            ExternEventListener.startListening(serverSocket);
            return true;
        }
        catch (IOException e) {
            ExternEventListener.sendShowMainFrameEvent();
            return false;
        }
    }

    private static void startListening(ServerSocket serverSocket) {
        ExecutorServices.EXTERN_EVENT_LISTENTER.submit(ExternEventListener.createExternEventListenerRunnable(serverSocket));
    }

    private static Runnable createExternEventListenerRunnable(final ServerSocket serverSocket) {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    ExternEventListener.listen(serverSocket);
                }
            }
        };
    }

    private static void listen(ServerSocket serverSocket) {
        Socket socket = null;
        try {
            try {
                socket = serverSocket.accept();
                ExternEventListener.showMainFrame();
            }
            catch (IOException iOException) {
                ExternEventListener.closeSocket(socket);
            }
        }
        finally {
            ExternEventListener.closeSocket(socket);
        }
    }

    private static void closeSocket(Socket socket) {
        if (socket != null) {
            ExternEventListener.closeIgnoreException(socket);
        }
    }

    private static void closeIgnoreException(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void showMainFrame() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClipboardManager clipboardManager = ClipboardManager.getInstance();
                if (clipboardManager != null) {
                    clipboardManager.showMainFrame();
                }
            }
        });
    }

    private static void sendShowMainFrameEvent() {
        block5: {
            Socket socket = null;
            try {
                try {
                    socket = new Socket(InetAddress.getLocalHost(), 57521);
                }
                catch (IOException iOException) {
                    ExternEventListener.closeSocket(socket);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                ExternEventListener.closeSocket(socket);
                throw throwable;
            }
            ExternEventListener.closeSocket(socket);
        }
    }
}

