/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.awt.Image;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.ImageIcon;
import kb.ClipboardContent;
import kb.ClipboardItem;
import kb.FileNameGenerator;
import kb.ImageClipboardContent;
import kb.utils.ObjectIO;
import kb.utils.Utils;

public class ImageClipboardItem
extends ClipboardItem {
    private final String previewFileName;
    private final String hash;

    public ImageClipboardItem(String displayText, String fileName, String name, String previewFileName, String hash) {
        super(displayText, fileName, name);
        this.previewFileName = previewFileName;
        this.hash = hash;
    }

    public ImageClipboardItem(ImageIcon imageIcon) {
        super(ImageClipboardItem.createDisplayName(imageIcon), ImageClipboardItem.createFile(imageIcon), null);
        this.hash = this.calculateHash();
        this.previewFileName = this.createPreviewFile(imageIcon);
    }

    private String calculateHash() {
        ImageIcon imageIcon = this.getImageIcon();
        if (imageIcon == null) {
            throw new RuntimeException();
        }
        byte[] imageBytes = Utils.getByteArray(imageIcon.getImage());
        return this.getHexHash(this.getMD5Bytes(imageBytes));
    }

    private String getHexHash(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            String hex = Integer.toHexString(aByte);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            result.append(hex);
            ++n2;
        }
        return result.toString();
    }

    private byte[] getMD5Bytes(byte[] bytes) {
        try {
            return MessageDigest.getInstance("MD5").digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException();
        }
    }

    private static String createDisplayName(ImageIcon imageIcon) {
        return "<image " + imageIcon.getImage().getWidth(null) + " x " + imageIcon.getImage().getHeight(null) + ">";
    }

    private static String createFile(ImageIcon imageIcon) {
        String fileName = ImageClipboardItem.getNewFileName();
        new ObjectIO().saveImage(imageIcon.getImage(), fileName);
        return fileName;
    }

    private String createPreviewFile(ImageIcon imageIcon) {
        String fileName = FileNameGenerator.generate("history/", "imgpr");
        new ObjectIO().savePreviewImage(imageIcon.getImage(), fileName);
        return fileName;
    }

    @Override
    public ImageClipboardContent getContent() {
        return new ImageClipboardContent(this.getFileName());
    }

    @Override
    public boolean equalsByValue(ClipboardItem other, ClipboardContent otherContent) {
        if (!super.equalsByValue(other, otherContent)) {
            return false;
        }
        if (!(other instanceof ImageClipboardItem)) {
            return false;
        }
        ImageClipboardItem imageItem = (ImageClipboardItem)other;
        return this.hash.equals(imageItem.hash);
    }

    @Override
    public ImageClipboardItem createClonedInstance() {
        ImageClipboardItem result = new ImageClipboardItem(this.getImageIcon());
        result.setName(this.getName());
        return result;
    }

    private ImageIcon getImageIcon() {
        Image resultImage = new ObjectIO().readImage(this.getFileName());
        return resultImage != null ? new ImageIcon(resultImage) : null;
    }

    public String getPreviewFileName() {
        return this.previewFileName;
    }

    public Image getPreviewImage() {
        return new ObjectIO().readImage(this.previewFileName);
    }

    @Override
    public void deletePersistedContent() {
        super.deletePersistedContent();
        new ObjectIO().delete(this.previewFileName);
    }

    public String getHash() {
        return this.hash;
    }
}

