/*
 * Decompiled with CFR 0.152.
 */
package kb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import kb.ClipboardContent;
import kb.ClipboardHistoryPersistor;
import kb.ClipboardItem;
import kb.ListPersistor;
import kb.utils.Observable;

public class ItemGroup {
    private final LinkedList<ClipboardItem> items;
    private final Observable<List<ClipboardItem>> observable = new Observable();
    private final String fileName;
    private final ListPersistor<ClipboardItem> itemsPersistor = new ClipboardHistoryPersistor();
    private int maxSize = 3000;

    public ItemGroup(String fileName) {
        this.fileName = fileName;
        this.items = new LinkedList<ClipboardItem>(this.itemsPersistor.readFromDisk(fileName));
    }

    private void addNewItem(ClipboardItem clipboardItem) {
        this.items.addFirst(clipboardItem);
        this.deleteOutOfGroupSizeItem();
        this.itemsChanged();
    }

    private void deleteOutOfGroupSizeItem() {
        if (this.items.size() > this.maxSize) {
            this.items.removeLast().deletePersistedContent();
        }
    }

    public void itemsChanged() {
        this.storeToDisk();
        this.observable.updateObservers(this.getItems());
    }

    public List<ClipboardItem> getItems() {
        return new ArrayList<ClipboardItem>(this.items);
    }

    private void storeToDisk() {
        this.itemsPersistor.storeToDisc(this.items, this.fileName);
    }

    private boolean moveToTopIfExists(ClipboardItem clipboardItem) {
        ClipboardItem existingItem = this.removeItemIfExisits(clipboardItem);
        if (existingItem != null) {
            this.items.addFirst(existingItem);
            this.itemsChanged();
            return true;
        }
        return false;
    }

    private ClipboardItem removeItemIfExisits(ClipboardItem clipboardItem) {
        ClipboardContent content = clipboardItem.getContent();
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            ClipboardItem existingClipboardItem = (ClipboardItem)it.next();
            if (!existingClipboardItem.equalsByValue(clipboardItem, content)) continue;
            it.remove();
            return existingClipboardItem;
        }
        return null;
    }

    public void moveExistingItemToTop(ClipboardItem clipboardItem) {
        this.removeExistingItem(clipboardItem);
        this.items.addFirst(clipboardItem);
        this.deleteOutOfGroupSizeItem();
        this.itemsChanged();
    }

    private ClipboardItem removeExistingItem(ClipboardItem clipboardItem) {
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            ClipboardItem existingClipboardItem = (ClipboardItem)it.next();
            if (existingClipboardItem != clipboardItem) continue;
            it.remove();
            return existingClipboardItem;
        }
        return null;
    }

    public Observable<List<ClipboardItem>> getObservable() {
        return this.observable;
    }

    public void deleteItem(ClipboardItem clipboardItem) {
        ClipboardItem existingItem = this.removeExistingItem(clipboardItem);
        if (existingItem != null) {
            existingItem.deletePersistedContent();
            this.itemsChanged();
        }
    }

    public void addOrMoveItemToTop(ClipboardItem clipboardItem) {
        if (this.moveToTopIfExists(clipboardItem)) {
            clipboardItem.deletePersistedContent();
        } else {
            this.addNewItem(clipboardItem);
        }
    }

    public void replaceItem(ClipboardItem itemToBeReplaced, ClipboardItem newItem) {
        int itemToRemoveIndex = this.getItemIndex(itemToBeReplaced);
        if (itemToRemoveIndex >= 0) {
            this.items.set(itemToRemoveIndex, newItem);
            itemToBeReplaced.deletePersistedContent();
            this.itemsChanged();
        }
    }

    private int getItemIndex(ClipboardItem item) {
        int result = 0;
        for (ClipboardItem current : this.items) {
            if (current == item) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void moveUp(ClipboardItem clipboardItem) {
        ListIterator<ClipboardItem> iterator = this.items.listIterator();
        while (iterator.hasNext()) {
            ClipboardItem existingClipboardItem = (ClipboardItem)iterator.next();
            if (clipboardItem != existingClipboardItem) continue;
            iterator.remove();
            if (iterator.hasPrevious()) {
                iterator.previous();
            }
            iterator.add(existingClipboardItem);
            this.itemsChanged();
            break;
        }
    }

    public void moveDown(ClipboardItem clipboardItem) {
        ListIterator<ClipboardItem> iterator = this.items.listIterator();
        while (iterator.hasNext()) {
            ClipboardItem existingClipboardItem = (ClipboardItem)iterator.next();
            if (clipboardItem != existingClipboardItem) continue;
            iterator.remove();
            if (iterator.hasNext()) {
                iterator.next();
            }
            iterator.add(existingClipboardItem);
            this.itemsChanged();
            break;
        }
    }

    public void setMaxGroupSize(int maxSize) {
        if (this.maxSize != maxSize) {
            this.maxSize = maxSize;
            int itemsToBeDeletedCount = this.items.size() - maxSize;
            int i = 0;
            while (i < itemsToBeDeletedCount) {
                this.items.removeLast().deletePersistedContent();
                ++i;
            }
            if (itemsToBeDeletedCount > 0) {
                this.itemsChanged();
            }
        }
    }
}

